/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.commons.transaction.util.FileHelper;
import org.apache.commons.transaction.util.LoggerFacade;

public class FileSequence {
    protected final String storeDir;
    protected final LoggerFacade logger;

    public FileSequence(String storeDir, LoggerFacade logger) throws ResourceManagerException {
        this.storeDir = storeDir;
        this.logger = logger;
        File file = new File(storeDir);
        file.mkdirs();
        if (!file.exists()) {
            throw new ResourceManagerException("Can not create working directory " + storeDir);
        }
    }

    public synchronized boolean exists(String sequenceName) {
        String pathI = this.getPathI(sequenceName);
        String pathII = this.getPathII(sequenceName);
        return FileHelper.fileExists(pathI) || FileHelper.fileExists(pathII);
    }

    public synchronized boolean create(String sequenceName, long initialValue) throws ResourceManagerException {
        if (this.exists(sequenceName)) {
            return false;
        }
        this.write(sequenceName, initialValue);
        return true;
    }

    public synchronized boolean delete(String sequenceName) {
        if (!this.exists(sequenceName)) {
            return false;
        }
        String pathI = this.getPathI(sequenceName);
        String pathII = this.getPathII(sequenceName);
        boolean res1 = FileHelper.deleteFile(pathI);
        boolean res2 = FileHelper.deleteFile(pathII);
        return res1 || res2;
    }

    public synchronized long nextSequenceValueBottom(String sequenceName, long increment) throws ResourceManagerException {
        if (!this.exists(sequenceName)) {
            throw new ResourceManagerException("Sequence " + sequenceName + " does not exist");
        }
        if (increment <= 0L) {
            throw new IllegalArgumentException("Increment must be greater than 0, was " + increment);
        }
        long value = this.read(sequenceName);
        long newValue = value + increment;
        this.write(sequenceName, newValue);
        return value;
    }

    protected long read(String sequenceName) throws ResourceManagerException {
        long returnValue;
        block13: {
            String pathI = this.getPathI(sequenceName);
            String pathII = this.getPathII(sequenceName);
            returnValue = -1L;
            long valueI = -1L;
            if (FileHelper.fileExists(pathI)) {
                try {
                    valueI = this.readFromPath(pathI);
                }
                catch (NumberFormatException e) {
                    throw new ResourceManagerException("Fatal internal error: Backup sequence value corrupted");
                }
                catch (FileNotFoundException e) {
                    throw new ResourceManagerException("Fatal internal error: Backup sequence vanished");
                }
                catch (IOException e) {
                    throw new ResourceManagerException("Fatal internal error: Backup sequence value corrupted");
                }
            }
            long valueII = -1L;
            if (FileHelper.fileExists(pathII)) {
                try {
                    valueII = this.readFromPath(pathII);
                    if (valueII > valueI) {
                        returnValue = valueII;
                        break block13;
                    }
                    this.logger.logWarning("Latest sequence value smaller than previous, reverting to previous");
                    FileHelper.deleteFile(pathII);
                    returnValue = valueI;
                }
                catch (NumberFormatException e) {
                    this.logger.logWarning("Latest sequence value corrupted, reverting to previous");
                    FileHelper.deleteFile(pathII);
                    returnValue = valueI;
                }
                catch (FileNotFoundException e) {
                    this.logger.logWarning("Can not find latest sequence value, reverting to previous");
                    FileHelper.deleteFile(pathII);
                    returnValue = valueI;
                }
                catch (IOException e) {
                    this.logger.logWarning("Can not read latest sequence value, reverting to previous");
                    FileHelper.deleteFile(pathII);
                    returnValue = valueI;
                }
            } else {
                this.logger.logWarning("Can not read latest sequence value, reverting to previous");
                returnValue = valueI;
            }
        }
        if (returnValue != -1L) {
            return returnValue;
        }
        throw new ResourceManagerException("Fatal internal error: Could not compute valid sequence value");
    }

    protected void write(String sequenceName, long value) throws ResourceManagerException {
        String pathII = this.getPathII(sequenceName);
        File f2 = new File(pathII);
        if (f2.exists()) {
            String pathI = this.getPathI(sequenceName);
            File f1 = new File(pathI);
            f1.delete();
            if (!f2.renameTo(f1)) {
                throw new ResourceManagerException("Fatal internal error: Can not create backup value at" + pathI);
            }
        }
        try {
            if (!f2.createNewFile()) {
                throw new ResourceManagerException("Fatal internal error: Can not create new value at" + pathII);
            }
        }
        catch (IOException e) {
            throw new ResourceManagerException("Fatal internal error: Can not create new value at" + pathII, e);
        }
        this.writeToPath(pathII, value);
    }

    protected String getPathI(String sequenceName) {
        return this.storeDir + "/" + sequenceName + "_1.seq";
    }

    protected String getPathII(String sequenceName) {
        return this.storeDir + "/" + sequenceName + "_2.seq";
    }

    protected long readFromPath(String path) throws ResourceManagerException, NumberFormatException, FileNotFoundException, IOException {
        File file = new File(path);
        BufferedReader reader = null;
        try {
            long value;
            FileInputStream is = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            String valueString = reader.readLine();
            long l = value = Long.parseLong(valueString);
            return l;
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceManagerException("Fatal internal error, encoding UTF-8 unknown");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void writeToPath(String path, long value) throws ResourceManagerException {
        File file = new File(path);
        BufferedWriter writer = null;
        try {
            FileOutputStream os = new FileOutputStream(file);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
            String valueString = Long.toString(value);
            writer.write(valueString);
            writer.write(10);
        }
        catch (FileNotFoundException e) {
            throw new ResourceManagerException("Fatal internal error: Can not find sequence at " + path);
        }
        catch (IOException e) {
            throw new ResourceManagerException("Fatal internal error: Can not write to sequence at " + path);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

