/*
 * Decompiled with CFR 0.152.
 */
package com.edb.util;

import com.edb.core.Utils;
import com.edb.jdbc2.Struct;
import com.edb.util.StructParser;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class StructUtils {
    public static java.sql.Struct toStruct(String structValue, String typeName) {
        List al = StructParser.parse(structValue);
        return new Struct(al, typeName);
    }

    public static String toString(java.sql.Struct struct, boolean standardConformingStrings, boolean supportsEStringSyntax) throws SQLException {
        return StructUtils.toString(struct, standardConformingStrings, supportsEStringSyntax, "\"", 0);
    }

    private static String toString(java.sql.Struct struct, boolean standardConformingStrings, boolean supportsEStringSyntax, String quotes, int level) throws SQLException {
        if (struct == null || struct.getAttributes() == null) {
            return null;
        }
        String output = "";
        output = output + "(";
        Object[] attributes = struct.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            String param;
            if (i > 0) {
                output = output + ",";
            }
            if (attributes[i] == null) {
                output = output + "null";
                continue;
            }
            if (attributes[i] instanceof Number) {
                output = output + attributes[i];
                continue;
            }
            if (attributes[i] instanceof java.sql.Struct) {
                String nextQuotes = quotes + quotes;
                String param2 = StructUtils.toString((java.sql.Struct)attributes[i], standardConformingStrings, supportsEStringSyntax, nextQuotes, level + 1);
                output = output + quotes + param2 + quotes;
                continue;
            }
            if (attributes[i] instanceof Array) {
                param = attributes[i].toString();
                String innerQuotes = quotes + quotes;
                output = output + quotes + StructUtils.increaseLevel(param, 2002, innerQuotes) + quotes;
                continue;
            }
            param = attributes[i].toString();
            boolean hasBackslash = param.indexOf(92) != -1;
            StringBuffer p = new StringBuffer(3 + param.length() * 11 / 10);
            if (hasBackslash && !standardConformingStrings && supportsEStringSyntax) {
                p.append('E');
            }
            try {
                p = Utils.appendEscapedLiteral(p, param, standardConformingStrings);
            }
            catch (SQLException sqle) {
                throw new IllegalArgumentException(sqle.toString());
            }
            if (p.toString().contains("\"")) {
                String outerQuotes = quotes;
                String innerQuotes = quotes + quotes;
                output = output + outerQuotes + p.toString().replace("\"", innerQuotes) + outerQuotes;
                continue;
            }
            output = output + p.toString();
        }
        output = output + ")";
        return output;
    }

    private static String getQuotes(int level) {
        String quotes = "\"";
        for (int i = 0; i < level; ++i) {
            quotes = quotes + "\"";
        }
        return quotes;
    }

    private static String increaseLevel(String attribute, int type, String quote) {
        return StructUtils.adjustLevel(attribute, type, quote, false);
    }

    public static String adjustLevel(String attribute, int type) {
        return StructUtils.adjustLevel(attribute, type, "\"", false);
    }

    public static String normalizeLevel(String attribute, int type) {
        return StructUtils.adjustLevel(attribute, type, "\"", true);
    }

    private static String adjustLevel(String attribute, int type, String quote, boolean normalize) {
        StringBuilder buffer = new StringBuilder();
        StringBuilder tempBuffer = null;
        char[] chars = attribute.toCharArray();
        ArrayList<Integer> lastType = new ArrayList<Integer>();
        lastType.add(type);
        ArrayList<String> lastQuote = new ArrayList<String>();
        lastQuote.add(quote);
        String replacedQuote = quote;
        int level = 0;
        int calculatedLevel = 0;
        int firstCalculatedLevel = -2;
        for (int i = 0; i < chars.length; ++i) {
            tempBuffer = null;
            boolean quoteFound = false;
            while (chars[i] == '\\' || chars[i] == '\"') {
                if (tempBuffer == null) {
                    tempBuffer = new StringBuilder();
                }
                tempBuffer.append(chars[i]);
                if ((firstCalculatedLevel < 0 || (double)tempBuffer.length() != Math.pow(2.0, level + firstCalculatedLevel)) && ++i != chars.length) continue;
            }
            if (tempBuffer != null) {
                --i;
                int length = tempBuffer.length();
                calculatedLevel = StructUtils.log(length, 2);
                if (firstCalculatedLevel == -2) {
                    firstCalculatedLevel = calculatedLevel;
                    if (level == 0) {
                        ++firstCalculatedLevel;
                    }
                }
                if (!normalize) {
                    replacedQuote = calculatedLevel - firstCalculatedLevel >= 0 ? (String)lastQuote.get(calculatedLevel - firstCalculatedLevel) : "";
                    while (calculatedLevel - firstCalculatedLevel < level - 1) {
                        lastQuote.remove(level);
                        lastType.remove(level);
                        --level;
                    }
                } else {
                    replacedQuote = level == 0 ? "" : "\"";
                    while (calculatedLevel - firstCalculatedLevel < level - 1) {
                        --level;
                    }
                }
                buffer.append(replacedQuote);
                quoteFound = true;
            }
            if (quoteFound) continue;
            if (level <= calculatedLevel + 1) {
                if ('{' == chars[i]) {
                    if (!normalize) {
                        lastType.add(2003);
                        replacedQuote = StructUtils.getNextQuotes((String)lastQuote.get(level), 2003);
                        lastQuote.add(replacedQuote);
                    }
                    ++level;
                } else if ('(' == chars[i]) {
                    if (!normalize) {
                        lastType.add(2002);
                        replacedQuote = StructUtils.getNextQuotes((String)lastQuote.get(level), 2002);
                        lastQuote.add(replacedQuote);
                    }
                    ++level;
                }
            }
            buffer.append(chars[i]);
        }
        return buffer.toString();
    }

    private static String getNextQuotes(String lastQuotes, int lastType) {
        StringBuilder quotes = new StringBuilder();
        if (lastQuotes.length() == 0) {
            return "\"";
        }
        if (lastType == 2003) {
            int length = lastQuotes.length();
            for (int i = 0; i < length; ++i) {
                quotes.append('\\');
            }
            quotes.append(lastQuotes);
        } else {
            quotes.append(lastQuotes).append(lastQuotes);
        }
        return quotes.toString();
    }

    private static int log(int x, int base) {
        return (int)(Math.log(x) / Math.log(base));
    }
}

