/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway;

import java.util.List;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.index.store.StoreFileMetaData;

public class CommitPoint {
    public static final CommitPoint NULL = new CommitPoint(-1L, "_null_", Type.GENERATED, ImmutableList.<FileInfo>of(), ImmutableList.<FileInfo>of());
    private final long version;
    private final String name;
    private final Type type;
    private final ImmutableList<FileInfo> indexFiles;
    private final ImmutableList<FileInfo> translogFiles;

    public CommitPoint(long version, String name, Type type, List<FileInfo> indexFiles, List<FileInfo> translogFiles) {
        this.version = version;
        this.name = name;
        this.type = type;
        this.indexFiles = ImmutableList.copyOf(indexFiles);
        this.translogFiles = ImmutableList.copyOf(translogFiles);
    }

    public long version() {
        return this.version;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public ImmutableList<FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public ImmutableList<FileInfo> translogFiles() {
        return this.translogFiles;
    }

    public boolean containPhysicalIndexFile(String physicalName) {
        return this.findPhysicalIndexFile(physicalName) != null;
    }

    public FileInfo findPhysicalIndexFile(String physicalName) {
        for (FileInfo file : this.indexFiles) {
            if (!file.physicalName().equals(physicalName)) continue;
            return file;
        }
        return null;
    }

    public FileInfo findNameFile(String name) {
        FileInfo fileInfo = this.findNameIndexFile(name);
        if (fileInfo != null) {
            return fileInfo;
        }
        return this.findNameTranslogFile(name);
    }

    public FileInfo findNameIndexFile(String name) {
        for (FileInfo file : this.indexFiles) {
            if (!file.name().equals(name)) continue;
            return file;
        }
        return null;
    }

    public FileInfo findNameTranslogFile(String name) {
        for (FileInfo file : this.translogFiles) {
            if (!file.name().equals(name)) continue;
            return file;
        }
        return null;
    }

    public static enum Type {
        GENERATED,
        SAVED;

    }

    public static class FileInfo {
        private final String name;
        private final String physicalName;
        private final long length;
        private final String checksum;

        public FileInfo(String name, String physicalName, long length, String checksum) {
            this.name = name;
            this.physicalName = physicalName;
            this.length = length;
            this.checksum = checksum;
        }

        public String name() {
            return this.name;
        }

        public String physicalName() {
            return this.physicalName;
        }

        public long length() {
            return this.length;
        }

        @Nullable
        public String checksum() {
            return this.checksum;
        }

        public boolean isSame(StoreFileMetaData md) {
            if (this.checksum == null || md.checksum() == null) {
                return false;
            }
            return this.length == md.length() && this.checksum.equals(md.checksum());
        }
    }
}

