/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class Murmur3FieldMapper
extends LongFieldMapper {
    public static final String CONTENT_TYPE = "murmur3";

    protected Murmur3FieldMapper(FieldMapper.Names names, int precisionStep, float boost, FieldType fieldType, Boolean docValues, Long nullValue, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings, AbstractFieldMapper.MultiFields multiFields, AbstractFieldMapper.CopyTo copyTo) {
        super(names, precisionStep, boost, fieldType, docValues, nullValue, ignoreMalformed, coerce, postingsProvider, docValuesProvider, similarity, normsLoading, fieldDataSettings, indexSettings, multiFields, copyTo);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        Object value = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (value != null) {
            BytesRef bytes = new BytesRef((CharSequence)value.toString());
            long hash = MurmurHash3.hash128((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
            context.externalValue(hash);
            super.innerParseCreateField(context, fields);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.murmur3Field(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, Murmur3FieldMapper> {
        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
            ((Builder)this.builder).precisionStep(Integer.MAX_VALUE);
        }

        @Override
        public Murmur3FieldMapper build(Mapper.BuilderContext context) {
            this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.boost == 1.0f);
            Murmur3FieldMapper fieldMapper = new Murmur3FieldMapper(this.buildNames(context), this.precisionStep, this.boost, this.fieldType, this.docValues, -1L, this.ignoreMalformed(context), this.coerce(context), this.postingsProvider, this.docValuesProvider, this.similarity, this.normsLoading, this.fieldDataSettings, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends LongFieldMapper.Defaults {
    }
}

