/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.object.ArrayValueMapperParser;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class GeoPointFieldMapper
extends AbstractFieldMapper<GeoPoint>
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "geo_point";
    private final ContentPath.Type pathType;
    private final boolean enableLatLon;
    private final boolean enableGeoHash;
    private final boolean enableGeohashPrefix;
    private final Integer precisionStep;
    private final int geoHashPrecision;
    private final DoubleFieldMapper latMapper;
    private final DoubleFieldMapper lonMapper;
    private final StringFieldMapper geohashMapper;
    private final boolean validateLon;
    private final boolean validateLat;
    private final boolean normalizeLon;
    private final boolean normalizeLat;

    public GeoPointFieldMapper(FieldMapper.Names names, FieldType fieldType, Boolean docValues, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider postingsFormat, DocValuesFormatProvider docValuesFormat, SimilarityProvider similarity, @Nullable Settings fieldDataSettings, Settings indexSettings, ContentPath.Type pathType, boolean enableLatLon, boolean enableGeoHash, boolean enableGeohashPrefix, Integer precisionStep, int geoHashPrecision, DoubleFieldMapper latMapper, DoubleFieldMapper lonMapper, StringFieldMapper geohashMapper, boolean validateLon, boolean validateLat, boolean normalizeLon, boolean normalizeLat, AbstractFieldMapper.MultiFields multiFields) {
        super(names, 1.0f, fieldType, docValues, null, indexAnalyzer, postingsFormat, docValuesFormat, similarity, null, fieldDataSettings, indexSettings, multiFields, null);
        this.pathType = pathType;
        this.enableLatLon = enableLatLon;
        this.enableGeoHash = enableGeoHash || enableGeohashPrefix;
        this.enableGeohashPrefix = enableGeohashPrefix;
        this.precisionStep = precisionStep;
        this.geoHashPrecision = geoHashPrecision;
        this.latMapper = latMapper;
        this.lonMapper = lonMapper;
        this.geohashMapper = geohashMapper;
        this.validateLat = validateLat;
        this.validateLon = validateLon;
        this.normalizeLat = normalizeLat;
        this.normalizeLon = normalizeLon;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType(CONTENT_TYPE);
    }

    public DoubleFieldMapper latMapper() {
        return this.latMapper;
    }

    public DoubleFieldMapper lonMapper() {
        return this.lonMapper;
    }

    public StringFieldMapper geoHashStringMapper() {
        return this.geohashMapper;
    }

    int geoHashPrecision() {
        return this.geoHashPrecision;
    }

    public boolean isEnableLatLon() {
        return this.enableLatLon;
    }

    public boolean isEnableGeohashPrefix() {
        return this.enableGeohashPrefix;
    }

    @Override
    public GeoPoint value(Object value) {
        if (value instanceof GeoPoint) {
            return (GeoPoint)value;
        }
        return GeoPoint.parseFromLatLon(value.toString());
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(this.pathType);
        context.path().add(this.name());
        GeoPoint sparse = context.parseExternalValue(GeoPoint.class);
        if (sparse != null) {
            this.parse(context, sparse, null);
        } else {
            sparse = new GeoPoint();
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                token = context.parser().nextToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    while (token != XContentParser.Token.END_ARRAY) {
                        this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
                        token = context.parser().nextToken();
                    }
                } else if (token == XContentParser.Token.VALUE_NUMBER) {
                    double lon = context.parser().doubleValue();
                    token = context.parser().nextToken();
                    double lat = context.parser().doubleValue();
                    while ((token = context.parser().nextToken()) != XContentParser.Token.END_ARRAY) {
                    }
                    this.parse(context, sparse.reset(lat, lon), null);
                } else {
                    while (token != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            this.parsePointFromString(context, sparse, context.parser().text());
                        } else {
                            this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
                        }
                        token = context.parser().nextToken();
                    }
                }
            } else if (token == XContentParser.Token.VALUE_STRING) {
                this.parsePointFromString(context, sparse, context.parser().text());
            } else {
                this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
            }
        }
        context.path().remove();
        context.path().pathType(origPathType);
    }

    private void parseGeohashField(ParseContext context, String geohash) throws IOException {
        int len = Math.min(this.geoHashPrecision, geohash.length());
        int min = this.enableGeohashPrefix ? 1 : geohash.length();
        for (int i = len; i >= min; --i) {
            context.externalValue(geohash.substring(0, i));
            this.geohashMapper.parse(context);
        }
    }

    private void parsePointFromString(ParseContext context, GeoPoint sparse, String point) throws IOException {
        if (point.indexOf(44) < 0) {
            this.parse(context, sparse.resetFromGeoHash(point), point);
        } else {
            this.parse(context, sparse.resetFromString(point), null);
        }
    }

    private void parse(ParseContext context, GeoPoint point, String geohash) throws IOException {
        CustomGeoPointDocValuesField field;
        if (this.normalizeLat || this.normalizeLon) {
            GeoUtils.normalizePoint(point, this.normalizeLat, this.normalizeLon);
        }
        if (this.validateLat && (point.lat() > 90.0 || point.lat() < -90.0)) {
            throw new ElasticsearchIllegalArgumentException("illegal latitude value [" + point.lat() + "] for " + this.name());
        }
        if (this.validateLon && (point.lon() > 180.0 || point.lon() < -180.0)) {
            throw new ElasticsearchIllegalArgumentException("illegal longitude value [" + point.lon() + "] for " + this.name());
        }
        if (this.fieldType.indexed() || this.fieldType.stored()) {
            field = new Field(this.names.indexName(), Double.toString(point.lat()) + ',' + Double.toString(point.lon()), this.fieldType);
            context.doc().add(field);
        }
        if (this.enableGeoHash) {
            if (geohash == null) {
                geohash = GeoHashUtils.encode(point.lat(), point.lon());
            }
            this.parseGeohashField(context, geohash);
        }
        if (this.enableLatLon) {
            context.externalValue(point.lat());
            this.latMapper.parse(context);
            context.externalValue(point.lon());
            this.lonMapper.parse(context);
        }
        if (this.hasDocValues()) {
            field = (CustomGeoPointDocValuesField)context.doc().getByKey(this.names().indexName());
            if (field == null) {
                field = new CustomGeoPointDocValuesField(this.names().indexName(), point.lat(), point.lon());
                context.doc().addWithKey(this.names().indexName(), field);
            } else {
                field.add(point.lat(), point.lon());
            }
        }
        this.multiFields.parse(this, context);
    }

    @Override
    public void close() {
        super.close();
        if (this.latMapper != null) {
            this.latMapper.close();
        }
        if (this.lonMapper != null) {
            this.lonMapper.close();
        }
        if (this.geohashMapper != null) {
            this.geohashMapper.close();
        }
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        super.traverse(fieldMapperListener);
        if (this.enableGeoHash) {
            this.geohashMapper.traverse(fieldMapperListener);
        }
        if (this.enableLatLon) {
            this.latMapper.traverse(fieldMapperListener);
            this.lonMapper.traverse(fieldMapperListener);
        }
    }

    @Override
    public void traverse(ObjectMapperListener objectMapperListener) {
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase(Locale.ROOT));
        }
        if (includeDefaults || this.enableLatLon) {
            builder.field("lat_lon", this.enableLatLon);
        }
        if (includeDefaults || this.enableGeoHash) {
            builder.field("geohash", this.enableGeoHash);
        }
        if (includeDefaults || this.enableGeohashPrefix) {
            builder.field("geohash_prefix", this.enableGeohashPrefix);
        }
        if (includeDefaults || this.geoHashPrecision != 12) {
            builder.field("geohash_precision", this.geoHashPrecision);
        }
        if (includeDefaults || this.precisionStep != null) {
            builder.field("precision_step", this.precisionStep);
        }
        if (includeDefaults || !this.validateLat || !this.validateLon) {
            if (this.validateLat && this.validateLon) {
                builder.field("validate", true);
            } else if (!this.validateLat && !this.validateLon) {
                builder.field("validate", false);
            } else {
                if (includeDefaults || !this.validateLat) {
                    builder.field("validate_lat", this.validateLat);
                }
                if (includeDefaults || !this.validateLon) {
                    builder.field("validate_lon", this.validateLon);
                }
            }
        }
        if (includeDefaults || !this.normalizeLat || !this.normalizeLon) {
            if (this.normalizeLat && this.normalizeLon) {
                builder.field("normalize", true);
            } else if (!this.normalizeLat && !this.normalizeLon) {
                builder.field("normalize", false);
            } else {
                if (includeDefaults || !this.normalizeLat) {
                    builder.field("normalize_lat", this.normalizeLat);
                }
                if (includeDefaults || !this.normalizeLon) {
                    builder.field("normalize_lon", this.normalizeLat);
                }
            }
        }
    }

    public static class CustomGeoPointDocValuesField
    extends NumberFieldMapper.CustomNumericDocValuesField {
        public static final FieldType TYPE = new FieldType();
        private final ObjectOpenHashSet<GeoPoint> points = new ObjectOpenHashSet(2);

        public CustomGeoPointDocValuesField(String name, double lat, double lon) {
            super(name);
            this.points.add(new GeoPoint(lat, lon));
        }

        public void add(double lat, double lon) {
            this.points.add(new GeoPoint(lat, lon));
        }

        public BytesRef binaryValue() {
            byte[] bytes = new byte[this.points.size() * 16];
            int off = 0;
            Iterator<ObjectCursor<GeoPoint>> it = this.points.iterator();
            while (it.hasNext()) {
                GeoPoint point = (GeoPoint)it.next().value;
                ByteUtils.writeDoubleLE(point.getLat(), bytes, off);
                ByteUtils.writeDoubleLE(point.getLon(), bytes, off + 8);
                off += 16;
            }
            return new BytesRef(bytes);
        }

        static {
            TYPE.setDocValueType(FieldInfo.DocValuesType.BINARY);
            TYPE.freeze();
        }
    }

    public static final class Encoding {
        private static final int MAX_NUM_BYTES = 14;
        private static final Encoding[] INSTANCES = new Encoding[15];
        private final DistanceUnit.Distance precision;
        private final int numBytes;
        private final int numBytesPerCoordinate;
        private final double factor;

        public static final Encoding of(int numBytesPerValue) {
            Encoding instance = INSTANCES[numBytesPerValue];
            if (instance == null) {
                throw new ElasticsearchIllegalStateException("No encoding for " + numBytesPerValue + " bytes per value");
            }
            return instance;
        }

        public static final Encoding of(DistanceUnit.Distance precision) {
            for (Encoding encoding : INSTANCES) {
                if (encoding == null || encoding.precision().compareTo(precision) > 0) continue;
                return encoding;
            }
            return INSTANCES[14];
        }

        private Encoding(int numBytes) {
            assert (numBytes >= 1 && numBytes <= 14);
            assert ((numBytes & 1) == 0);
            this.numBytes = numBytes;
            this.numBytesPerCoordinate = numBytes / 2;
            this.factor = Math.pow(2.0, -this.numBytesPerCoordinate * 8 + 9);
            assert ((double)(1L << this.numBytesPerCoordinate * 8 - 1) * this.factor > 180.0 && (double)(1L << this.numBytesPerCoordinate * 8 - 2) * this.factor < 180.0) : this.numBytesPerCoordinate + " " + this.factor;
            this.precision = numBytes == 14 ? new DistanceUnit.Distance(0.0, DistanceUnit.DEFAULT) : new DistanceUnit.Distance(GeoDistance.PLANE.calculate(0.0, 0.0, this.factor / 2.0, this.factor / 2.0, DistanceUnit.DEFAULT), DistanceUnit.DEFAULT);
        }

        public DistanceUnit.Distance precision() {
            return this.precision;
        }

        public final int numBytes() {
            return this.numBytes;
        }

        public int numBitsPerCoordinate() {
            return this.numBytesPerCoordinate << 3;
        }

        public long encodeCoordinate(double lat) {
            return Math.round((lat + 180.0) / this.factor);
        }

        public double decodeCoordinate(long bits) {
            return (double)bits * this.factor - 180.0;
        }

        private void encodeBits(long bits, byte[] out, int offset) {
            for (int i = 0; i < this.numBytesPerCoordinate; ++i) {
                out[offset++] = (byte)bits;
                bits >>>= 8;
            }
            assert (bits == 0L);
        }

        private long decodeBits(byte[] in, int offset) {
            long r = (long)in[offset++] & 0xFFL;
            for (int i = 1; i < this.numBytesPerCoordinate; ++i) {
                r = ((long)in[offset++] & 0xFFL) << i * 8;
            }
            return r;
        }

        public void encode(double lat, double lon, byte[] out, int offset) {
            this.encodeBits(this.encodeCoordinate(lat), out, offset);
            this.encodeBits(this.encodeCoordinate(lon), out, offset + this.numBytesPerCoordinate);
        }

        public GeoPoint decode(byte[] in, int offset, GeoPoint out) {
            long latBits = this.decodeBits(in, offset);
            long lonBits = this.decodeBits(in, offset + this.numBytesPerCoordinate);
            return this.decode(latBits, lonBits, out);
        }

        public GeoPoint decode(long latBits, long lonBits, GeoPoint out) {
            double lat = this.decodeCoordinate(latBits);
            double lon = this.decodeCoordinate(lonBits);
            return out.reset(lat, lon);
        }

        static {
            for (int numBytes = 2; numBytes <= 14; numBytes += 2) {
                Encoding.INSTANCES[numBytes] = new Encoding(numBytes);
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.geoPointField(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("path")) {
                    builder.multiFieldPathType(TypeParsers.parsePathType(name, fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("lat_lon")) {
                    builder.enableLatLon(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("geohash")) {
                    builder.enableGeoHash(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("geohash_prefix")) {
                    builder.geohashPrefix(XContentMapValues.nodeBooleanValue(fieldNode));
                    if (!XContentMapValues.nodeBooleanValue(fieldNode)) continue;
                    builder.enableGeoHash(true);
                    continue;
                }
                if (fieldName.equals("precision_step")) {
                    builder.precisionStep(XContentMapValues.nodeIntegerValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("geohash_precision")) {
                    if (fieldNode instanceof Integer) {
                        builder.geoHashPrecision(XContentMapValues.nodeIntegerValue(fieldNode));
                        continue;
                    }
                    builder.geoHashPrecision(GeoUtils.geoHashLevelsForPrecision(fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("validate")) {
                    builder.validateLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    builder.validateLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("validate_lon")) {
                    builder.validateLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("validate_lat")) {
                    builder.validateLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("normalize")) {
                    builder.normalizeLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    builder.normalizeLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("normalize_lat")) {
                    builder.normalizeLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("normalize_lon")) {
                    builder.normalizeLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                TypeParsers.parseMultiField(builder, name, node, parserContext, fieldName, fieldNode);
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, GeoPointFieldMapper> {
        private ContentPath.Type pathType = Defaults.PATH_TYPE;
        private boolean enableGeoHash = false;
        private boolean enableGeohashPrefix = false;
        private boolean enableLatLon = false;
        private Integer precisionStep;
        private int geoHashPrecision = 12;
        boolean validateLat = true;
        boolean validateLon = true;
        boolean normalizeLat = true;
        boolean normalizeLon = true;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        @Override
        public Builder multiFieldPathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder enableGeoHash(boolean enableGeoHash) {
            this.enableGeoHash = enableGeoHash;
            return this;
        }

        public Builder geohashPrefix(boolean enableGeohashPrefix) {
            this.enableGeohashPrefix = enableGeohashPrefix;
            return this;
        }

        public Builder enableLatLon(boolean enableLatLon) {
            this.enableLatLon = enableLatLon;
            return this;
        }

        public Builder precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return this;
        }

        public Builder geoHashPrecision(int precision) {
            this.geoHashPrecision = precision;
            return this;
        }

        @Override
        public Builder fieldDataSettings(Settings settings) {
            this.fieldDataSettings = settings;
            return (Builder)this.builder;
        }

        @Override
        public GeoPointFieldMapper build(Mapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            DoubleFieldMapper latMapper = null;
            DoubleFieldMapper lonMapper = null;
            context.path().add(this.name);
            if (this.enableLatLon) {
                NumberFieldMapper.Builder latMapperBuilder = (NumberFieldMapper.Builder)MapperBuilders.doubleField("lat").includeInAll(false);
                NumberFieldMapper.Builder lonMapperBuilder = (NumberFieldMapper.Builder)MapperBuilders.doubleField("lon").includeInAll(false);
                if (this.precisionStep != null) {
                    latMapperBuilder.precisionStep(this.precisionStep);
                    lonMapperBuilder.precisionStep(this.precisionStep);
                }
                latMapper = (DoubleFieldMapper)((Mapper.Builder)((NumberFieldMapper.Builder)latMapperBuilder.includeInAll(false)).store(this.fieldType.stored())).build(context);
                lonMapper = (DoubleFieldMapper)((Mapper.Builder)((NumberFieldMapper.Builder)lonMapperBuilder.includeInAll(false)).store(this.fieldType.stored())).build(context);
            }
            StringFieldMapper geohashMapper = null;
            if (this.enableGeoHash) {
                geohashMapper = ((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)MapperBuilders.stringField("geohash").index(true)).tokenized(false)).includeInAll(false)).omitNorms(true)).indexOptions(FieldInfo.IndexOptions.DOCS_ONLY)).build(context);
            }
            context.path().remove();
            context.path().pathType(origPathType);
            this.fieldType.setTokenized(false);
            return new GeoPointFieldMapper(this.buildNames(context), this.fieldType, this.docValues, this.indexAnalyzer, this.searchAnalyzer, this.postingsProvider, this.docValuesProvider, this.similarity, this.fieldDataSettings, context.indexSettings(), origPathType, this.enableLatLon, this.enableGeoHash, this.enableGeohashPrefix, this.precisionStep, this.geoHashPrecision, latMapper, lonMapper, geohashMapper, this.validateLon, this.validateLat, this.normalizeLon, this.normalizeLat, this.multiFieldsBuilder.build(this, context));
        }
    }

    public static class Defaults {
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
        public static final boolean STORE = false;
        public static final boolean ENABLE_LATLON = false;
        public static final boolean ENABLE_GEOHASH = false;
        public static final boolean ENABLE_GEOHASH_PREFIX = false;
        public static final int GEO_HASH_PRECISION = 12;
        public static final boolean NORMALIZE_LAT = true;
        public static final boolean NORMALIZE_LON = true;
        public static final boolean VALIDATE_LAT = true;
        public static final boolean VALIDATE_LON = true;
        public static final FieldType FIELD_TYPE = new FieldType(StringFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
        }
    }

    public static class Names {
        public static final String LAT = "lat";
        public static final String LAT_SUFFIX = ".lat";
        public static final String LON = "lon";
        public static final String LON_SUFFIX = ".lon";
        public static final String GEOHASH = "geohash";
        public static final String GEOHASH_SUFFIX = ".geohash";
    }
}

