/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.util.Map;
import org.elasticsearch.index.query.functionscore.exp.ExponentialDecayFunctionBuilder;
import org.elasticsearch.index.query.functionscore.factor.FactorBuilder;
import org.elasticsearch.index.query.functionscore.gauss.GaussDecayFunctionBuilder;
import org.elasticsearch.index.query.functionscore.lin.LinearDecayFunctionBuilder;
import org.elasticsearch.index.query.functionscore.random.RandomScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.script.ScriptScoreFunctionBuilder;

public class ScoreFunctionBuilders {
    public static ExponentialDecayFunctionBuilder exponentialDecayFunction(String fieldName, Object origin, Object scale) {
        return new ExponentialDecayFunctionBuilder(fieldName, origin, scale);
    }

    public static ExponentialDecayFunctionBuilder exponentialDecayFunction(String fieldName, Object scale) {
        return new ExponentialDecayFunctionBuilder(fieldName, null, scale);
    }

    public static GaussDecayFunctionBuilder gaussDecayFunction(String fieldName, Object origin, Object scale) {
        return new GaussDecayFunctionBuilder(fieldName, origin, scale);
    }

    public static GaussDecayFunctionBuilder gaussDecayFunction(String fieldName, Object scale) {
        return new GaussDecayFunctionBuilder(fieldName, null, scale);
    }

    public static LinearDecayFunctionBuilder linearDecayFunction(String fieldName, Object origin, Object scale) {
        return new LinearDecayFunctionBuilder(fieldName, origin, scale);
    }

    public static LinearDecayFunctionBuilder linearDecayFunction(String fieldName, Object scale) {
        return new LinearDecayFunctionBuilder(fieldName, null, scale);
    }

    public static ScriptScoreFunctionBuilder scriptFunction(String script) {
        return new ScriptScoreFunctionBuilder().script(script);
    }

    public static ScriptScoreFunctionBuilder scriptFunction(String script, String lang) {
        return new ScriptScoreFunctionBuilder().script(script).lang(lang);
    }

    public static ScriptScoreFunctionBuilder scriptFunction(String script, String lang, Map<String, Object> params) {
        return new ScriptScoreFunctionBuilder().script(script).lang(lang).params(params);
    }

    public static ScriptScoreFunctionBuilder scriptFunction(String script, Map<String, Object> params) {
        return new ScriptScoreFunctionBuilder().script(script).params(params);
    }

    public static FactorBuilder factorFunction(float boost) {
        return new FactorBuilder().boostFactor(boost);
    }

    public static RandomScoreFunctionBuilder randomFunction(long seed) {
        return new RandomScoreFunctionBuilder().seed(seed);
    }
}

