/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.regex.Pattern;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.bytes.BytesValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;
import org.elasticsearch.search.aggregations.support.numeric.ValueParser;
import org.elasticsearch.search.internal.SearchContext;

public class SignificantTermsParser
implements Aggregator.Parser {
    public static final int DEFAULT_REQUIRED_SIZE = 10;
    public static final int DEFAULT_SHARD_SIZE = 0;
    public static final int DEFAULT_MIN_DOC_COUNT = 3;

    @Override
    public String type() {
        return SignificantStringTerms.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        ValuesSourceConfig<ValuesSource> config;
        FieldMapper mapper;
        XContentParser.Token token;
        String field = null;
        int requiredSize = 10;
        int shardSize = 0;
        String format = null;
        String include = null;
        int includeFlags = 0;
        String exclude = null;
        int excludeFlags = 0;
        String executionHint = null;
        long minDocCount = 3L;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if ("format".equals(currentFieldName)) {
                    format = parser.text();
                    continue;
                }
                if ("include".equals(currentFieldName)) {
                    include = parser.text();
                    continue;
                }
                if ("exclude".equals(currentFieldName)) {
                    exclude = parser.text();
                    continue;
                }
                if ("execution_hint".equals(currentFieldName) || "executionHint".equals(currentFieldName)) {
                    executionHint = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("size".equals(currentFieldName)) {
                    requiredSize = parser.intValue();
                    continue;
                }
                if ("shard_size".equals(currentFieldName) || "shardSize".equals(currentFieldName)) {
                    shardSize = parser.intValue();
                    continue;
                }
                if ("min_doc_count".equals(currentFieldName) || "minDocCount".equals(currentFieldName)) {
                    minDocCount = parser.intValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("include".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("pattern".equals(currentFieldName)) {
                                include = parser.text();
                                continue;
                            }
                            if (!"flags".equals(currentFieldName)) continue;
                            includeFlags = Regex.flagsFromString(parser.text());
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_NUMBER || !"flags".equals(currentFieldName)) continue;
                        includeFlags = parser.intValue();
                    }
                    continue;
                }
                if ("exclude".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("pattern".equals(currentFieldName)) {
                                exclude = parser.text();
                                continue;
                            }
                            if (!"flags".equals(currentFieldName)) continue;
                            excludeFlags = Regex.flagsFromString(parser.text());
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_NUMBER || !"flags".equals(currentFieldName)) continue;
                        excludeFlags = parser.intValue();
                    }
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        if (shardSize == 0) {
            shardSize = 2 * BucketUtils.suggestShardSideQueueSize(requiredSize, context.numberOfShards());
        }
        if (shardSize < requiredSize) {
            shardSize = requiredSize;
        }
        IncludeExclude includeExclude = null;
        if (include != null || exclude != null) {
            Pattern includePattern = include != null ? Pattern.compile(include, includeFlags) : null;
            Pattern excludePattern = exclude != null ? Pattern.compile(exclude, excludeFlags) : null;
            includeExclude = new IncludeExclude(includePattern, excludePattern);
        }
        if ((mapper = context.smartNameFieldMapper(field)) == null) {
            ValuesSourceConfig<BytesValuesSource> config2 = new ValuesSourceConfig<BytesValuesSource>(BytesValuesSource.class);
            config2.unmapped(true);
            return new SignificantTermsAggregatorFactory(aggregationName, config2, requiredSize, shardSize, minDocCount, includeExclude, executionHint);
        }
        Object indexFieldData = context.fieldData().getForField(mapper);
        if (mapper instanceof DateFieldMapper) {
            DateFieldMapper dateMapper = (DateFieldMapper)mapper;
            ValueFormatter.DateTime formatter = format == null ? new ValueFormatter.DateTime(dateMapper.dateTimeFormatter()) : new ValueFormatter.DateTime(format);
            config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class).formatter(formatter).parser(new ValueParser.DateMath(dateMapper.dateMathParser()));
        } else if (mapper instanceof IpFieldMapper) {
            config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class).formatter(ValueFormatter.IPv4).parser(ValueParser.IPv4);
        } else if (indexFieldData instanceof IndexNumericFieldData) {
            config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class);
            if (format != null) {
                config.formatter(new ValueFormatter.Number.Pattern(format));
            }
        } else {
            config = new ValuesSourceConfig<BytesValuesSource>(BytesValuesSource.class);
            config.needsHashes(true);
        }
        config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData));
        config.ensureUnique(true);
        return new SignificantTermsAggregatorFactory(aggregationName, config, requiredSize, shardSize, minDocCount, includeExclude, executionHint);
    }
}

