/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.HashedAggregator;
import org.elasticsearch.search.facet.terms.strings.HashedScriptAggregator;
import org.elasticsearch.search.facet.terms.strings.TermsStringFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class FieldsTermsStringFacetExecutor
extends FacetExecutor {
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int shardSize;
    private final IndexFieldData[] indexFieldDatas;
    private final SearchScript script;
    private final HashedAggregator aggregator;
    long missing;
    long total;

    public FieldsTermsStringFacetExecutor(FieldMapper[] fieldMappers, int size, int shardSize, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<BytesRef> excluded, Pattern pattern, SearchScript script) {
        int i;
        this.size = size;
        this.shardSize = shardSize;
        this.comparatorType = comparatorType;
        this.script = script;
        this.indexFieldDatas = new IndexFieldData[fieldMappers.length];
        for (i = 0; i < fieldMappers.length; ++i) {
            FieldMapper mapper = fieldMappers[i];
            this.indexFieldDatas[i] = context.fieldData().getForField(mapper);
        }
        this.aggregator = excluded.isEmpty() && pattern == null && script == null ? new HashedAggregator() : new HashedScriptAggregator(excluded, pattern, script);
        if (allTerms) {
            for (i = 0; i < fieldMappers.length; ++i) {
                TermsStringFacetExecutor.loadAllTerms(context, this.indexFieldDatas[i], this.aggregator);
            }
        }
    }

    @Override
    public Collector collector() {
        return new Collector(this.aggregator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalFacet buildFacet(String facetName) {
        try {
            InternalFacet internalFacet = HashedAggregator.buildFacet(facetName, this.size, this.shardSize, this.missing, this.total, this.comparatorType, this.aggregator);
            return internalFacet;
        }
        finally {
            this.aggregator.release();
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final HashedAggregator aggregator;
        private BytesValues[] values;

        public Collector(HashedAggregator aggregator) {
            this.values = new BytesValues[FieldsTermsStringFacetExecutor.this.indexFieldDatas.length];
            this.aggregator = aggregator;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (FieldsTermsStringFacetExecutor.this.script != null) {
                FieldsTermsStringFacetExecutor.this.script.setScorer(scorer);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            for (int i = 0; i < FieldsTermsStringFacetExecutor.this.indexFieldDatas.length; ++i) {
                this.values[i] = FieldsTermsStringFacetExecutor.this.indexFieldDatas[i].load(context).getBytesValues(true);
            }
            if (FieldsTermsStringFacetExecutor.this.script != null) {
                FieldsTermsStringFacetExecutor.this.script.setNextReader(context);
            }
        }

        public void collect(int doc) throws IOException {
            for (int i = 0; i < this.values.length; ++i) {
                this.aggregator.onDoc(doc, this.values[i]);
            }
        }

        @Override
        public void postCollection() {
            FieldsTermsStringFacetExecutor.this.missing = this.aggregator.missing();
            FieldsTermsStringFacetExecutor.this.total = this.aggregator.total();
        }
    }
}

