/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.State;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.Util;

class XSpecialOperations {
    static final /* synthetic */ boolean $assertionsDisabled;

    XSpecialOperations() {
    }

    private static PathNode getNode(PathNode[] nodes, int index) {
        if (!$assertionsDisabled && index >= nodes.length) {
            throw new AssertionError();
        }
        if (nodes[index] == null) {
            nodes[index] = new PathNode();
        }
        return nodes[index];
    }

    public static Set<IntsRef> getFiniteStrings(Automaton a, int limit) {
        HashSet<IntsRef> results = new HashSet<IntsRef>();
        if (limit != -1 && limit <= 0) {
            throw new IllegalArgumentException("limit must be -1 (which means no limit), or > 0; got: " + limit);
        }
        if (a.getSingleton() != null) {
            results.add(Util.toUTF32((CharSequence)a.getSingleton(), (IntsRef)new IntsRef()));
        } else {
            if (a.getInitialState().isAccept()) {
                results.add(new IntsRef());
            }
            if (a.getInitialState().numTransitions() > 0 && (limit == -1 || results.size() < limit)) {
                Set pathStates = Collections.newSetFromMap(new IdentityHashMap());
                PathNode[] nodes = new PathNode[4];
                pathStates.add(a.getInitialState());
                PathNode root = XSpecialOperations.getNode(nodes, 0);
                root.resetState(a.getInitialState());
                IntsRef string = new IntsRef(1);
                string.length = 1;
                while (string.length > 0) {
                    PathNode node = nodes[string.length - 1];
                    int label = node.nextLabel();
                    if (label != -1) {
                        string.ints[string.length - 1] = label;
                        if (node.to.isAccept()) {
                            results.add(IntsRef.deepCopyOf((IntsRef)string));
                            if (results.size() == limit) break;
                        }
                        if (node.to.numTransitions() == 0) continue;
                        if (pathStates.contains(node.to)) {
                            throw new IllegalArgumentException("automaton has cycles");
                        }
                        pathStates.add(node.to);
                        if (nodes.length == string.length) {
                            PathNode[] newNodes = new PathNode[ArrayUtil.oversize((int)(nodes.length + 1), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                            System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
                            nodes = newNodes;
                        }
                        XSpecialOperations.getNode(nodes, string.length).resetState(node.to);
                        ++string.length;
                        string.grow(string.length);
                        continue;
                    }
                    if (!$assertionsDisabled && !pathStates.contains(node.state)) {
                        throw new AssertionError();
                    }
                    pathStates.remove(node.state);
                    --string.length;
                }
            }
        }
        return results;
    }

    static {
        boolean bl = $assertionsDisabled = !XSpecialOperations.class.desiredAssertionStatus();
        if (!$assertionsDisabled && org.elasticsearch.Version.CURRENT.luceneVersion != Version.LUCENE_48) {
            throw new AssertionError((Object)"Remove this code once we upgrade to Lucene 4.9 where LUCENE-5628 is fixed");
        }
    }

    private static class PathNode {
        public State state;
        public State to;
        public int transition;
        public int label;

        private PathNode() {
        }

        public void resetState(State state) {
            assert (state.numTransitions() != 0);
            this.state = state;
            this.transition = 0;
            Transition t = state.transitionsArray[this.transition];
            this.label = t.getMin();
            this.to = t.getDest();
        }

        public int nextLabel() {
            if (this.label > this.state.transitionsArray[this.transition].getMax()) {
                ++this.transition;
                if (this.transition >= this.state.numTransitions()) {
                    return -1;
                }
                Transition t = this.state.transitionsArray[this.transition];
                this.label = t.getMin();
                this.to = t.getDest();
            }
            return this.label++;
        }
    }
}

