/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class MultiSearchRequest
extends ActionRequest<MultiSearchRequest> {
    private List<SearchRequest> requests = Lists.newArrayList();
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public MultiSearchRequest add(SearchRequestBuilder request) {
        this.requests.add(request.request());
        return this;
    }

    public MultiSearchRequest add(SearchRequest request) {
        this.requests.add(request);
        return this;
    }

    public MultiSearchRequest add(byte[] data, int from, int length, boolean contentUnsafe, @Nullable String[] indices, @Nullable String[] types, @Nullable String searchType) throws Exception {
        return this.add(new BytesArray(data, from, length), contentUnsafe, indices, types, searchType, null, IndicesOptions.strictExpandOpen(), true);
    }

    public MultiSearchRequest add(BytesReference data, boolean contentUnsafe, @Nullable String[] indices, @Nullable String[] types, @Nullable String searchType, IndicesOptions indicesOptions) throws Exception {
        return this.add(data, contentUnsafe, indices, types, searchType, null, indicesOptions, true);
    }

    public MultiSearchRequest add(BytesReference data, boolean contentUnsafe, @Nullable String[] indices, @Nullable String[] types, @Nullable String searchType, @Nullable String routing, IndicesOptions indicesOptions, boolean allowExplicitIndex) throws Exception {
        int nextMarker;
        XContent xContent = XContentFactory.xContent(data);
        int from = 0;
        int length = data.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data, length)) != -1) {
            boolean expandWildcardsClosed;
            boolean expandWildcardsOpen;
            boolean allowNoIndices;
            boolean ignoreUnavailable;
            SearchRequest searchRequest;
            block41: {
                if (nextMarker == 0) {
                    from = nextMarker + 1;
                    continue;
                }
                searchRequest = new SearchRequest();
                if (indices != null) {
                    searchRequest.indices(indices);
                }
                if (indicesOptions != null) {
                    searchRequest.indicesOptions(indicesOptions);
                }
                if (types != null && types.length > 0) {
                    searchRequest.types(types);
                }
                if (routing != null) {
                    searchRequest.routing(routing);
                }
                searchRequest.searchType(searchType);
                ignoreUnavailable = IndicesOptions.strictExpandOpen().ignoreUnavailable();
                allowNoIndices = IndicesOptions.strictExpandOpen().allowNoIndices();
                expandWildcardsOpen = IndicesOptions.strictExpandOpen().expandWildcardsOpen();
                expandWildcardsClosed = IndicesOptions.strictExpandOpen().expandWildcardsClosed();
                if (nextMarker - from > 0) {
                    try (XContentParser parser = xContent.createParser(data.slice(from, nextMarker - from));){
                        XContentParser.Token token = parser.nextToken();
                        if (token == null) break block41;
                        assert (token == XContentParser.Token.START_OBJECT);
                        String currentFieldName = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            String[] wildcards;
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token.isValue()) {
                                if ("index".equals(currentFieldName) || "indices".equals(currentFieldName)) {
                                    if (!allowExplicitIndex) {
                                        throw new ElasticsearchIllegalArgumentException("explicit index in multi search is not allowed");
                                    }
                                    searchRequest.indices(Strings.splitStringByCommaToArray(parser.text()));
                                    continue;
                                }
                                if ("type".equals(currentFieldName) || "types".equals(currentFieldName)) {
                                    searchRequest.types(Strings.splitStringByCommaToArray(parser.text()));
                                    continue;
                                }
                                if ("search_type".equals(currentFieldName) || "searchType".equals(currentFieldName)) {
                                    searchRequest.searchType(parser.text());
                                    continue;
                                }
                                if ("preference".equals(currentFieldName)) {
                                    searchRequest.preference(parser.text());
                                    continue;
                                }
                                if ("routing".equals(currentFieldName)) {
                                    searchRequest.routing(parser.text());
                                    continue;
                                }
                                if ("ignore_unavailable".equals(currentFieldName) || "ignoreUnavailable".equals(currentFieldName)) {
                                    ignoreUnavailable = parser.booleanValue();
                                    continue;
                                }
                                if ("allow_no_indices".equals(currentFieldName) || "allowNoIndices".equals(currentFieldName)) {
                                    allowNoIndices = parser.booleanValue();
                                    continue;
                                }
                                if (!"expand_wildcards".equals(currentFieldName) && !"expandWildcards".equals(currentFieldName)) continue;
                                for (String wildcard : wildcards = Strings.splitStringByCommaToArray(parser.text())) {
                                    if ("open".equals(wildcard)) {
                                        expandWildcardsOpen = true;
                                        continue;
                                    }
                                    if ("closed".equals(wildcard)) {
                                        expandWildcardsClosed = true;
                                        continue;
                                    }
                                    throw new ElasticsearchIllegalArgumentException("No valid expand wildcard value [" + wildcard + "]");
                                }
                                continue;
                            }
                            if (token != XContentParser.Token.START_ARRAY) continue;
                            if ("index".equals(currentFieldName) || "indices".equals(currentFieldName)) {
                                if (!allowExplicitIndex) {
                                    throw new ElasticsearchIllegalArgumentException("explicit index in multi search is not allowed");
                                }
                                searchRequest.indices(this.parseArray(parser));
                                continue;
                            }
                            if ("type".equals(currentFieldName) || "types".equals(currentFieldName)) {
                                searchRequest.types(this.parseArray(parser));
                                continue;
                            }
                            if ("expand_wildcards".equals(currentFieldName) || "expandWildcards".equals(currentFieldName)) {
                                for (String wildcard : wildcards = this.parseArray(parser)) {
                                    if ("open".equals(wildcard)) {
                                        expandWildcardsOpen = true;
                                        continue;
                                    }
                                    if ("closed".equals(wildcard)) {
                                        expandWildcardsClosed = true;
                                        continue;
                                    }
                                    throw new ElasticsearchIllegalArgumentException("No valid expand wildcard value [" + wildcard + "]");
                                }
                                continue;
                            }
                            throw new ElasticsearchParseException(currentFieldName + " doesn't support arrays");
                        }
                    }
                }
            }
            searchRequest.indicesOptions(IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandWildcardsOpen, expandWildcardsClosed));
            from = nextMarker + 1;
            nextMarker = this.findNextMarker(marker, from, data, length);
            if (nextMarker == -1) break;
            searchRequest.source(data.slice(from, nextMarker - from), contentUnsafe);
            from = nextMarker + 1;
            this.add(searchRequest);
        }
        return this;
    }

    private String[] parseArray(XContentParser parser) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        assert (parser.currentToken() == XContentParser.Token.START_ARRAY);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            list.add(parser.text());
        }
        return list.toArray(new String[list.size()]);
    }

    private int findNextMarker(byte marker, int from, BytesReference data, int length) {
        for (int i = from; i < length; ++i) {
            if (data.get(i) != marker) continue;
            return i;
        }
        return -1;
    }

    public List<SearchRequest> requests() {
        return this.requests;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiSearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            SearchRequest request = new SearchRequest();
            request.readFrom(in);
            this.requests.add(request);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.requests.size());
        for (SearchRequest request : this.requests) {
            request.writeTo(out);
        }
    }
}

