/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;

public class PagedBytesReference
implements BytesReference {
    private static final int PAGE_SIZE = 16384;
    private static final int NIO_GATHERING_LIMIT = 524288;
    private final BigArrays bigarrays;
    protected final ByteArray bytearray;
    private final int offset;
    private final int length;
    private int hash = 0;

    public PagedBytesReference(BigArrays bigarrays, ByteArray bytearray, int length) {
        this(bigarrays, bytearray, 0, length);
    }

    public PagedBytesReference(BigArrays bigarrays, ByteArray bytearray, int from, int length) {
        this.bigarrays = bigarrays;
        this.bytearray = bytearray;
        this.offset = from;
        this.length = length;
    }

    @Override
    public byte get(int index) {
        return this.bytearray.get(this.offset + index);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        if (from < 0 || from + length > this.length()) {
            throw new ElasticsearchIllegalArgumentException("can't slice a buffer with length [" + this.length() + "], with slice parameters from [" + from + "], length [" + length + "]");
        }
        return new PagedBytesReference(this.bigarrays, this.bytearray, this.offset + from, length);
    }

    @Override
    public StreamInput streamInput() {
        return new PagedBytesReferenceStreamInput(this.bytearray, this.offset, this.length);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.length == 0) {
            return;
        }
        BytesRef ref = new BytesRef();
        int written = 0;
        if (this.offset != 0) {
            int fragmentSize = Math.min(this.length, 16384 - this.offset % 16384);
            this.bytearray.get(this.offset, fragmentSize, ref);
            os.write(ref.bytes, ref.offset, fragmentSize);
            written += fragmentSize;
        }
        while (written < this.length) {
            int remaining = this.length - written;
            int bulkSize = remaining > 16384 ? 16384 : remaining;
            this.bytearray.get(this.offset + written, bulkSize, ref);
            os.write(ref.bytes, ref.offset, bulkSize);
            written += bulkSize;
        }
    }

    @Override
    public void writeTo(GatheringByteChannel channel) throws IOException {
        if (this.length == 0) {
            return;
        }
        ByteBuffer currentBuffer = null;
        BytesRef ref = new BytesRef();
        int pos = 0;
        if (this.offset != 0) {
            int fragmentSize = Math.min(this.length, 16384 - this.offset % 16384);
            this.bytearray.get(this.offset, fragmentSize, ref);
            currentBuffer = ByteBuffer.wrap(ref.bytes, ref.offset, fragmentSize);
            pos += fragmentSize;
        }
        if (pos == this.length && currentBuffer != null) {
            channel.write(currentBuffer);
            return;
        }
        int numBuffers = this.countRequiredBuffers(currentBuffer != null ? 1 : 0, this.length - pos);
        ByteBuffer[] buffers = new ByteBuffer[numBuffers];
        int bufferSlot = 0;
        if (currentBuffer != null) {
            buffers[bufferSlot] = currentBuffer;
            ++bufferSlot;
        }
        while (pos < this.length) {
            int remaining = this.length - pos;
            int bulkSize = remaining > 16384 ? 16384 : remaining;
            this.bytearray.get(this.offset + pos, bulkSize, ref);
            buffers[bufferSlot] = currentBuffer = ByteBuffer.wrap(ref.bytes, ref.offset, bulkSize);
            ++bufferSlot;
            pos += bulkSize;
        }
        assert (numBuffers == bufferSlot);
        channel.write(buffers);
    }

    @Override
    public byte[] toBytes() {
        if (this.length == 0) {
            return BytesRef.EMPTY_BYTES;
        }
        BytesRef ref = new BytesRef();
        this.bytearray.get(this.offset, this.length, ref);
        byte[] result = ref.bytes;
        if (result.length != this.length || ref.offset != 0) {
            result = Arrays.copyOfRange(result, ref.offset, ref.offset + this.length);
        }
        return result;
    }

    @Override
    public BytesArray toBytesArray() {
        BytesRef ref = new BytesRef();
        this.bytearray.get(this.offset, this.length, ref);
        return new BytesArray(ref);
    }

    @Override
    public BytesArray copyBytesArray() {
        BytesRef ref = new BytesRef();
        boolean copied = this.bytearray.get(this.offset, this.length, ref);
        if (copied) {
            return new BytesArray(ref.bytes, ref.offset, ref.length);
        }
        byte[] copy = Arrays.copyOfRange(ref.bytes, ref.offset, ref.offset + ref.length);
        return new BytesArray(copy);
    }

    @Override
    public ChannelBuffer toChannelBuffer() {
        if (this.length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer currentBuffer = null;
        BytesRef ref = new BytesRef();
        int pos = 0;
        if (this.offset != 0) {
            int fragmentSize = Math.min(this.length, 16384 - this.offset % 16384);
            this.bytearray.get(this.offset, fragmentSize, ref);
            currentBuffer = ChannelBuffers.wrappedBuffer(ref.bytes, ref.offset, fragmentSize);
            pos += fragmentSize;
        }
        if (pos == this.length && currentBuffer != null) {
            return currentBuffer;
        }
        int numBuffers = this.countRequiredBuffers(currentBuffer != null ? 1 : 0, this.length - pos);
        ChannelBuffer[] buffers = new ChannelBuffer[numBuffers];
        int bufferSlot = 0;
        if (currentBuffer != null) {
            buffers[bufferSlot] = currentBuffer;
            ++bufferSlot;
        }
        while (pos < this.length) {
            int remaining = this.length - pos;
            int bulkSize = remaining > 16384 ? 16384 : remaining;
            this.bytearray.get(this.offset + pos, bulkSize, ref);
            buffers[bufferSlot] = currentBuffer = ChannelBuffers.wrappedBuffer(ref.bytes, ref.offset, bulkSize);
            ++bufferSlot;
            pos += bulkSize;
        }
        assert (numBuffers == bufferSlot);
        return ChannelBuffers.wrappedBuffer(this.length <= 524288, buffers);
    }

    @Override
    public boolean hasArray() {
        return this.offset + this.length <= 16384;
    }

    @Override
    public byte[] array() {
        if (this.hasArray()) {
            if (this.length == 0) {
                return BytesRef.EMPTY_BYTES;
            }
            BytesRef ref = new BytesRef();
            this.bytearray.get(this.offset, this.length, ref);
            return ref.bytes;
        }
        throw new IllegalStateException("array not available");
    }

    @Override
    public int arrayOffset() {
        if (this.hasArray()) {
            BytesRef ref = new BytesRef();
            this.bytearray.get(this.offset, this.length, ref);
            return ref.offset;
        }
        throw new IllegalStateException("array not available");
    }

    @Override
    public String toUtf8() {
        if (this.length() == 0) {
            return "";
        }
        byte[] bytes = this.toBytes();
        CharsRef ref = new CharsRef(this.length);
        UnicodeUtil.UTF8toUTF16((byte[])bytes, (int)this.offset, (int)this.length, (CharsRef)ref);
        return ref.toString();
    }

    @Override
    public BytesRef toBytesRef() {
        BytesRef bref = new BytesRef();
        this.bytearray.get(this.offset, this.length, bref);
        return bref;
    }

    @Override
    public BytesRef copyBytesRef() {
        byte[] bytes = this.toBytes();
        return new BytesRef(bytes, this.offset, this.length);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int tmphash = 1;
            for (int i = 0; i < this.length; ++i) {
                tmphash = 31 * tmphash + this.bytearray.get(this.offset + i);
            }
            this.hash = tmphash;
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PagedBytesReference)) {
            return BytesReference.Helper.bytesEqual(this, (BytesReference)obj);
        }
        PagedBytesReference other = (PagedBytesReference)obj;
        if (this.length != other.length) {
            return false;
        }
        ByteArray otherArray = other.bytearray;
        int otherOffset = other.offset;
        for (int i = 0; i < this.length; ++i) {
            if (this.bytearray.get(this.offset + i) == otherArray.get(otherOffset + i)) continue;
            return false;
        }
        return true;
    }

    private int countRequiredBuffers(int initialCount, int numBytes) {
        int numBuffers = initialCount;
        int pages = numBytes / 16384;
        numBuffers += pages == 0 ? 1 : pages;
        return numBuffers += pages > 0 && numBytes % 16384 > 0 ? 1 : 0;
    }

    private static class PagedBytesReferenceStreamInput
    extends StreamInput {
        private final ByteArray bytearray;
        private final BytesRef ref;
        private final int offset;
        private final int length;
        private int pos;

        public PagedBytesReferenceStreamInput(ByteArray bytearray, int offset, int length) {
            this.bytearray = bytearray;
            this.ref = new BytesRef();
            this.offset = offset;
            this.length = length;
            this.pos = 0;
            if ((long)(offset + length) > bytearray.size()) {
                throw new IndexOutOfBoundsException("offset+length >= bytearray.size()");
            }
        }

        @Override
        public byte readByte() throws IOException {
            if (this.pos >= this.length) {
                throw new EOFException();
            }
            return this.bytearray.get(this.offset + this.pos++);
        }

        @Override
        public void readBytes(byte[] b, int bOffset, int len) throws IOException {
            if (len > this.offset + this.length) {
                throw new IndexOutOfBoundsException("Cannot read " + len + " bytes from stream with length " + this.length + " at pos " + this.pos);
            }
            this.read(b, bOffset, len);
        }

        @Override
        public int read() throws IOException {
            return this.pos < this.length ? (int)this.bytearray.get(this.offset + this.pos++) : -1;
        }

        @Override
        public int read(byte[] b, int bOffset, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (this.pos >= this.offset + this.length) {
                return -1;
            }
            int numBytesToCopy = Math.min(len, this.length - this.pos);
            long byteArrayOffset = this.offset + this.pos;
            int copiedBytes = 0;
            while (copiedBytes < numBytesToCopy) {
                long pageFragment = 16384L - byteArrayOffset % 16384L;
                int bulkSize = (int)Math.min(pageFragment, (long)(numBytesToCopy - copiedBytes));
                boolean copied = this.bytearray.get(byteArrayOffset, bulkSize, this.ref);
                assert (!copied);
                System.arraycopy(this.ref.bytes, this.ref.offset, b, bOffset + copiedBytes, bulkSize);
                copiedBytes += bulkSize;
                byteArrayOffset += (long)bulkSize;
            }
            this.pos += copiedBytes;
            return copiedBytes;
        }

        @Override
        public void reset() throws IOException {
            this.pos = 0;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

