/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.NestedWrappableComparator;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.search.MultiValueMode;

public final class BytesRefOrdValComparator
extends NestedWrappableComparator<BytesRef> {
    final IndexFieldData.WithOrdinals<?> indexFieldData;
    final BytesRef missingValue;
    final long[] ords;
    final MultiValueMode sortMode;
    final BytesRef[] values;
    final int[] readerGen;
    int currentReaderGen = -1;
    BytesValues.WithOrdinals termsIndex;
    long missingOrd;
    int bottomSlot = -1;
    long bottomOrd;
    BytesRef top;
    long topOrd;

    public BytesRefOrdValComparator(IndexFieldData.WithOrdinals<?> indexFieldData, int numHits, MultiValueMode sortMode, BytesRef missingValue) {
        this.indexFieldData = indexFieldData;
        this.sortMode = sortMode;
        this.missingValue = missingValue;
        this.ords = new long[numHits];
        this.values = new BytesRef[numHits];
        this.readerGen = new int[numHits];
    }

    public int compare(int slot1, int slot2) {
        if (this.readerGen[slot1] == this.readerGen[slot2]) {
            int res = Long.compare(this.ords[slot1], this.ords[slot2]);
            assert (Integer.signum(res) == Integer.signum(this.compareValues(this.values[slot1], this.values[slot2]))) : this.values[slot1] + " " + this.values[slot2] + " " + this.ords[slot1] + " " + this.ords[slot2];
            return res;
        }
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        return this.compareValues(val1, val2);
    }

    public int compareBottom(int doc) {
        throw new UnsupportedOperationException();
    }

    public int compareTop(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareBottomMissing() {
        throw new UnsupportedOperationException();
    }

    public void copy(int slot, int doc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void missing(int slot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTopMissing() {
        throw new UnsupportedOperationException();
    }

    private boolean consistentInsertedOrd(BytesValues.WithOrdinals termsIndex, long ord, BytesRef value) {
        BytesRef previous;
        long previousOrd = ord >> 2;
        long nextOrd = previousOrd + 1L;
        BytesRef bytesRef = previous = previousOrd == -1L ? null : termsIndex.getValueByOrd(previousOrd);
        if ((ord & 3L) == 0L ? !$assertionsDisabled && this.compareValues(previous, value) != 0 : !$assertionsDisabled && this.compareValues(previous, value) >= 0) {
            throw new AssertionError();
        }
        if (nextOrd < termsIndex.ordinals().getMaxOrd()) {
            BytesRef next = termsIndex.getValueByOrd(nextOrd);
            assert (this.compareValues(value, next) < 0);
        }
        return true;
    }

    private long ordInCurrentReader(BytesValues.WithOrdinals termsIndex, BytesRef value) {
        long docOrd;
        long ord = value == null ? -4L : ((docOrd = BytesRefOrdValComparator.binarySearch(termsIndex, value)) >= 0L ? docOrd << 2 : (-2L - docOrd << 2) + 2L);
        assert ((ord & 1L) == 0L);
        return ord;
    }

    public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
        this.termsIndex = this.indexFieldData.load(context).getBytesValues(false);
        assert (this.termsIndex.ordinals() != null);
        this.missingOrd = this.ordInCurrentReader(this.termsIndex, this.missingValue);
        assert (this.consistentInsertedOrd(this.termsIndex, this.missingOrd, this.missingValue));
        PerSegmentComparator perSegComp = null;
        assert (this.termsIndex.ordinals() != null);
        perSegComp = this.termsIndex.isMultiValued() ? new PerSegmentComparator(this.termsIndex){

            @Override
            protected long getOrd(int doc) {
                return BytesRefOrdValComparator.getRelevantOrd(this.readerOrds, doc, BytesRefOrdValComparator.this.sortMode);
            }
        } : new PerSegmentComparator(this.termsIndex);
        ++this.currentReaderGen;
        if (this.bottomSlot != -1) {
            perSegComp.setBottom(this.bottomSlot);
        }
        if (this.top != null) {
            perSegComp.setTopValue(this.top);
            this.topOrd = this.ordInCurrentReader(this.termsIndex, this.top);
        } else {
            this.topOrd = this.missingOrd;
        }
        return perSegComp;
    }

    public void setBottom(int bottom) {
        this.bottomSlot = bottom;
        BytesRef bottomValue = this.values[this.bottomSlot];
        if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
            this.bottomOrd = this.ords[this.bottomSlot];
        } else {
            this.bottomOrd = this.ordInCurrentReader(this.termsIndex, bottomValue);
            if (this.bottomOrd == this.missingOrd && bottomValue != null) {
                assert (this.missingValue != null);
                int cmp = bottomValue.compareTo(this.missingValue);
                if (cmp < 0) {
                    --this.bottomOrd;
                } else if (cmp > 0) {
                    ++this.bottomOrd;
                }
            }
            assert (this.consistentInsertedOrd(this.termsIndex, this.bottomOrd, bottomValue));
        }
    }

    public void setTopValue(BytesRef value) {
        this.top = value;
    }

    public BytesRef value(int slot) {
        return this.values[slot];
    }

    protected static final long binarySearch(BytesValues.WithOrdinals a, BytesRef key) {
        return BytesRefOrdValComparator.binarySearch(a, key, 0L, a.ordinals().getMaxOrd() - 1L);
    }

    protected static final long binarySearch(BytesValues.WithOrdinals a, BytesRef key, long low, long high) {
        assert (low != -1L);
        assert (high == -1L || a.getValueByOrd(high) == null | a.getValueByOrd(high) != null);
        assert (low == high + 1L || a.getValueByOrd(low) == null | a.getValueByOrd(low) != null);
        while (low <= high) {
            long mid = low + high >>> 1;
            BytesRef midVal = a.getValueByOrd(mid);
            int cmp = midVal != null ? midVal.compareTo(key) : -1;
            if (cmp < 0) {
                low = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    static long getRelevantOrd(Ordinals.Docs readerOrds, int docId, MultiValueMode sortMode) {
        int length = readerOrds.setDocument(docId);
        long relevantVal = sortMode.startLong();
        long result = -1L;
        assert (sortMode == MultiValueMode.MAX || sortMode == MultiValueMode.MIN);
        for (int i = 0; i < length; ++i) {
            result = relevantVal = sortMode.apply(readerOrds.nextOrd(), relevantVal);
        }
        assert (result >= -1L);
        assert (result < readerOrds.getMaxOrd());
        return result;
    }

    class PerSegmentComparator
    extends NestedWrappableComparator<BytesRef> {
        final Ordinals.Docs readerOrds;
        final BytesValues.WithOrdinals termsIndex;

        public PerSegmentComparator(BytesValues.WithOrdinals termsIndex) {
            this.readerOrds = termsIndex.ordinals();
            this.termsIndex = termsIndex;
            if (this.readerOrds.getMaxOrd() > 0x1FFFFFFFFFFFFFFFL) {
                throw new IllegalStateException("Current terms index pretends it has more than 2305843009213693951 ordinals, which is unsupported by this impl");
            }
        }

        public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
            return BytesRefOrdValComparator.this.setNextReader(context);
        }

        public int compare(int slot1, int slot2) {
            return BytesRefOrdValComparator.this.compare(slot1, slot2);
        }

        public void setBottom(int bottom) {
            BytesRefOrdValComparator.this.setBottom(bottom);
        }

        public void setTopValue(BytesRef value) {
            BytesRefOrdValComparator.this.setTopValue(value);
        }

        public BytesRef value(int slot) {
            return BytesRefOrdValComparator.this.value(slot);
        }

        public int compareValues(BytesRef val1, BytesRef val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return val1.compareTo(val2);
        }

        protected long getOrd(int doc) {
            return this.readerOrds.getOrd(doc);
        }

        public int compareBottom(int doc) {
            assert (BytesRefOrdValComparator.this.bottomSlot != -1);
            long docOrd = this.getOrd(doc);
            long comparableOrd = docOrd == -1L ? BytesRefOrdValComparator.this.missingOrd : docOrd << 2;
            return Long.compare(BytesRefOrdValComparator.this.bottomOrd, comparableOrd);
        }

        public int compareTop(int doc) throws IOException {
            long ord = this.getOrd(doc);
            if (ord == -1L) {
                return this.compareTopMissing();
            }
            long comparableOrd = ord << 2;
            return Long.compare(BytesRefOrdValComparator.this.topOrd, comparableOrd);
        }

        @Override
        public int compareBottomMissing() {
            assert (BytesRefOrdValComparator.this.bottomSlot != -1);
            return Long.compare(BytesRefOrdValComparator.this.bottomOrd, BytesRefOrdValComparator.this.missingOrd);
        }

        @Override
        public int compareTopMissing() {
            int cmp = Long.compare(BytesRefOrdValComparator.this.topOrd, BytesRefOrdValComparator.this.missingOrd);
            if (cmp == 0) {
                return this.compareValues(BytesRefOrdValComparator.this.top, BytesRefOrdValComparator.this.missingValue);
            }
            return cmp;
        }

        public void copy(int slot, int doc) {
            long ord = this.getOrd(doc);
            if (ord == -1L) {
                BytesRefOrdValComparator.this.ords[slot] = BytesRefOrdValComparator.this.missingOrd;
                BytesRefOrdValComparator.this.values[slot] = BytesRefOrdValComparator.this.missingValue;
            } else {
                assert (ord >= 0L);
                BytesRefOrdValComparator.this.ords[slot] = ord << 2;
                if (BytesRefOrdValComparator.this.values[slot] == null || BytesRefOrdValComparator.this.values[slot] == BytesRefOrdValComparator.this.missingValue) {
                    BytesRefOrdValComparator.this.values[slot] = new BytesRef();
                }
                BytesRefOrdValComparator.this.values[slot].copyBytes(this.termsIndex.getValueByOrd(ord));
            }
            BytesRefOrdValComparator.this.readerGen[slot] = BytesRefOrdValComparator.this.currentReaderGen;
        }

        @Override
        public void missing(int slot) {
            BytesRefOrdValComparator.this.ords[slot] = BytesRefOrdValComparator.this.missingOrd;
            BytesRefOrdValComparator.this.values[slot] = BytesRefOrdValComparator.this.missingValue;
            BytesRefOrdValComparator.this.readerGen[slot] = BytesRefOrdValComparator.this.currentReaderGen;
        }
    }
}

