/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class DocIdOrdinals
implements Ordinals {
    private final int numDocs;

    public DocIdOrdinals(int numDocs) {
        this.numDocs = numDocs;
    }

    @Override
    public long getMemorySizeInBytes() {
        return RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public long getMaxOrd() {
        return 0L + (long)this.numDocs;
    }

    @Override
    public Ordinals.Docs ordinals() {
        return new Docs(this);
    }

    public static class Docs
    extends Ordinals.AbstractDocs {
        private final LongsRef longsScratch = new LongsRef(new long[1], 0, 1);
        private int docId = -1;
        private long currentOrdinal = -1L;

        public Docs(DocIdOrdinals parent) {
            super(parent);
        }

        @Override
        public long getOrd(int docId) {
            this.currentOrdinal = docId + 1;
            return this.currentOrdinal;
        }

        @Override
        public long nextOrd() {
            assert (this.docId >= 0);
            this.currentOrdinal = this.docId + 1;
            this.docId = -1;
            return this.currentOrdinal;
        }

        @Override
        public int setDocument(int docId) {
            this.docId = docId;
            return 1;
        }

        @Override
        public long currentOrd() {
            return this.currentOrdinal;
        }
    }
}

