/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

final class BytesBinaryDVAtomicFieldData
implements AtomicFieldData<ScriptDocValues> {
    private final AtomicReader reader;
    private final BinaryDocValues values;

    BytesBinaryDVAtomicFieldData(AtomicReader reader, BinaryDocValues values) {
        this.reader = reader;
        this.values = values == null ? DocValues.EMPTY_BINARY : values;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public long getNumberUniqueValues() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMemorySizeInBytes() {
        return -1L;
    }

    @Override
    public BytesValues getBytesValues(boolean needsHashes) {
        return new BytesValues(true){
            final BytesRef bytes;
            final ByteArrayDataInput in;
            {
                this.bytes = new BytesRef();
                this.in = new ByteArrayDataInput();
            }

            @Override
            public int setDocument(int docId) {
                BytesBinaryDVAtomicFieldData.this.values.get(docId, this.bytes);
                this.in.reset(this.bytes.bytes, this.bytes.offset, this.bytes.length);
                if (this.bytes.length == 0) {
                    return 0;
                }
                return this.in.readVInt();
            }

            @Override
            public BytesRef nextValue() {
                int length = this.in.readVInt();
                this.scratch.grow(length);
                this.in.readBytes(this.scratch.bytes, 0, length);
                this.scratch.length = length;
                this.scratch.offset = 0;
                return this.scratch;
            }
        };
    }

    @Override
    public ScriptDocValues getScriptValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }
}

