/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.EmptyOrdinals;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AtomicFieldDataWithOrdinalsTermsEnum;
import org.elasticsearch.index.fielddata.plain.EmptyByteValuesWithOrdinals;

public class FSTBytesAtomicFieldData
implements AtomicFieldData.WithOrdinals<ScriptDocValues.Strings> {
    protected final Ordinals ordinals;
    private volatile IntArray hashes;
    private long size = -1L;
    private final FST<Long> fst;

    public static FSTBytesAtomicFieldData empty() {
        return new Empty();
    }

    public FSTBytesAtomicFieldData(FST<Long> fst, Ordinals ordinals) {
        this.ordinals = ordinals;
        this.fst = fst;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isMultiValued() {
        return this.ordinals.isMultiValued();
    }

    @Override
    public long getNumberUniqueValues() {
        return this.ordinals.getMaxOrd() - 0L;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            long size = this.ordinals.getMemorySizeInBytes();
            this.size = size += this.fst == null ? 0L : this.fst.sizeInBytes();
        }
        return this.size;
    }

    @Override
    public BytesValues.WithOrdinals getBytesValues(boolean needsHashes) {
        assert (this.fst != null);
        if (needsHashes) {
            if (this.hashes == null) {
                BytesRefFSTEnum fstEnum = new BytesRefFSTEnum(this.fst);
                IntArray hashes = BigArrays.NON_RECYCLING_INSTANCE.newIntArray(this.ordinals.getMaxOrd());
                try {
                    long maxOrd = this.ordinals.getMaxOrd();
                    for (long i = 0L; i < maxOrd; ++i) {
                        hashes.set(i, fstEnum.next().input.hashCode());
                    }
                    assert (fstEnum.next() == null);
                }
                catch (IOException e) {
                    throw new AssertionError("Cannot happen", e);
                }
                this.hashes = hashes;
            }
            return new HashedBytesValues(this.fst, this.ordinals.ordinals(), this.hashes);
        }
        return new BytesValues(this.fst, this.ordinals.ordinals());
    }

    @Override
    public ScriptDocValues.Strings getScriptValues() {
        assert (this.fst != null);
        return new ScriptDocValues.Strings(this.getBytesValues(false));
    }

    @Override
    public TermsEnum getTermsEnum() {
        return new AtomicFieldDataWithOrdinalsTermsEnum(this);
    }

    static final class Empty
    extends FSTBytesAtomicFieldData {
        Empty() {
            super(null, EmptyOrdinals.INSTANCE);
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public BytesValues.WithOrdinals getBytesValues(boolean needsHashes) {
            return new EmptyByteValuesWithOrdinals(this.ordinals.ordinals());
        }

        @Override
        public ScriptDocValues.Strings getScriptValues() {
            return ScriptDocValues.EMPTY_STRINGS;
        }
    }

    static final class HashedBytesValues
    extends BytesValues {
        private final IntArray hashes;

        HashedBytesValues(FST<Long> fst, Ordinals.Docs ordinals, IntArray hashes) {
            super(fst, ordinals);
            this.hashes = hashes;
        }

        @Override
        public int currentValueHash() {
            assert (this.ordinals.currentOrd() >= 0L);
            return this.hashes.get(this.ordinals.currentOrd());
        }
    }

    static class BytesValues
    extends BytesValues.WithOrdinals {
        protected final FST<Long> fst;
        protected final Ordinals.Docs ordinals;
        protected final FST.BytesReader in;
        protected final FST.Arc<Long> firstArc = new FST.Arc();
        protected final FST.Arc<Long> scratchArc = new FST.Arc();
        protected final IntsRef scratchInts = new IntsRef();

        BytesValues(FST<Long> fst, Ordinals.Docs ordinals) {
            super(ordinals);
            this.fst = fst;
            this.ordinals = ordinals;
            this.in = fst.getBytesReader();
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            assert (ord != -1L);
            this.in.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            try {
                IntsRef output = Util.getByOutput(this.fst, (long)ord, (FST.BytesReader)this.in, this.firstArc, this.scratchArc, (IntsRef)this.scratchInts);
                this.scratch.offset = 0;
                this.scratch.length = 0;
                this.scratch.grow(output.length);
                Util.toBytesRef((IntsRef)output, (BytesRef)this.scratch);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.scratch;
        }
    }
}

