/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractGeoPointIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointDoubleArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class GeoPointDoubleArrayIndexFieldData
extends AbstractGeoPointIndexFieldData {
    private final CircuitBreakerService breakerService;

    public GeoPointDoubleArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicGeoPointFieldData<ScriptDocValues> loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        AtomicGeoPointFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker());
        if (terms == null) {
            data = new AbstractGeoPointIndexFieldData.Empty();
            estimator.afterLoad(null, data.getMemorySizeInBytes());
            return data;
        }
        DoubleArray lat = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(128L);
        DoubleArray lon = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(128L);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(terms.size(), reader.maxDoc(), acceptableTransientOverheadRatio);){
                GeoPoint point;
                AbstractGeoPointIndexFieldData.GeoPointEnum iter = new AbstractGeoPointIndexFieldData.GeoPointEnum(builder.buildFromTerms(terms.iterator(null)));
                long numTerms = 0L;
                while ((point = iter.next()) != null) {
                    lat = BigArrays.NON_RECYCLING_INSTANCE.resize(lat, numTerms + 1L);
                    lon = BigArrays.NON_RECYCLING_INSTANCE.resize(lon, numTerms + 1L);
                    lat.set(numTerms, point.getLat());
                    lon.set(numTerms, point.getLon());
                    ++numTerms;
                }
                lat = BigArrays.NON_RECYCLING_INSTANCE.resize(lat, numTerms);
                lon = BigArrays.NON_RECYCLING_INSTANCE.resize(lon, numTerms);
                Ordinals build = builder.build(this.fieldDataType.getSettings());
                if (!build.isMultiValued() && IndexFieldData.CommonSettings.getMemoryStorageHint(this.fieldDataType) != IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS) {
                    Ordinals.Docs ordinals = build.ordinals();
                    int maxDoc = reader.maxDoc();
                    DoubleArray sLat = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(reader.maxDoc());
                    DoubleArray sLon = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(reader.maxDoc());
                    for (int i = 0; i < maxDoc; ++i) {
                        long nativeOrdinal = ordinals.getOrd(i);
                        if (nativeOrdinal == -1L) continue;
                        sLat.set(i, lat.get(nativeOrdinal));
                        sLon.set(i, lon.get(nativeOrdinal));
                    }
                    FixedBitSet set = builder.buildDocsWithValuesSet();
                    data = set == null ? new GeoPointDoubleArrayAtomicFieldData.Single(sLon, sLat, ordinals.getMaxOrd() - 0L) : new GeoPointDoubleArrayAtomicFieldData.SingleFixedSet(sLon, sLat, set, ordinals.getMaxOrd() - 0L);
                } else {
                    data = new GeoPointDoubleArrayAtomicFieldData.WithOrdinals(lon, lat, build);
                }
                success = true;
                AtomicGeoPointFieldData atomicGeoPointFieldData = data;
                return atomicGeoPointFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.getMemorySizeInBytes());
            }
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService, GlobalOrdinalsBuilder globalOrdinalBuilder) {
            return new GeoPointDoubleArrayIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, breakerService);
        }
    }
}

