/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;

public class ParentChildAtomicFieldData
implements AtomicFieldData {
    private final ImmutableOpenMap<String, PagedBytesAtomicFieldData> typeToIds;
    private final long numberUniqueValues;
    private final long memorySizeInBytes;

    public ParentChildAtomicFieldData(ImmutableOpenMap<String, PagedBytesAtomicFieldData> typeToIds) {
        this.typeToIds = typeToIds;
        long numValues = 0L;
        for (ObjectCursor<PagedBytesAtomicFieldData> objectCursor : typeToIds.values()) {
            numValues += ((PagedBytesAtomicFieldData)objectCursor.value).getNumberUniqueValues();
        }
        this.numberUniqueValues = numValues;
        long size = 0L;
        for (ObjectCursor<PagedBytesAtomicFieldData> objectCursor : typeToIds.values()) {
            size += ((PagedBytesAtomicFieldData)objectCursor.value).getMemorySizeInBytes();
        }
        this.memorySizeInBytes = size;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public long getNumberUniqueValues() {
        return this.numberUniqueValues;
    }

    @Override
    public long getMemorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    @Override
    public BytesValues getBytesValues(boolean needsHashes) {
        final BytesValues[] bytesValues = new BytesValues[this.typeToIds.size()];
        int index = 0;
        for (ObjectCursor<PagedBytesAtomicFieldData> objectCursor : this.typeToIds.values()) {
            bytesValues[index++] = ((PagedBytesAtomicFieldData)objectCursor.value).getBytesValues(needsHashes);
        }
        return new BytesValues(true){
            private final BytesRef[] terms;
            private int index;
            {
                super(x0);
                this.terms = new BytesRef[2];
            }

            @Override
            public int setDocument(int docId) {
                this.index = 0;
                int counter = 0;
                for (BytesValues values : bytesValues) {
                    int numValues = values.setDocument(docId);
                    assert (numValues <= 1) : "Per doc/type combination only a single value is allowed";
                    if (numValues != 1) continue;
                    values.nextValue();
                    this.terms[counter++] = values.copyShared();
                }
                assert (counter <= 2) : "A single doc can potentially be both parent and child, so the maximum allowed values is 2";
                if (counter > 1) {
                    int cmp = this.terms[0].compareTo(this.terms[1]);
                    if (cmp > 0) {
                        BytesRef temp = this.terms[0];
                        this.terms[0] = this.terms[1];
                        this.terms[1] = temp;
                    } else if (cmp == 0) {
                        return 1;
                    }
                }
                return counter;
            }

            @Override
            public BytesRef nextValue() {
                BytesRef current = this.terms[this.index++];
                this.scratch.bytes = current.bytes;
                this.scratch.offset = current.offset;
                this.scratch.length = current.length;
                return this.scratch;
            }
        };
    }

    public BytesValues.WithOrdinals getBytesValues(String type) {
        AtomicFieldData.WithOrdinals atomicFieldData = this.typeToIds.get(type);
        if (atomicFieldData != null) {
            return atomicFieldData.getBytesValues(true);
        }
        return null;
    }

    public AtomicFieldData.WithOrdinals getAtomicFieldData(String type) {
        return this.typeToIds.get(type);
    }

    public ScriptDocValues getScriptValues() {
        return new ScriptDocValues.Strings(this.getBytesValues(false));
    }

    @Override
    public void close() {
        for (ObjectCursor<PagedBytesAtomicFieldData> objectCursor : this.typeToIds.values()) {
            ((PagedBytesAtomicFieldData)objectCursor.value).close();
        }
    }
}

