/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.RegexpFilter;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingFormats;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.FieldDataTermsFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class AbstractFieldMapper<T>
implements FieldMapper<T> {
    private static final ThreadLocal<List<Field>> FIELD_LIST = new ThreadLocal<List<Field>>(){

        @Override
        protected List<Field> initialValue() {
            return new ArrayList<Field>(2);
        }
    };
    protected final FieldMapper.Names names;
    protected float boost;
    protected FieldType fieldType;
    private final boolean docValues;
    protected final NamedAnalyzer indexAnalyzer;
    protected NamedAnalyzer searchAnalyzer;
    protected PostingsFormatProvider postingsFormat;
    protected DocValuesFormatProvider docValuesFormat;
    protected final SimilarityProvider similarity;
    protected FieldMapper.Loading normsLoading;
    protected Settings customFieldDataSettings;
    protected FieldDataType fieldDataType;
    protected final MultiFields multiFields;
    protected CopyTo copyTo;

    protected AbstractFieldMapper(FieldMapper.Names names, float boost, FieldType fieldType, Boolean docValues, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider postingsFormat, DocValuesFormatProvider docValuesFormat, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        this(names, boost, fieldType, docValues, indexAnalyzer, searchAnalyzer, postingsFormat, docValuesFormat, similarity, normsLoading, fieldDataSettings, indexSettings, MultiFields.empty(), null);
    }

    protected AbstractFieldMapper(FieldMapper.Names names, float boost, FieldType fieldType, Boolean docValues, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider postingsFormat, DocValuesFormatProvider docValuesFormat, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings, MultiFields multiFields, CopyTo copyTo) {
        this.names = names;
        this.boost = boost;
        this.fieldType = fieldType;
        this.fieldType.freeze();
        this.indexAnalyzer = indexAnalyzer == null && !this.fieldType.tokenized() && this.fieldType.indexed() ? Lucene.KEYWORD_ANALYZER : indexAnalyzer;
        this.searchAnalyzer = searchAnalyzer == null && !this.fieldType.tokenized() && this.fieldType.indexed() ? Lucene.KEYWORD_ANALYZER : searchAnalyzer;
        if (postingsFormat == null && this.defaultPostingFormat() != null) {
            postingsFormat = PostingFormats.getAsProvider(this.defaultPostingFormat());
        }
        this.postingsFormat = postingsFormat;
        this.docValuesFormat = docValuesFormat;
        this.similarity = similarity;
        this.normsLoading = normsLoading;
        this.customFieldDataSettings = fieldDataSettings;
        this.fieldDataType = fieldDataSettings == null ? this.defaultFieldDataType() : new FieldDataType(this.defaultFieldDataType().getType(), ImmutableSettings.builder().put(this.defaultFieldDataType().getSettings()).put(fieldDataSettings));
        this.docValues = docValues != null ? docValues : (this.fieldDataType == null ? false : "doc_values".equals(this.fieldDataType.getFormat(indexSettings)));
        this.multiFields = multiFields;
        this.copyTo = copyTo;
    }

    @Nullable
    protected String defaultPostingFormat() {
        return null;
    }

    @Nullable
    protected String defaultDocValuesFormat() {
        return null;
    }

    @Override
    public String name() {
        return this.names.name();
    }

    @Override
    public FieldMapper.Names names() {
        return this.names;
    }

    public abstract FieldType defaultFieldType();

    public abstract FieldDataType defaultFieldDataType();

    @Override
    public final FieldDataType fieldDataType() {
        return this.fieldDataType;
    }

    @Override
    public FieldType fieldType() {
        return this.fieldType;
    }

    @Override
    public float boost() {
        return this.boost;
    }

    @Override
    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Override
    public Analyzer searchQuoteAnalyzer() {
        return this.searchAnalyzer;
    }

    @Override
    public SimilarityProvider similarity() {
        return this.similarity;
    }

    @Override
    public CopyTo copyTo() {
        return this.copyTo;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        List<Field> fields = FIELD_LIST.get();
        assert (fields.isEmpty());
        try {
            this.parseCreateField(context, fields);
            for (Field field : fields) {
                if (!this.customBoost()) {
                    field.setBoost(this.boost);
                }
                if (!context.listener().beforeFieldAdded(this, field, context)) continue;
                context.doc().add((IndexableField)field);
            }
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse [" + this.names.fullName() + "]", e);
        }
        finally {
            fields.clear();
        }
        this.multiFields.parse(this, context);
        if (this.copyTo != null) {
            this.copyTo.parse(context);
        }
    }

    protected abstract void parseCreateField(ParseContext var1, List<Field> var2) throws IOException;

    protected boolean customBoost() {
        return false;
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        fieldMapperListener.fieldMapper(this);
        this.multiFields.traverse(fieldMapperListener);
    }

    @Override
    public void traverse(ObjectMapperListener objectMapperListener) {
    }

    @Override
    public Object valueForSearch(Object value) {
        return value;
    }

    @Override
    public BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    @Override
    public Query queryStringTermQuery(Term term) {
        return null;
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return false;
    }

    @Override
    public Query termQuery(Object value, @Nullable QueryParseContext context) {
        return new TermQuery(this.names().createIndexNameTerm(this.indexedValueForSearch(value)));
    }

    @Override
    public Filter termFilter(Object value, @Nullable QueryParseContext context) {
        return new TermFilter(this.names().createIndexNameTerm(this.indexedValueForSearch(value)));
    }

    @Override
    public Filter termsFilter(List values, @Nullable QueryParseContext context) {
        BytesRef[] bytesRefs = new BytesRef[values.size()];
        for (int i = 0; i < bytesRefs.length; ++i) {
            bytesRefs[i] = this.indexedValueForSearch(values.get(i));
        }
        return new TermsFilter(this.names.indexName(), bytesRefs);
    }

    @Override
    public Filter termsFilter(IndexFieldDataService fieldDataService, List values, @Nullable QueryParseContext context) {
        ObjectOpenHashSet<BytesRef> terms = new ObjectOpenHashSet<BytesRef>((int)((float)values.size() * 1.75f));
        int len = values.size();
        for (int i = 0; i < len; ++i) {
            terms.add(this.indexedValueForSearch(values.get(i)));
        }
        return FieldDataTermsFilter.newBytes(fieldDataService.getForField(this), terms);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return new TermRangeQuery(this.names.indexName(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return new TermRangeFilter(this.names.indexName(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
    }

    @Override
    public Query fuzzyQuery(String value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        return new FuzzyQuery(this.names.createIndexNameTerm(this.indexedValueForSearch(value)), fuzziness.asDistance(value), prefixLength, maxExpansions, transpositions);
    }

    @Override
    public Query prefixQuery(Object value, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        PrefixQuery query = new PrefixQuery(this.names().createIndexNameTerm(this.indexedValueForSearch(value)));
        if (method != null) {
            query.setRewriteMethod(method);
        }
        return query;
    }

    @Override
    public Filter prefixFilter(Object value, @Nullable QueryParseContext context) {
        return new PrefixFilter(this.names().createIndexNameTerm(this.indexedValueForSearch(value)));
    }

    @Override
    public Query regexpQuery(Object value, int flags, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        RegexpQuery query = new RegexpQuery(this.names().createIndexNameTerm(this.indexedValueForSearch(value)), flags);
        if (method != null) {
            query.setRewriteMethod(method);
        }
        return query;
    }

    @Override
    public Filter regexpFilter(Object value, int flags, @Nullable QueryParseContext parseContext) {
        return new RegexpFilter(this.names().createIndexNameTerm(this.indexedValueForSearch(value)), flags);
    }

    @Override
    public Filter nullValueFilter() {
        return null;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        if (!this.getClass().equals(mergeWith.getClass())) {
            String mergedType = mergeWith.getClass().getSimpleName();
            if (mergeWith instanceof AbstractFieldMapper) {
                mergedType = ((AbstractFieldMapper)mergeWith).contentType();
            }
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] of different type, current_type [" + this.contentType() + "], merged_type [" + mergedType + "]");
            return;
        }
        AbstractFieldMapper fieldMergeWith = (AbstractFieldMapper)mergeWith;
        if (this.fieldType().indexed() != fieldMergeWith.fieldType().indexed() || this.fieldType().tokenized() != fieldMergeWith.fieldType().tokenized()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index values");
        }
        if (this.fieldType().stored() != fieldMergeWith.fieldType().stored()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store values");
        }
        if (!this.hasDocValues() && fieldMergeWith.hasDocValues()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different " + "doc_values" + " values");
        }
        if (this.fieldType().omitNorms() && !fieldMergeWith.fieldType.omitNorms()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] cannot enable norms (`norms.enabled`)");
        }
        if (this.fieldType().tokenized() != fieldMergeWith.fieldType().tokenized()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different tokenize values");
        }
        if (this.fieldType().storeTermVectors() != fieldMergeWith.fieldType().storeTermVectors()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store_term_vector values");
        }
        if (this.fieldType().storeTermVectorOffsets() != fieldMergeWith.fieldType().storeTermVectorOffsets()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store_term_vector_offsets values");
        }
        if (this.fieldType().storeTermVectorPositions() != fieldMergeWith.fieldType().storeTermVectorPositions()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store_term_vector_positions values");
        }
        if (this.fieldType().storeTermVectorPayloads() != fieldMergeWith.fieldType().storeTermVectorPayloads()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store_term_vector_payloads values");
        }
        if (this.indexAnalyzer == null) {
            if (fieldMergeWith.indexAnalyzer != null) {
                mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_analyzer");
            }
        } else if (fieldMergeWith.indexAnalyzer == null) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_analyzer");
        } else if (!this.indexAnalyzer.name().equals(fieldMergeWith.indexAnalyzer.name())) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_analyzer");
        }
        if (!this.names().equals(fieldMergeWith.names())) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_name");
        }
        if (this.similarity == null) {
            if (fieldMergeWith.similarity() != null) {
                mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different similarity");
            }
        } else if (fieldMergeWith.similarity() == null) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different similarity");
        } else if (!this.similarity().equals(fieldMergeWith.similarity())) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different similarity");
        }
        this.multiFields.merge(mergeWith, mergeContext);
        if (!mergeContext.mergeFlags().simulate()) {
            this.fieldType = new FieldType(this.fieldType);
            this.fieldType.setOmitNorms(fieldMergeWith.fieldType.omitNorms());
            this.fieldType.freeze();
            this.boost = fieldMergeWith.boost;
            this.normsLoading = fieldMergeWith.normsLoading;
            this.copyTo = fieldMergeWith.copyTo;
            if (fieldMergeWith.postingsFormat != null) {
                this.postingsFormat = fieldMergeWith.postingsFormat;
            }
            if (fieldMergeWith.docValuesFormat != null) {
                this.docValuesFormat = fieldMergeWith.docValuesFormat;
            }
            if (fieldMergeWith.searchAnalyzer != null) {
                this.searchAnalyzer = fieldMergeWith.searchAnalyzer;
            }
            if (fieldMergeWith.customFieldDataSettings != null && !Objects.equal(fieldMergeWith.customFieldDataSettings, this.customFieldDataSettings)) {
                this.customFieldDataSettings = fieldMergeWith.customFieldDataSettings;
                this.fieldDataType = new FieldDataType(this.defaultFieldDataType().getType(), ImmutableSettings.builder().put(this.defaultFieldDataType().getSettings()).put(this.customFieldDataSettings));
            }
        }
    }

    @Override
    public PostingsFormatProvider postingsFormatProvider() {
        return this.postingsFormat;
    }

    @Override
    public DocValuesFormatProvider docValuesFormatProvider() {
        return this.docValuesFormat;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.names.name());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.doXContentBody(builder, includeDefaults, params);
        return builder.endObject();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        String format;
        builder.field("type", this.contentType());
        if (includeDefaults || !this.names.name().equals(this.names.indexNameClean())) {
            builder.field("index_name", this.names.indexNameClean());
        }
        if (includeDefaults || this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        FieldType defaultFieldType = this.defaultFieldType();
        if (includeDefaults || this.fieldType.indexed() != defaultFieldType.indexed() || this.fieldType.tokenized() != defaultFieldType.tokenized()) {
            builder.field("index", AbstractFieldMapper.indexTokenizeOptionToString(this.fieldType.indexed(), this.fieldType.tokenized()));
        }
        if (includeDefaults || this.fieldType.stored() != defaultFieldType.stored()) {
            builder.field("store", this.fieldType.stored());
        }
        if (includeDefaults || this.hasDocValues()) {
            builder.field("doc_values", this.docValues);
        }
        if (includeDefaults || this.fieldType.storeTermVectors() != defaultFieldType.storeTermVectors()) {
            builder.field("term_vector", AbstractFieldMapper.termVectorOptionsToString(this.fieldType));
        }
        if (includeDefaults || this.fieldType.omitNorms() != defaultFieldType.omitNorms() || this.normsLoading != null) {
            builder.startObject("norms");
            if (includeDefaults || this.fieldType.omitNorms() != defaultFieldType.omitNorms()) {
                builder.field("enabled", !this.fieldType.omitNorms());
            }
            if (this.normsLoading != null) {
                builder.field("loading", (Object)this.normsLoading);
            }
            builder.endObject();
        }
        if (includeDefaults || this.fieldType.indexOptions() != defaultFieldType.indexOptions()) {
            builder.field("index_options", AbstractFieldMapper.indexOptionToString(this.fieldType.indexOptions()));
        }
        if (this.indexAnalyzer == null && this.searchAnalyzer == null) {
            if (includeDefaults) {
                builder.field("analyzer", "default");
            }
        } else if (this.indexAnalyzer == null) {
            if (includeDefaults || !this.searchAnalyzer.name().startsWith("_") && !this.searchAnalyzer.name().equals("default")) {
                builder.field("search_analyzer", this.searchAnalyzer.name());
            }
        } else if (this.searchAnalyzer == null) {
            if (includeDefaults || !this.indexAnalyzer.name().startsWith("_") && !this.indexAnalyzer.name().equals("default")) {
                builder.field("index_analyzer", this.indexAnalyzer.name());
            }
        } else if (this.indexAnalyzer.name().equals(this.searchAnalyzer.name())) {
            if (includeDefaults || !this.indexAnalyzer.name().startsWith("_") && !this.indexAnalyzer.name().equals("default")) {
                builder.field("analyzer", this.indexAnalyzer.name());
            }
        } else {
            if (includeDefaults || !this.indexAnalyzer.name().startsWith("_") && !this.indexAnalyzer.name().equals("default")) {
                builder.field("index_analyzer", this.indexAnalyzer.name());
            }
            if (includeDefaults || !this.searchAnalyzer.name().startsWith("_") && !this.searchAnalyzer.name().equals("default")) {
                builder.field("search_analyzer", this.searchAnalyzer.name());
            }
        }
        if (this.postingsFormat != null) {
            if (includeDefaults || !this.postingsFormat.name().equals(this.defaultPostingFormat())) {
                builder.field("postings_format", this.postingsFormat.name());
            }
        } else if (includeDefaults) {
            format = this.defaultPostingFormat();
            if (format == null) {
                format = "default";
            }
            builder.field("postings_format", format);
        }
        if (this.docValuesFormat != null) {
            if (includeDefaults || !this.docValuesFormat.name().equals(this.defaultDocValuesFormat())) {
                builder.field("doc_values_format", this.docValuesFormat.name());
            }
        } else if (includeDefaults) {
            format = this.defaultDocValuesFormat();
            if (format == null) {
                format = "default";
            }
            builder.field("doc_values_format", format);
        }
        if (this.similarity() != null) {
            builder.field("similarity", this.similarity().name());
        } else if (includeDefaults) {
            builder.field("similariry", "default");
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
        this.multiFields.toXContent(builder, params);
        if (this.copyTo != null) {
            this.copyTo.toXContent(builder, params);
        }
    }

    protected static String indexOptionToString(FieldInfo.IndexOptions indexOption) {
        switch (indexOption) {
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return "offsets";
            }
            case DOCS_AND_FREQS: {
                return "freqs";
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return "positions";
            }
            case DOCS_ONLY: {
                return "docs";
            }
        }
        throw new ElasticsearchIllegalArgumentException("Unknown IndexOptions [" + indexOption + "]");
    }

    public static String termVectorOptionsToString(FieldType fieldType) {
        if (!fieldType.storeTermVectors()) {
            return "no";
        }
        if (!fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "yes";
        }
        if (fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "with_offsets";
        }
        StringBuilder builder = new StringBuilder("with");
        if (fieldType.storeTermVectorPositions()) {
            builder.append("_positions");
        }
        if (fieldType.storeTermVectorOffsets()) {
            builder.append("_offsets");
        }
        if (fieldType.storeTermVectorPayloads()) {
            builder.append("_payloads");
        }
        return builder.toString();
    }

    protected static String indexTokenizeOptionToString(boolean indexed, boolean tokenized) {
        if (!indexed) {
            return "no";
        }
        if (tokenized) {
            return "analyzed";
        }
        return "not_analyzed";
    }

    protected abstract String contentType();

    @Override
    public void close() {
        this.multiFields.close();
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isSortable() {
        return true;
    }

    @Override
    public boolean hasDocValues() {
        return this.docValues;
    }

    @Override
    public FieldMapper.Loading normsLoading(FieldMapper.Loading defaultLoading) {
        return this.normsLoading == null ? defaultLoading : this.normsLoading;
    }

    public static class CopyTo {
        private final ImmutableList<String> copyToFields;

        private CopyTo(ImmutableList<String> copyToFields) {
            this.copyToFields = copyToFields;
        }

        public void parse(ParseContext context) throws IOException {
            if (!context.isWithinCopyTo()) {
                for (String field : this.copyToFields) {
                    this.parse(field, context);
                }
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.copyToFields.isEmpty()) {
                builder.startArray("copy_to");
                for (String field : this.copyToFields) {
                    builder.value(field);
                }
                builder.endArray();
            }
            return builder;
        }

        public ImmutableList<String> copyToFields() {
            return this.copyToFields;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(String field, ParseContext context) throws IOException {
            context.setWithinCopyTo();
            FieldMappers mappers = context.docMapper().mappers().indexName(field);
            if (mappers != null && !mappers.isEmpty()) {
                mappers.mapper().parse(context);
            } else {
                int posDot = field.lastIndexOf(46);
                if (posDot > 0) {
                    String objectPath = field.substring(0, posDot);
                    String fieldPath = field.substring(posDot + 1);
                    ObjectMapper mapper = context.docMapper().objectMappers().get(objectPath);
                    if (mapper == null) {
                        throw new MapperParsingException("attempt to copy value to non-existing object [" + field + "]");
                    }
                    ContentPath.Type origPathType = context.path().pathType();
                    context.path().pathType(ContentPath.Type.FULL);
                    context.path().add(objectPath);
                    boolean origWithinNewMapper = context.isWithinNewMapper();
                    context.clearWithinNewMapper();
                    try {
                        mapper.parseDynamicValue(context, fieldPath, context.parser().currentToken());
                    }
                    finally {
                        if (origWithinNewMapper) {
                            context.setWithinNewMapper();
                        } else {
                            context.clearWithinNewMapper();
                        }
                        context.path().remove();
                        context.path().pathType(origPathType);
                    }
                }
                boolean origWithinNewMapper = context.isWithinNewMapper();
                context.clearWithinNewMapper();
                try {
                    context.docMapper().root().parseDynamicValue(context, field, context.parser().currentToken());
                }
                finally {
                    if (origWithinNewMapper) {
                        context.setWithinNewMapper();
                    } else {
                        context.clearWithinNewMapper();
                    }
                }
            }
            context.clearWithinCopyTo();
        }

        public static class Builder {
            private final ImmutableList.Builder<String> copyToBuilders = ImmutableList.builder();

            public Builder add(String field) {
                this.copyToBuilders.add((Object)field);
                return this;
            }

            public CopyTo build() {
                return new CopyTo((ImmutableList)this.copyToBuilders.build());
            }
        }
    }

    public static class MultiFields {
        private final ContentPath.Type pathType;
        private volatile ImmutableOpenMap<String, Mapper> mappers;

        public static MultiFields empty() {
            return new MultiFields(Defaults.PATH_TYPE, ImmutableOpenMap.of());
        }

        public MultiFields(ContentPath.Type pathType, ImmutableOpenMap<String, Mapper> mappers) {
            this.pathType = pathType;
            this.mappers = mappers;
            for (ObjectCursor<Mapper> objectCursor : mappers.values()) {
                Mapper mapper = (Mapper)objectCursor.value;
                if (!(mapper instanceof AllFieldMapper.IncludeInAll)) continue;
                ((AllFieldMapper.IncludeInAll)mapper).unsetIncludeInAll();
            }
        }

        public void parse(AbstractFieldMapper mainField, ParseContext context) throws IOException {
            if (this.mappers.isEmpty()) {
                return;
            }
            context.setWithinMultiFields();
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            context.path().add(mainField.name());
            for (ObjectCursor<Mapper> objectCursor : this.mappers.values()) {
                ((Mapper)objectCursor.value).parse(context);
            }
            context.path().remove();
            context.path().pathType(origPathType);
            context.clearWithinMultiFields();
        }

        public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
            AbstractFieldMapper mergeWithMultiField = (AbstractFieldMapper)mergeWith;
            ArrayList<FieldMapper> newFieldMappers = null;
            ImmutableOpenMap.Builder<String, Mapper> newMappersBuilder = null;
            for (ObjectCursor<Mapper> objectCursor : mergeWithMultiField.multiFields.mappers.values()) {
                Mapper mergeWithMapper = (Mapper)objectCursor.value;
                Mapper mergeIntoMapper = this.mappers.get(mergeWithMapper.name());
                if (mergeIntoMapper == null) {
                    if (mergeContext.mergeFlags().simulate()) continue;
                    if (mergeWithMapper instanceof AllFieldMapper.IncludeInAll) {
                        ((AllFieldMapper.IncludeInAll)mergeWithMapper).unsetIncludeInAll();
                    }
                    if (newMappersBuilder == null) {
                        newMappersBuilder = ImmutableOpenMap.builder(this.mappers);
                    }
                    newMappersBuilder.put(mergeWithMapper.name(), mergeWithMapper);
                    if (!(mergeWithMapper instanceof AbstractFieldMapper)) continue;
                    if (newFieldMappers == null) {
                        newFieldMappers = new ArrayList<FieldMapper>(2);
                    }
                    newFieldMappers.add((FieldMapper)mergeWithMapper);
                    continue;
                }
                mergeIntoMapper.merge(mergeWithMapper, mergeContext);
            }
            if (newFieldMappers != null) {
                mergeContext.docMapper().addFieldMappers(newFieldMappers);
            }
            if (newMappersBuilder != null) {
                this.mappers = newMappersBuilder.build();
            }
        }

        public void traverse(FieldMapperListener fieldMapperListener) {
            for (ObjectCursor<Mapper> objectCursor : this.mappers.values()) {
                ((Mapper)objectCursor.value).traverse(fieldMapperListener);
            }
        }

        public void close() {
            for (ObjectCursor<Mapper> objectCursor : this.mappers.values()) {
                ((Mapper)objectCursor.value).close();
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.pathType != Defaults.PATH_TYPE) {
                builder.field("path", this.pathType.name().toLowerCase(Locale.ROOT));
            }
            if (!this.mappers.isEmpty()) {
                builder.startObject("fields");
                for (ObjectCursor<Mapper> objectCursor : this.mappers.values()) {
                    ((Mapper)objectCursor.value).toXContent(builder, params);
                }
                builder.endObject();
            }
            return builder;
        }

        public static class Builder {
            private final ImmutableOpenMap.Builder<String, Mapper.Builder> mapperBuilders = ImmutableOpenMap.builder();
            private ContentPath.Type pathType = Defaults.PATH_TYPE;

            public Builder pathType(ContentPath.Type pathType) {
                this.pathType = pathType;
                return this;
            }

            public Builder add(Mapper.Builder builder) {
                this.mapperBuilders.put(builder.name(), builder);
                return this;
            }

            public MultiFields build(org.elasticsearch.index.mapper.core.AbstractFieldMapper$Builder mainFieldBuilder, Mapper.BuilderContext context) {
                if (this.pathType == Defaults.PATH_TYPE && this.mapperBuilders.isEmpty()) {
                    return MultiFields.empty();
                }
                if (this.mapperBuilders.isEmpty()) {
                    return new MultiFields(this.pathType, ImmutableOpenMap.of());
                }
                ContentPath.Type origPathType = context.path().pathType();
                context.path().pathType(this.pathType);
                context.path().add(mainFieldBuilder.name());
                ImmutableOpenMap.Builder<String, Mapper.Builder> mapperBuilders = this.mapperBuilders;
                for (ObjectObjectCursor<String, Mapper.Builder> objectObjectCursor : this.mapperBuilders) {
                    String key = (String)objectObjectCursor.key;
                    Mapper.Builder value = (Mapper.Builder)objectObjectCursor.value;
                    mapperBuilders.put(key, (Mapper.Builder)value.build(context));
                }
                context.path().remove();
                context.path().pathType(origPathType);
                ImmutableOpenMap.Builder mappers = mapperBuilders.cast();
                return new MultiFields(this.pathType, mappers.build());
            }
        }
    }

    public static abstract class Builder<T extends Builder, Y extends AbstractFieldMapper>
    extends Mapper.Builder<T, Y> {
        protected final FieldType fieldType;
        protected Boolean docValues;
        protected float boost = 1.0f;
        protected boolean omitNormsSet = false;
        protected String indexName;
        protected NamedAnalyzer indexAnalyzer;
        protected NamedAnalyzer searchAnalyzer;
        protected Boolean includeInAll;
        protected boolean indexOptionsSet = false;
        protected PostingsFormatProvider postingsProvider;
        protected DocValuesFormatProvider docValuesProvider;
        protected SimilarityProvider similarity;
        protected FieldMapper.Loading normsLoading;
        @Nullable
        protected Settings fieldDataSettings;
        protected final MultiFields.Builder multiFieldsBuilder;
        protected CopyTo copyTo;

        protected Builder(String name, FieldType fieldType) {
            super(name);
            this.fieldType = fieldType;
            this.multiFieldsBuilder = new MultiFields.Builder();
        }

        public T index(boolean index) {
            this.fieldType.setIndexed(index);
            return (T)((Builder)this.builder);
        }

        public T store(boolean store) {
            this.fieldType.setStored(store);
            return (T)((Builder)this.builder);
        }

        public T docValues(boolean docValues) {
            this.docValues = docValues;
            return (T)((Builder)this.builder);
        }

        public T storeTermVectors(boolean termVectors) {
            if (termVectors) {
                this.fieldType.setStoreTermVectors(termVectors);
            }
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorOffsets(boolean termVectorOffsets) {
            if (termVectorOffsets) {
                this.fieldType.setStoreTermVectors(termVectorOffsets);
            }
            this.fieldType.setStoreTermVectorOffsets(termVectorOffsets);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPositions(boolean termVectorPositions) {
            if (termVectorPositions) {
                this.fieldType.setStoreTermVectors(termVectorPositions);
            }
            this.fieldType.setStoreTermVectorPositions(termVectorPositions);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPayloads(boolean termVectorPayloads) {
            if (termVectorPayloads) {
                this.fieldType.setStoreTermVectors(termVectorPayloads);
            }
            this.fieldType.setStoreTermVectorPayloads(termVectorPayloads);
            return (T)((Builder)this.builder);
        }

        public T tokenized(boolean tokenized) {
            this.fieldType.setTokenized(tokenized);
            return (T)((Builder)this.builder);
        }

        public T boost(float boost) {
            this.boost = boost;
            return (T)((Builder)this.builder);
        }

        public T omitNorms(boolean omitNorms) {
            this.fieldType.setOmitNorms(omitNorms);
            this.omitNormsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexOptions(FieldInfo.IndexOptions indexOptions) {
            this.fieldType.setIndexOptions(indexOptions);
            this.indexOptionsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexName(String indexName) {
            this.indexName = indexName;
            return (T)((Builder)this.builder);
        }

        public T indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.indexAnalyzer = indexAnalyzer;
            return (T)((Builder)this.builder);
        }

        public T searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.searchAnalyzer = searchAnalyzer;
            return (T)((Builder)this.builder);
        }

        public T includeInAll(Boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        public T postingsFormat(PostingsFormatProvider postingsFormat) {
            this.postingsProvider = postingsFormat;
            return (T)((Builder)this.builder);
        }

        public T docValuesFormat(DocValuesFormatProvider docValuesFormat) {
            this.docValuesProvider = docValuesFormat;
            return (T)((Builder)this.builder);
        }

        public T similarity(SimilarityProvider similarity) {
            this.similarity = similarity;
            return (T)((Builder)this.builder);
        }

        public T normsLoading(FieldMapper.Loading normsLoading) {
            this.normsLoading = normsLoading;
            return (T)((Builder)this.builder);
        }

        public T fieldDataSettings(Settings settings) {
            this.fieldDataSettings = settings;
            return (T)((Builder)this.builder);
        }

        public T multiFieldPathType(ContentPath.Type pathType) {
            this.multiFieldsBuilder.pathType(pathType);
            return (T)((Builder)this.builder);
        }

        public T addMultiField(Mapper.Builder mapperBuilder) {
            this.multiFieldsBuilder.add(mapperBuilder);
            return (T)((Builder)this.builder);
        }

        public T copyTo(CopyTo copyTo) {
            this.copyTo = copyTo;
            return (T)((Builder)this.builder);
        }

        public FieldMapper.Names buildNames(Mapper.BuilderContext context) {
            return new FieldMapper.Names(this.name, this.buildIndexName(context), this.indexName == null ? this.name : this.indexName, this.buildFullName(context), context.path().sourcePath());
        }

        public String buildIndexName(Mapper.BuilderContext context) {
            String actualIndexName = this.indexName == null ? this.name : this.indexName;
            return context.path().pathAsText(actualIndexName);
        }

        public String buildFullName(Mapper.BuilderContext context) {
            return context.path().fullPathAsText(this.name);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final boolean DOC_VALUES = false;
        public static final float BOOST = 1.0f;
        public static final ContentPath.Type PATH_TYPE;

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setOmitNorms(false);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.freeze();
            PATH_TYPE = ContentPath.Type.FULL;
        }
    }
}

