/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongBitSet;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.search.internal.SearchContext;

final class ParentIdsFilter
extends Filter {
    private final BytesRef parentTypeBr;
    private final Filter nonNestedDocsFilter;
    private final BytesRefHash parentIds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Filter createShortCircuitFilter(Filter nonNestedDocsFilter, SearchContext searchContext, String parentType, BytesValues.WithOrdinals globalValues, LongBitSet parentOrds, long numFoundParents) {
        BytesRefHash parentIds;
        block6: {
            if (numFoundParents == 1L) {
                globalValues.getValueByOrd(parentOrds.nextSetBit(0L));
                BytesRef id = globalValues.copyShared();
                if (nonNestedDocsFilter != null) {
                    List<Filter> filters = Arrays.asList(new TermFilter(new Term("_uid", Uid.createUidAsBytes(parentType, id))), nonNestedDocsFilter);
                    return new AndFilter(filters);
                }
                return new TermFilter(new Term("_uid", Uid.createUidAsBytes(parentType, id)));
            }
            parentIds = null;
            boolean constructed = false;
            try {
                parentIds = new BytesRefHash(numFoundParents, searchContext.bigArrays());
                long parentOrd = parentOrds.nextSetBit(0L);
                while (parentOrd != -1L) {
                    parentIds.add(globalValues.getValueByOrd(parentOrd));
                    parentOrd = parentOrds.nextSetBit(parentOrd + 1L);
                }
                constructed = true;
                if (constructed) break block6;
            }
            catch (Throwable throwable) {
                if (!constructed) {
                    Releasables.close(parentIds);
                }
                throw throwable;
            }
            Releasables.close(parentIds);
        }
        searchContext.addReleasable(parentIds, SearchContext.Lifetime.COLLECTION);
        return new ParentIdsFilter(parentType, nonNestedDocsFilter, parentIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Filter createShortCircuitFilter(Filter nonNestedDocsFilter, SearchContext searchContext, String parentType, BytesValues.WithOrdinals globalValues, LongHash parentIdxs, long numFoundParents) {
        BytesRefHash parentIds;
        block6: {
            if (numFoundParents == 1L) {
                globalValues.getValueByOrd(parentIdxs.get(0L));
                BytesRef id = globalValues.copyShared();
                if (nonNestedDocsFilter != null) {
                    List<Filter> filters = Arrays.asList(new TermFilter(new Term("_uid", Uid.createUidAsBytes(parentType, id))), nonNestedDocsFilter);
                    return new AndFilter(filters);
                }
                return new TermFilter(new Term("_uid", Uid.createUidAsBytes(parentType, id)));
            }
            parentIds = null;
            boolean constructed = false;
            try {
                parentIds = new BytesRefHash(numFoundParents, searchContext.bigArrays());
                int id = 0;
                while ((long)id < parentIdxs.size()) {
                    parentIds.add(globalValues.getValueByOrd(parentIdxs.get(id)));
                    ++id;
                }
                constructed = true;
                if (constructed) break block6;
            }
            catch (Throwable throwable) {
                if (!constructed) {
                    Releasables.close(parentIds);
                }
                throw throwable;
            }
            Releasables.close(parentIds);
        }
        searchContext.addReleasable(parentIds, SearchContext.Lifetime.COLLECTION);
        return new ParentIdsFilter(parentType, nonNestedDocsFilter, parentIds);
    }

    private ParentIdsFilter(String parentType, Filter nonNestedDocsFilter, BytesRefHash parentIds) {
        this.nonNestedDocsFilter = nonNestedDocsFilter;
        this.parentTypeBr = new BytesRef((CharSequence)parentType);
        this.parentIds = parentIds;
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        Terms terms = context.reader().terms("_uid");
        if (terms == null) {
            return null;
        }
        TermsEnum termsEnum = terms.iterator(null);
        BytesRef uidSpare = new BytesRef();
        BytesRef idSpare = new BytesRef();
        if (acceptDocs == null) {
            acceptDocs = context.reader().getLiveDocs();
        }
        FixedBitSet nonNestedDocs = null;
        if (this.nonNestedDocsFilter != null) {
            nonNestedDocs = (FixedBitSet)this.nonNestedDocsFilter.getDocIdSet(context, acceptDocs);
        }
        DocsEnum docsEnum = null;
        FixedBitSet result = null;
        long size = this.parentIds.size();
        int i = 0;
        while ((long)i < size) {
            block9: {
                int docId;
                block11: {
                    block10: {
                        this.parentIds.get(i, idSpare);
                        Uid.createUidAsBytes(this.parentTypeBr, idSpare, uidSpare);
                        if (!termsEnum.seekExact(uidSpare)) break block9;
                        docsEnum = termsEnum.docs(acceptDocs, docsEnum, 0);
                        if (result != null) break block10;
                        docId = docsEnum.nextDoc();
                        if (docId == Integer.MAX_VALUE) break block9;
                        result = new FixedBitSet(context.reader().maxDoc());
                        break block11;
                    }
                    docId = docsEnum.nextDoc();
                    if (docId == Integer.MAX_VALUE) break block9;
                }
                if (nonNestedDocs != null && !nonNestedDocs.get(docId)) {
                    docId = nonNestedDocs.nextSetBit(docId);
                }
                result.set(docId);
                assert (docsEnum.advance(docId + 1) == Integer.MAX_VALUE) : "DocId " + docId + " should have been the last one but docId " + docsEnum.docID() + " exists.";
            }
            ++i;
        }
        return result;
    }
}

