/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.fielddata.cache;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.RamUsage;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class IndicesFieldDataCacheListener
implements IndexFieldDataCache.Listener {
    private final CircuitBreakerService circuitBreakerService;

    @Inject
    public IndicesFieldDataCacheListener(CircuitBreakerService circuitBreakerService) {
        this.circuitBreakerService = circuitBreakerService;
    }

    @Override
    public void onLoad(FieldMapper.Names fieldNames, FieldDataType fieldDataType, RamUsage fieldData) {
    }

    @Override
    public void onUnload(FieldMapper.Names fieldNames, FieldDataType fieldDataType, boolean wasEvicted, long sizeInBytes) {
        assert (sizeInBytes >= 0L) : "When reducing circuit breaker, it should be adjusted with a number higher or equal to 0 and not [" + sizeInBytes + "]";
        this.circuitBreakerService.getBreaker().addWithoutBreaking(-sizeInBytes);
    }
}

