/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.exists.indices;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestResponseListener;

public class RestIndicesExistsAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestIndicesExistsAction(Settings settings, Client client, RestController controller, SettingsFilter settingsFilter) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        IndicesExistsRequest indicesExistsRequest = new IndicesExistsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        indicesExistsRequest.indicesOptions(IndicesOptions.fromRequest(request, indicesExistsRequest.indicesOptions()));
        indicesExistsRequest.local(request.paramAsBoolean("local", indicesExistsRequest.local()));
        indicesExistsRequest.listenerThreaded(false);
        this.client.admin().indices().exists(indicesExistsRequest, (ActionListener<IndicesExistsResponse>)new RestResponseListener<IndicesExistsResponse>(channel){

            @Override
            public RestResponse buildResponse(IndicesExistsResponse response) {
                if (response.isExists()) {
                    return new BytesRestResponse(RestStatus.OK);
                }
                return new BytesRestResponse(RestStatus.NOT_FOUND);
            }
        });
    }
}

