/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.settings;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestGetSettingsAction
extends BaseRestHandler {
    @Inject
    public RestGetSettingsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_settings", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_settings", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_settings/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_settings/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_setting/{name}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel) {
        String[] names = request.paramAsStringArrayOrEmptyIfAll("name");
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(Strings.splitStringByCommaToArray(request.param("index"))).indicesOptions(IndicesOptions.fromRequest(request, IndicesOptions.strictExpandOpen())).names(names);
        getSettingsRequest.local(request.paramAsBoolean("local", getSettingsRequest.local()));
        this.client.admin().indices().getSettings(getSettingsRequest, (ActionListener<GetSettingsResponse>)new RestBuilderListener<GetSettingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetSettingsResponse getSettingsResponse, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (ObjectObjectCursor<String, Settings> objectObjectCursor : getSettingsResponse.getIndexToSettings()) {
                    if (((Settings)objectObjectCursor.value).getAsMap().isEmpty()) continue;
                    builder.startObject((String)objectObjectCursor.key, XContentBuilder.FieldCaseConversion.NONE);
                    builder.startObject(Fields.SETTINGS);
                    ((Settings)objectObjectCursor.value).toXContent(builder, request);
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    static class Fields {
        static final XContentBuilderString SETTINGS = new XContentBuilderString("settings");

        Fields() {
        }
    }
}

