/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.Locale;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterIndexHealth;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestActionListener;
import org.elasticsearch.rest.action.support.RestResponseListener;
import org.elasticsearch.rest.action.support.RestTable;

public class RestIndicesAction
extends AbstractCatAction {
    @Inject
    public RestIndicesAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/indices", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/indices/{index}", this);
    }

    @Override
    void documentation(StringBuilder sb) {
        sb.append("/_cat/indices\n");
        sb.append("/_cat/indices/{index}\n");
    }

    @Override
    public void doRequest(final RestRequest request, RestChannel channel) {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().indices(indices).metaData(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(ClusterStateResponse clusterStateResponse) {
                final String[] concreteIndices = clusterStateResponse.getState().metaData().concreteIndices(IndicesOptions.lenientExpandOpen(), indices);
                ClusterHealthRequest clusterHealthRequest = Requests.clusterHealthRequest(concreteIndices);
                clusterHealthRequest.local(request.paramAsBoolean("local", clusterHealthRequest.local()));
                RestIndicesAction.this.client.admin().cluster().health(clusterHealthRequest, (ActionListener<ClusterHealthResponse>)new RestActionListener<ClusterHealthResponse>(this.channel){

                    @Override
                    public void processResponse(final ClusterHealthResponse clusterHealthResponse) {
                        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
                        indicesStatsRequest.all();
                        RestIndicesAction.this.client.admin().indices().stats(indicesStatsRequest, (ActionListener<IndicesStatsResponse>)new RestResponseListener<IndicesStatsResponse>(this.channel){

                            @Override
                            public RestResponse buildResponse(IndicesStatsResponse indicesStatsResponse) throws Exception {
                                Table tab = RestIndicesAction.this.buildTable(request, concreteIndices, clusterHealthResponse, indicesStatsResponse);
                                return RestTable.buildResponse(tab, this.channel);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("health", "alias:h;desc:current health status");
        table.addCell("index", "alias:i,idx;desc:index name");
        table.addCell("pri", "alias:p,shards.primary,shardsPrimary;text-align:right;desc:number of primary shards");
        table.addCell("rep", "alias:r,shards.replica,shardsReplica;text-align:right;desc:number of replica shards");
        table.addCell("docs.count", "alias:dc,docsCount;text-align:right;desc:available docs");
        table.addCell("docs.deleted", "alias:dd,docsDeleted;text-align:right;desc:deleted docs");
        table.addCell("store.size", "sibling:pri;alias:ss,storeSize;text-align:right;desc:store size of primaries & replicas");
        table.addCell("pri.store.size", "text-align:right;desc:store size of primaries");
        table.addCell("completion.size", "sibling:pri;alias:cs,completionSize;default:false;text-align:right;desc:size of completion");
        table.addCell("pri.completion.size", "default:false;text-align:right;desc:size of completion");
        table.addCell("fielddata.memory_size", "sibling:pri;alias:fm,fielddataMemory;default:false;text-align:right;desc:used fielddata cache");
        table.addCell("pri.fielddata.memory_size", "default:false;text-align:right;desc:used fielddata cache");
        table.addCell("fielddata.evictions", "sibling:pri;alias:fe,fielddataEvictions;default:false;text-align:right;desc:fielddata evictions");
        table.addCell("pri.fielddata.evictions", "default:false;text-align:right;desc:fielddata evictions");
        table.addCell("filter_cache.memory_size", "sibling:pri;alias:fcm,filterCacheMemory;default:false;text-align:right;desc:used filter cache");
        table.addCell("pri.filter_cache.memory_size", "default:false;text-align:right;desc:used filter cache");
        table.addCell("filter_cache.evictions", "sibling:pri;alias:fce,filterCacheEvictions;default:false;text-align:right;desc:filter cache evictions");
        table.addCell("pri.filter_cache.evictions", "default:false;text-align:right;desc:filter cache evictions");
        table.addCell("flush.total", "sibling:pri;alias:ft,flushTotal;default:false;text-align:right;desc:number of flushes");
        table.addCell("pri.flush.total", "default:false;text-align:right;desc:number of flushes");
        table.addCell("flush.total_time", "sibling:pri;alias:ftt,flushTotalTime;default:false;text-align:right;desc:time spent in flush");
        table.addCell("pri.flush.total_time", "default:false;text-align:right;desc:time spent in flush");
        table.addCell("get.current", "sibling:pri;alias:gc,getCurrent;default:false;text-align:right;desc:number of current get ops");
        table.addCell("pri.get.current", "default:false;text-align:right;desc:number of current get ops");
        table.addCell("get.time", "sibling:pri;alias:gti,getTime;default:false;text-align:right;desc:time spent in get");
        table.addCell("pri.get.time", "default:false;text-align:right;desc:time spent in get");
        table.addCell("get.total", "sibling:pri;alias:gto,getTotal;default:false;text-align:right;desc:number of get ops");
        table.addCell("pri.get.total", "default:false;text-align:right;desc:number of get ops");
        table.addCell("get.exists_time", "sibling:pri;alias:geti,getExistsTime;default:false;text-align:right;desc:time spent in successful gets");
        table.addCell("pri.get.exists_time", "default:false;text-align:right;desc:time spent in successful gets");
        table.addCell("get.exists_total", "sibling:pri;alias:geto,getExistsTotal;default:false;text-align:right;desc:number of successful gets");
        table.addCell("pri.get.exists_total", "default:false;text-align:right;desc:number of successful gets");
        table.addCell("get.missing_time", "sibling:pri;alias:gmti,getMissingTime;default:false;text-align:right;desc:time spent in failed gets");
        table.addCell("pri.get.missing_time", "default:false;text-align:right;desc:time spent in failed gets");
        table.addCell("get.missing_total", "sibling:pri;alias:gmto,getMissingTotal;default:false;text-align:right;desc:number of failed gets");
        table.addCell("pri.get.missing_total", "default:false;text-align:right;desc:number of failed gets");
        table.addCell("id_cache.memory_size", "sibling:pri;alias:im,idCacheMemory;default:false;text-align:right;desc:used id cache");
        table.addCell("pri.id_cache.memory_size", "default:false;text-align:right;desc:used id cache");
        table.addCell("indexing.delete_current", "sibling:pri;alias:idc,indexingDeleteCurrent;default:false;text-align:right;desc:number of current deletions");
        table.addCell("pri.indexing.delete_current", "default:false;text-align:right;desc:number of current deletions");
        table.addCell("indexing.delete_time", "sibling:pri;alias:idti,indexingDeleteTime;default:false;text-align:right;desc:time spent in deletions");
        table.addCell("pri.indexing.delete_time", "default:false;text-align:right;desc:time spent in deletions");
        table.addCell("indexing.delete_total", "sibling:pri;alias:idto,indexingDeleteTotal;default:false;text-align:right;desc:number of delete ops");
        table.addCell("pri.indexing.delete_total", "default:false;text-align:right;desc:number of delete ops");
        table.addCell("indexing.index_current", "sibling:pri;alias:iic,indexingIndexCurrent;default:false;text-align:right;desc:number of current indexing ops");
        table.addCell("pri.indexing.index_current", "default:false;text-align:right;desc:number of current indexing ops");
        table.addCell("indexing.index_time", "sibling:pri;alias:iiti,indexingIndexTime;default:false;text-align:right;desc:time spent in indexing");
        table.addCell("pri.indexing.index_time", "default:false;text-align:right;desc:time spent in indexing");
        table.addCell("indexing.index_total", "sibling:pri;alias:iito,indexingIndexTotal;default:false;text-align:right;desc:number of indexing ops");
        table.addCell("pri.indexing.index_total", "default:false;text-align:right;desc:number of indexing ops");
        table.addCell("merges.current", "sibling:pri;alias:mc,mergesCurrent;default:false;text-align:right;desc:number of current merges");
        table.addCell("pri.merges.current", "default:false;text-align:right;desc:number of current merges");
        table.addCell("merges.current_docs", "sibling:pri;alias:mcd,mergesCurrentDocs;default:false;text-align:right;desc:number of current merging docs");
        table.addCell("pri.merges.current_docs", "default:false;text-align:right;desc:number of current merging docs");
        table.addCell("merges.current_size", "sibling:pri;alias:mcs,mergesCurrentSize;default:false;text-align:right;desc:size of current merges");
        table.addCell("pri.merges.current_size", "default:false;text-align:right;desc:size of current merges");
        table.addCell("merges.total", "sibling:pri;alias:mt,mergesTotal;default:false;text-align:right;desc:number of completed merge ops");
        table.addCell("pri.merges.total", "default:false;text-align:right;desc:number of completed merge ops");
        table.addCell("merges.total_docs", "sibling:pri;alias:mtd,mergesTotalDocs;default:false;text-align:right;desc:docs merged");
        table.addCell("pri.merges.total_docs", "default:false;text-align:right;desc:docs merged");
        table.addCell("merges.total_size", "sibling:pri;alias:mts,mergesTotalSize;default:false;text-align:right;desc:size merged");
        table.addCell("pri.merges.total_size", "default:false;text-align:right;desc:size merged");
        table.addCell("merges.total_time", "sibling:pri;alias:mtt,mergesTotalTime;default:false;text-align:right;desc:time spent in merges");
        table.addCell("pri.merges.total_time", "default:false;text-align:right;desc:time spent in merges");
        table.addCell("percolate.current", "sibling:pri;alias:pc,percolateCurrent;default:false;text-align:right;desc:number of current percolations");
        table.addCell("pri.percolate.current", "default:false;text-align:right;desc:number of current percolations");
        table.addCell("percolate.memory_size", "sibling:pri;alias:pm,percolateMemory;default:false;text-align:right;desc:memory used by percolations");
        table.addCell("pri.percolate.memory_size", "default:false;text-align:right;desc:memory used by percolations");
        table.addCell("percolate.queries", "sibling:pri;alias:pq,percolateQueries;default:false;text-align:right;desc:number of registered percolation queries");
        table.addCell("pri.percolate.queries", "default:false;text-align:right;desc:number of registered percolation queries");
        table.addCell("percolate.time", "sibling:pri;alias:pti,percolateTime;default:false;text-align:right;desc:time spent percolating");
        table.addCell("pri.percolate.time", "default:false;text-align:right;desc:time spent percolating");
        table.addCell("percolate.total", "sibling:pri;alias:pto,percolateTotal;default:false;text-align:right;desc:total percolations");
        table.addCell("pri.percolate.total", "default:false;text-align:right;desc:total percolations");
        table.addCell("refresh.total", "sibling:pri;alias:rto,refreshTotal;default:false;text-align:right;desc:total refreshes");
        table.addCell("pri.refresh.total", "default:false;text-align:right;desc:total refreshes");
        table.addCell("refresh.time", "sibling:pri;alias:rti,refreshTime;default:false;text-align:right;desc:time spent in refreshes");
        table.addCell("pri.refresh.time", "default:false;text-align:right;desc:time spent in refreshes");
        table.addCell("search.fetch_current", "sibling:pri;alias:sfc,searchFetchCurrent;default:false;text-align:right;desc:current fetch phase ops");
        table.addCell("pri.search.fetch_current", "default:false;text-align:right;desc:current fetch phase ops");
        table.addCell("search.fetch_time", "sibling:pri;alias:sfti,searchFetchTime;default:false;text-align:right;desc:time spent in fetch phase");
        table.addCell("pri.search.fetch_time", "default:false;text-align:right;desc:time spent in fetch phase");
        table.addCell("search.fetch_total", "sibling:pri;alias:sfto,searchFetchTotal;default:false;text-align:right;desc:total fetch ops");
        table.addCell("pri.search.fetch_total", "default:false;text-align:right;desc:total fetch ops");
        table.addCell("search.open_contexts", "sibling:pri;alias:so,searchOpenContexts;default:false;text-align:right;desc:open search contexts");
        table.addCell("pri.search.open_contexts", "default:false;text-align:right;desc:open search contexts");
        table.addCell("search.query_current", "sibling:pri;alias:sqc,searchQueryCurrent;default:false;text-align:right;desc:current query phase ops");
        table.addCell("pri.search.query_current", "default:false;text-align:right;desc:current query phase ops");
        table.addCell("search.query_time", "sibling:pri;alias:sqti,searchQueryTime;default:false;text-align:right;desc:time spent in query phase");
        table.addCell("pri.search.query_time", "default:false;text-align:right;desc:time spent in query phase");
        table.addCell("search.query_total", "sibling:pri;alias:sqto,searchQueryTotal;default:false;text-align:right;desc:total query phase ops");
        table.addCell("pri.search.query_total", "default:false;text-align:right;desc:total query phase ops");
        table.addCell("segments.count", "sibling:pri;alias:sc,segmentsCount;default:false;text-align:right;desc:number of segments");
        table.addCell("pri.segments.count", "default:false;text-align:right;desc:number of segments");
        table.addCell("segments.memory", "sibling:pri;alias:sm,segmentsMemory;default:false;text-align:right;desc:memory used by segments");
        table.addCell("pri.segments.memory", "default:false;text-align:right;desc:memory used by segments");
        table.addCell("warmer.current", "sibling:pri;alias:wc,warmerCurrent;default:false;text-align:right;desc:current warmer ops");
        table.addCell("pri.warmer.current", "default:false;text-align:right;desc:current warmer ops");
        table.addCell("warmer.total", "sibling:pri;alias:wto,warmerTotal;default:false;text-align:right;desc:total warmer ops");
        table.addCell("pri.warmer.total", "default:false;text-align:right;desc:total warmer ops");
        table.addCell("warmer.total_time", "sibling:pri;alias:wtt,warmerTotalTime;default:false;text-align:right;desc:time spent in warmers");
        table.addCell("pri.warmer.total_time", "default:false;text-align:right;desc:time spent in warmers");
        table.addCell("suggest.current", "sibling:pri;alias:suc,suggestCurrent;default:false;text-align:right;desc:number of current suggest ops");
        table.addCell("pri.suggest.current", "default:false;text-align:right;desc:number of current suggest ops");
        table.addCell("suggest.time", "sibling:pri;alias:suti,suggestTime;default:false;text-align:right;desc:time spend in suggest");
        table.addCell("pri.suggest.time", "default:false;text-align:right;desc:time spend in suggest");
        table.addCell("suggest.total", "sibling:pri;alias:suto,suggestTotal;default:false;text-align:right;desc:number of suggest ops");
        table.addCell("pri.suggest.total", "default:false;text-align:right;desc:number of suggest ops");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, String[] indices, ClusterHealthResponse health, IndicesStatsResponse stats) {
        Table table = this.getTableWithHeader(request);
        for (String index : indices) {
            ClusterIndexHealth indexHealth = health.getIndices().get(index);
            IndexStats indexStats = stats.getIndices().get(index);
            table.startRow();
            table.addCell(indexHealth == null ? "red*" : indexHealth.getStatus().toString().toLowerCase(Locale.getDefault()));
            table.addCell(index);
            table.addCell(indexHealth == null ? null : Integer.valueOf(indexHealth.getNumberOfShards()));
            table.addCell(indexHealth == null ? null : Integer.valueOf(indexHealth.getNumberOfReplicas()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getDocs().getCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getDocs().getDeleted()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getStore().size());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getStore().size());
            table.addCell(indexStats == null ? null : indexStats.getTotal().getCompletion().getSize());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getCompletion().getSize());
            table.addCell(indexStats == null ? null : indexStats.getTotal().getFieldData().getMemorySize());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getFieldData().getMemorySize());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getFieldData().getEvictions()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getFieldData().getEvictions()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getFilterCache().getMemorySize());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getFilterCache().getMemorySize());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getFilterCache().getEvictions()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getFilterCache().getEvictions()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getFlush().getTotal()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getFlush().getTotal()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getFlush().getTotalTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getFlush().getTotalTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getGet().current()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getGet().current()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getGet().getTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getGet().getTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getGet().getCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getGet().getCount()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getGet().getExistsTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getGet().getExistsTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getGet().getExistsCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getGet().getExistsCount()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getGet().getMissingTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getGet().getMissingTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getGet().getMissingCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getGet().getMissingCount()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getIdCache().getMemorySize());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getIdCache().getMemorySize());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getIndexing().getTotal().getDeleteCurrent()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getIndexing().getTotal().getDeleteCurrent()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getIndexing().getTotal().getDeleteTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getIndexing().getTotal().getDeleteTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getIndexing().getTotal().getDeleteCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getIndexing().getTotal().getDeleteCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getIndexing().getTotal().getIndexCurrent()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getIndexing().getTotal().getIndexCurrent()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getIndexing().getTotal().getIndexTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getIndexing().getTotal().getIndexTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getIndexing().getTotal().getIndexCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getIndexing().getTotal().getIndexCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getMerge().getCurrent()));
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getMerge().getCurrentSize());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getMerge().getCurrentNumDocs()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getMerge().getCurrentNumDocs()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getMerge().getCurrentSize());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getMerge().getCurrent()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getMerge().getTotal()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getMerge().getTotal()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getMerge().getTotalNumDocs()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getMerge().getTotalNumDocs()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getMerge().getTotalSize());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getMerge().getTotalSize());
            table.addCell(indexStats == null ? null : indexStats.getTotal().getMerge().getTotalTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getMerge().getTotalTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getPercolate().getCurrent()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getPercolate().getCurrent()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getPercolate().getMemorySize());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getPercolate().getMemorySize());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getPercolate().getNumQueries()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getPercolate().getNumQueries()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getPercolate().getTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getPercolate().getTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getPercolate().getCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getPercolate().getCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getRefresh().getTotal()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getRefresh().getTotal()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getRefresh().getTotalTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getRefresh().getTotalTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getSearch().getTotal().getFetchCurrent()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getSearch().getTotal().getFetchCurrent()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getSearch().getTotal().getFetchTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getSearch().getTotal().getFetchTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getSearch().getTotal().getFetchCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getSearch().getTotal().getFetchCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getSearch().getOpenContexts()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getSearch().getOpenContexts()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getSearch().getTotal().getQueryCurrent()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getSearch().getTotal().getQueryCurrent()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getSearch().getTotal().getQueryTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getSearch().getTotal().getQueryTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getSearch().getTotal().getQueryCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getSearch().getTotal().getQueryCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getSegments().getCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getSegments().getCount()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getSegments().getMemory());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getSegments().getMemory());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getWarmer().current()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getWarmer().current()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getWarmer().total()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getWarmer().total()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getWarmer().totalTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getWarmer().totalTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getSuggest().getCurrent()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getSuggest().getCurrent()));
            table.addCell(indexStats == null ? null : indexStats.getTotal().getSuggest().getTime());
            table.addCell(indexStats == null ? null : indexStats.getPrimaries().getSuggest().getTime());
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getTotal().getSuggest().getCount()));
            table.addCell(indexStats == null ? null : Long.valueOf(indexStats.getPrimaries().getSuggest().getCount()));
            table.endRow();
        }
        return table;
    }
}

