/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;

public abstract class Aggregator
extends BucketCollector
implements Releasable {
    private static final Predicate<Aggregator> COLLECTABLE_AGGREGATOR = new Predicate<Aggregator>(){

        @Override
        public boolean apply(Aggregator aggregator) {
            return aggregator.shouldCollect();
        }
    };
    protected final String name;
    protected final Aggregator parent;
    protected final AggregationContext context;
    protected final BigArrays bigArrays;
    protected final int depth;
    protected final long estimatedBucketCount;
    protected final BucketAggregationMode bucketAggregationMode;
    protected final AggregatorFactories factories;
    protected final Aggregator[] subAggregators;
    protected final BucketCollector collectableSugAggregators;
    private Map<String, Aggregator> subAggregatorbyName;

    public static boolean hasParentBucketAggregator(Aggregator parent) {
        if (parent == null) {
            return false;
        }
        if (parent.bucketAggregationMode() == BucketAggregationMode.PER_BUCKET) {
            return true;
        }
        return Aggregator.hasParentBucketAggregator(parent.parent());
    }

    protected Aggregator(String name, BucketAggregationMode bucketAggregationMode, AggregatorFactories factories, long estimatedBucketsCount, AggregationContext context, Aggregator parent) {
        this.name = name;
        this.parent = parent;
        this.estimatedBucketCount = estimatedBucketsCount;
        this.context = context;
        this.bigArrays = context.bigArrays();
        this.depth = parent == null ? 0 : 1 + parent.depth();
        this.bucketAggregationMode = bucketAggregationMode;
        assert (factories != null) : "sub-factories provided to BucketAggregator must not be null, use AggragatorFactories.EMPTY instead";
        this.factories = factories;
        this.subAggregators = factories.createSubAggregators(this, estimatedBucketsCount);
        this.collectableSugAggregators = BucketCollector.wrap(Iterables.filter(Arrays.asList(this.subAggregators), COLLECTABLE_AGGREGATOR));
        context.searchContext().addReleasable(this, SearchContext.Lifetime.PHASE);
    }

    public String name() {
        return this.name;
    }

    public final long estimatedBucketCount() {
        return this.estimatedBucketCount;
    }

    public final int depth() {
        return this.depth;
    }

    public Aggregator parent() {
        return this.parent;
    }

    public Aggregator[] subAggregators() {
        return this.subAggregators;
    }

    public Aggregator subAggregator(String aggName) {
        if (this.subAggregatorbyName == null) {
            this.subAggregatorbyName = new HashMap<String, Aggregator>(this.subAggregators.length);
            for (int i = 0; i < this.subAggregators.length; ++i) {
                this.subAggregatorbyName.put(this.subAggregators[i].name, this.subAggregators[i]);
            }
        }
        return this.subAggregatorbyName.get(aggName);
    }

    public AggregationContext context() {
        return this.context;
    }

    public BucketAggregationMode bucketAggregationMode() {
        return this.bucketAggregationMode;
    }

    public abstract boolean shouldCollect();

    @Override
    public final void postCollection() throws IOException {
        this.collectableSugAggregators.postCollection();
        this.doPostCollection();
    }

    @Override
    public void close() {
        this.doClose();
    }

    protected void doClose() {
    }

    protected void doPostCollection() throws IOException {
    }

    public abstract InternalAggregation buildAggregation(long var1);

    public abstract InternalAggregation buildEmptyAggregation();

    protected final InternalAggregations buildEmptySubAggregations() {
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        for (Aggregator aggregator : this.subAggregators) {
            aggs.add(aggregator.buildEmptyAggregation());
        }
        return new InternalAggregations(aggs);
    }

    public static interface Parser {
        public String type();

        public AggregatorFactory parse(String var1, XContentParser var2, SearchContext var3) throws IOException;
    }

    public static enum BucketAggregationMode {
        PER_BUCKET,
        MULTI_BUCKETS;

    }
}

