/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.date;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.date.DateRange;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class InternalDateRange
extends InternalRange<Bucket>
implements DateRange {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("date_range", "drange");
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalDateRange readResult(StreamInput in) throws IOException {
            InternalDateRange ranges = new InternalDateRange();
            ranges.readFrom(in);
            return ranges;
        }
    };
    public static final Factory FACTORY = new Factory();

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalDateRange() {
    }

    InternalDateRange(String name, List<Bucket> ranges, @Nullable ValueFormatter formatter, boolean keyed, boolean unmapped) {
        super(name, ranges, formatter, keyed, unmapped);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    protected Bucket createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
        return new Bucket(key, from, to, docCount, aggregations, formatter);
    }

    private static class Factory
    extends InternalRange.Factory<Bucket, InternalDateRange> {
        private Factory() {
        }

        @Override
        public String type() {
            return TYPE.name();
        }

        @Override
        public InternalDateRange create(String name, List<Bucket> ranges, ValueFormatter formatter, boolean keyed, boolean unmapped) {
            return new InternalDateRange(name, ranges, formatter, keyed, unmapped);
        }

        @Override
        public Bucket createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
            return new Bucket(key, from, to, docCount, aggregations, formatter);
        }
    }

    public static class Bucket
    extends InternalRange.Bucket
    implements DateRange.Bucket {
        public Bucket(String key, double from, double to, long docCount, List<InternalAggregation> aggregations, ValueFormatter formatter) {
            super(key, from, to, docCount, new InternalAggregations(aggregations), formatter);
        }

        public Bucket(String key, double from, double to, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
            super(key, from, to, docCount, aggregations, formatter);
        }

        @Override
        public DateTime getFromAsDate() {
            return Double.isInfinite(this.getFrom().doubleValue()) ? null : new DateTime(this.getFrom().longValue(), DateTimeZone.UTC);
        }

        @Override
        public DateTime getToAsDate() {
            return Double.isInfinite(this.getTo().doubleValue()) ? null : new DateTime(this.getTo().longValue(), DateTimeZone.UTC);
        }
    }
}

