/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.cardinality;

import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregator;
import org.elasticsearch.search.aggregations.metrics.cardinality.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.cardinality.InternalCardinality;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

final class CardinalityAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource> {
    private final long precisionThreshold;
    private final boolean rehash;

    CardinalityAggregatorFactory(String name, ValuesSourceConfig config, long precisionThreshold, boolean rehash) {
        super(name, InternalCardinality.TYPE.name(), config);
        this.precisionThreshold = precisionThreshold;
        this.rehash = rehash;
    }

    private int precision(Aggregator parent) {
        return this.precisionThreshold < 0L ? this.defaultPrecision(parent) : HyperLogLogPlusPlus.precisionFromThreshold(this.precisionThreshold);
    }

    @Override
    protected Aggregator createUnmapped(AggregationContext context, Aggregator parent) {
        return new CardinalityAggregator(this.name, parent == null ? 1L : parent.estimatedBucketCount(), null, true, this.precision(parent), context, parent);
    }

    @Override
    protected Aggregator create(ValuesSource valuesSource, long expectedBucketsCount, AggregationContext context, Aggregator parent) {
        if (!(valuesSource instanceof ValuesSource.Numeric) && !this.rehash) {
            throw new AggregationExecutionException("Turning off rehashing for cardinality aggregation [" + this.name + "] on non-numeric values in not allowed");
        }
        return new CardinalityAggregator(this.name, parent == null ? 1L : parent.estimatedBucketCount(), valuesSource, this.rehash, this.precision(parent), context, parent);
    }

    private int defaultPrecision(Aggregator parent) {
        int precision = 14;
        while (parent != null) {
            if (parent.bucketAggregationMode() == Aggregator.BucketAggregationMode.PER_BUCKET) {
                precision -= 5;
            }
            parent = parent.parent();
        }
        return Math.max(precision, 4);
    }
}

