/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalPercentiles
extends MetricsAggregation.MultiValue
implements Percentiles {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentiles");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalPercentiles readResult(StreamInput in) throws IOException {
            InternalPercentiles result = new InternalPercentiles();
            result.readFrom(in);
            return result;
        }
    };
    private double[] percents;
    private TDigestState state;
    private boolean keyed;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalPercentiles() {
    }

    public InternalPercentiles(String name, double[] percents, TDigestState state, boolean keyed) {
        super(name);
        this.percents = percents;
        this.state = state;
        this.keyed = keyed;
    }

    @Override
    public double value(String name) {
        return this.percentile(Double.parseDouble(name));
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public double percentile(double percent) {
        return this.state.quantile(percent / 100.0);
    }

    @Override
    public Iterator<Percentiles.Percentile> iterator() {
        return new Iter(this.percents, this.state);
    }

    @Override
    public InternalPercentiles reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        InternalPercentiles merged = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalPercentiles percentiles = (InternalPercentiles)aggregation;
            if (merged == null) {
                merged = percentiles;
                continue;
            }
            merged.state.add(percentiles.state);
        }
        return merged;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        byte id;
        this.name = in.readString();
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        if (in.getVersion().before(Version.V_1_2_0) && (id = in.readByte()) != 0) {
            throw new ElasticsearchIllegalArgumentException("Unexpected percentiles aggregator id [" + id + "]");
        }
        this.percents = new double[in.readInt()];
        for (int i = 0; i < this.percents.length; ++i) {
            this.percents[i] = in.readDouble();
        }
        this.state = TDigestState.read(in);
        this.keyed = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        if (out.getVersion().before(Version.V_1_2_0)) {
            out.writeByte((byte)0);
        }
        out.writeInt(this.percents.length);
        for (int i = 0; i < this.percents.length; ++i) {
            out.writeDouble(this.percents[i]);
        }
        TDigestState.write(this.state, out);
        out.writeBoolean(this.keyed);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.keyed) {
            builder.startObject(InternalAggregation.CommonFields.VALUES);
            for (int i = 0; i < this.percents.length; ++i) {
                String key = String.valueOf(this.percents[i]);
                double value = this.percentile(this.percents[i]);
                builder.field(key, value);
                if (this.valueFormatter == null) continue;
                builder.field(key + "_as_string", this.valueFormatter.format(value));
            }
            builder.endObject();
        } else {
            builder.startArray(InternalAggregation.CommonFields.VALUES);
            for (int i = 0; i < this.percents.length; ++i) {
                double value = this.percentile(this.percents[i]);
                builder.startObject();
                builder.field(InternalAggregation.CommonFields.KEY, this.percents[i]);
                builder.field(InternalAggregation.CommonFields.VALUE, value);
                if (this.valueFormatter != null) {
                    builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(value));
                }
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    private static class InnerPercentile
    implements Percentiles.Percentile {
        private final double percent;
        private final double value;

        private InnerPercentile(double percent, double value) {
            this.percent = percent;
            this.value = value;
        }

        @Override
        public double getPercent() {
            return this.percent;
        }

        @Override
        public double getValue() {
            return this.value;
        }
    }

    public static class Iter
    extends UnmodifiableIterator<Percentiles.Percentile> {
        private final double[] percents;
        private final TDigestState state;
        private int i;

        public Iter(double[] percents, TDigestState state) {
            this.percents = percents;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.percents.length;
        }

        @Override
        public Percentiles.Percentile next() {
            InnerPercentile next = new InnerPercentile(this.percents[this.i], this.state.quantile(this.percents[this.i] / 100.0));
            ++this.i;
            return next;
        }
    }
}

