/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class PercentilesAggregator
extends MetricsAggregator.MultiValue {
    private final double[] percents;
    private final ValuesSource.Numeric valuesSource;
    private DoubleValues values;
    private ObjectArray<TDigestState> states;
    private final double compression;
    private final boolean keyed;

    private static int indexOfPercent(double[] percents, double percent) {
        return ArrayUtils.binarySearch(percents, percent, 0.001);
    }

    public PercentilesAggregator(String name, long estimatedBucketsCount, ValuesSource.Numeric valuesSource, AggregationContext context, Aggregator parent, double[] percents, double compression, boolean keyed) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        this.keyed = keyed;
        this.states = this.bigArrays.newObjectArray(estimatedBucketsCount);
        this.percents = percents;
        this.compression = compression;
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.doubleValues();
    }

    @Override
    public void collect(int doc, long bucketOrd) throws IOException {
        this.states = this.bigArrays.grow(this.states, bucketOrd + 1L);
        TDigestState state = this.states.get(bucketOrd);
        if (state == null) {
            state = new TDigestState(this.compression);
            this.states.set(bucketOrd, state);
        }
        int valueCount = this.values.setDocument(doc);
        for (int i = 0; i < valueCount; ++i) {
            state.add(this.values.nextValue());
        }
    }

    @Override
    public boolean hasMetric(String name) {
        return PercentilesAggregator.indexOfPercent(this.percents, Double.parseDouble(name)) >= 0;
    }

    private TDigestState getState(long bucketOrd) {
        if (bucketOrd >= this.states.size()) {
            return null;
        }
        TDigestState state = this.states.get(bucketOrd);
        return state;
    }

    @Override
    public double metric(String name, long bucketOrd) {
        TDigestState state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return state.quantile(Double.parseDouble(name) / 100.0);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalPercentiles(this.name, this.percents, state, this.keyed);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalPercentiles(this.name, this.percents, new TDigestState(this.compression), this.keyed);
    }

    @Override
    protected void doClose() {
        Releasables.close(this.states);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        private final double[] percents;
        private final double compression;
        private final boolean keyed;

        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig, double[] percents, double compression, boolean keyed) {
            super(name, InternalPercentiles.TYPE.name(), valuesSourceConfig);
            this.percents = percents;
            this.compression = compression;
            this.keyed = keyed;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new PercentilesAggregator(this.name, 0L, null, aggregationContext, parent, this.percents, this.compression, this.keyed);
        }

        @Override
        protected Aggregator create(ValuesSource.Numeric valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new PercentilesAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent, this.percents, this.compression, this.keyed);
        }
    }
}

