/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.suggest.Suggester;

public class Suggesters {
    private final ImmutableMap<String, Suggester> parsers;

    @Inject
    public Suggesters(Set<Suggester> suggesters) {
        MapBuilder<String, Suggester> builder = MapBuilder.newMapBuilder();
        for (Suggester suggester : suggesters) {
            for (String type : suggester.names()) {
                builder.put(type, suggester);
            }
        }
        this.parsers = builder.immutableMap();
    }

    public Suggester get(String type) {
        return this.parsers.get(type);
    }
}

