/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.MoreExecutors;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPoolInfo;
import org.elasticsearch.threadpool.ThreadPoolStats;

public class ThreadPool
extends AbstractComponent {
    public static final String THREADPOOL_GROUP = "threadpool.";
    private volatile ImmutableMap<String, ExecutorHolder> executors;
    private final ImmutableMap<String, Settings> defaultExecutorTypeSettings;
    private final Queue<ExecutorHolder> retiredExecutors = new ConcurrentLinkedQueue<ExecutorHolder>();
    private final ScheduledThreadPoolExecutor scheduler;
    private final EstimatedTimeThread estimatedTimeThread;

    public ThreadPool() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, (NodeSettingsService)null);
    }

    @Inject
    public ThreadPool(Settings settings, @Nullable NodeSettingsService nodeSettingsService) {
        super(settings);
        Map<String, Settings> groupSettings = settings.getGroups(THREADPOOL_GROUP);
        int availableProcessors = EsExecutors.boundedNumberOfProcessors(settings);
        int halfProcMaxAt5 = Math.min((availableProcessors + 1) / 2, 5);
        int halfProcMaxAt10 = Math.min((availableProcessors + 1) / 2, 10);
        this.defaultExecutorTypeSettings = ImmutableMap.builder().put("generic", ImmutableSettings.settingsBuilder().put("type", "cached").put("keep_alive", "30s").build()).put("index", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors).put("queue_size", 200).build()).put("bulk", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors).put("queue_size", 50).build()).put("get", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors).put("queue_size", 1000).build()).put("search", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors * 3).put("queue_size", 1000).build()).put("suggest", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors).put("queue_size", 1000).build()).put("percolate", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", availableProcessors).put("queue_size", 1000).build()).put("management", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", 5).build()).put("flush", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt5).build()).put("merge", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt5).build()).put("refresh", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt10).build()).put("warmer", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt5).build()).put("snapshot", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt5).build()).put("snapshot_data", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", 5).build()).put("optimize", ImmutableSettings.settingsBuilder().put("type", "fixed").put("size", 1).build()).put("bench", ImmutableSettings.settingsBuilder().put("type", "scaling").put("keep_alive", "5m").put("size", halfProcMaxAt5).build()).build();
        HashMap executors = Maps.newHashMap();
        for (Map.Entry executor : this.defaultExecutorTypeSettings.entrySet()) {
            executors.put(executor.getKey(), this.build((String)executor.getKey(), groupSettings.get(executor.getKey()), (Settings)executor.getValue()));
        }
        executors.put("same", new ExecutorHolder(MoreExecutors.sameThreadExecutor(), new Info("same", "same")));
        if (!((ExecutorHolder)executors.get((Object)"generic")).info.getType().equals("cached")) {
            throw new ElasticsearchIllegalArgumentException("generic thread pool must be of type cached");
        }
        this.executors = ImmutableMap.copyOf(executors);
        this.scheduler = new ScheduledThreadPoolExecutor(1, EsExecutors.daemonThreadFactory(settings, "scheduler"), new EsAbortPolicy());
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        if (nodeSettingsService != null) {
            nodeSettingsService.addListener(new ApplySettings());
        }
        TimeValue estimatedTimeInterval = this.componentSettings.getAsTime("estimated_time_interval", TimeValue.timeValueMillis(200L));
        this.estimatedTimeThread = new EstimatedTimeThread(EsExecutors.threadName(settings, "[timer]"), estimatedTimeInterval.millis());
        this.estimatedTimeThread.start();
    }

    public long estimatedTimeInMillis() {
        return this.estimatedTimeThread.estimatedTimeInMillis();
    }

    public ThreadPoolInfo info() {
        ArrayList<Info> infos = new ArrayList<Info>();
        for (ExecutorHolder holder : this.executors.values()) {
            String name = holder.info.getName();
            if ("same".equals(name)) continue;
            infos.add(holder.info);
        }
        return new ThreadPoolInfo(infos);
    }

    public Info info(String name) {
        ExecutorHolder holder = this.executors.get(name);
        if (holder == null) {
            return null;
        }
        return holder.info;
    }

    public ThreadPoolStats stats() {
        ArrayList<ThreadPoolStats.Stats> stats = new ArrayList<ThreadPoolStats.Stats>();
        for (ExecutorHolder holder : this.executors.values()) {
            String name = holder.info.getName();
            if ("same".equals(name)) continue;
            int threads = -1;
            int queue = -1;
            int active = -1;
            long rejected = -1L;
            int largest = -1;
            long completed = -1L;
            if (holder.executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)holder.executor;
                threads = threadPoolExecutor.getPoolSize();
                queue = threadPoolExecutor.getQueue().size();
                active = threadPoolExecutor.getActiveCount();
                largest = threadPoolExecutor.getLargestPoolSize();
                completed = threadPoolExecutor.getCompletedTaskCount();
                RejectedExecutionHandler rejectedExecutionHandler = threadPoolExecutor.getRejectedExecutionHandler();
                if (rejectedExecutionHandler instanceof XRejectedExecutionHandler) {
                    rejected = ((XRejectedExecutionHandler)rejectedExecutionHandler).rejected();
                }
            }
            stats.add(new ThreadPoolStats.Stats(name, threads, queue, active, rejected, largest, completed));
        }
        return new ThreadPoolStats(stats);
    }

    public Executor generic() {
        return this.executor("generic");
    }

    public Executor executor(String name) {
        Executor executor = this.executors.get((Object)name).executor;
        if (executor == null) {
            throw new ElasticsearchIllegalArgumentException("No executor found for [" + name + "]");
        }
        return executor;
    }

    public ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, TimeValue interval) {
        return this.scheduler.scheduleWithFixedDelay(new LoggingRunnable(command), interval.millis(), interval.millis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(TimeValue delay, String name, Runnable command) {
        if (!"same".equals(name)) {
            command = new ThreadedRunnable(command, this.executor(name));
        }
        return this.scheduler.schedule(command, delay.millis(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.estimatedTimeThread.running = false;
        this.estimatedTimeThread.interrupt();
        this.scheduler.shutdown();
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor.executor).shutdown();
        }
    }

    public void shutdownNow() {
        this.estimatedTimeThread.running = false;
        this.estimatedTimeThread.interrupt();
        this.scheduler.shutdownNow();
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor.executor).shutdownNow();
        }
        while (!this.retiredExecutors.isEmpty()) {
            ((ThreadPoolExecutor)this.retiredExecutors.remove().executor).shutdownNow();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.scheduler.awaitTermination(timeout, unit);
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor instanceof ThreadPoolExecutor)) continue;
            result &= ((ThreadPoolExecutor)executor.executor).awaitTermination(timeout, unit);
        }
        while (!this.retiredExecutors.isEmpty()) {
            result &= ((ThreadPoolExecutor)this.retiredExecutors.remove().executor).awaitTermination(timeout, unit);
        }
        return result;
    }

    private ExecutorHolder build(String name, @Nullable Settings settings, Settings defaultSettings) {
        return this.rebuild(name, null, settings, defaultSettings);
    }

    private ExecutorHolder rebuild(String name, ExecutorHolder previousExecutorHolder, @Nullable Settings settings, Settings defaultSettings) {
        if ("same".equals(name)) {
            return previousExecutorHolder;
        }
        if (settings == null) {
            settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        }
        Info previousInfo = previousExecutorHolder != null ? previousExecutorHolder.info : null;
        String type = settings.get("type", previousInfo != null ? previousInfo.getType() : defaultSettings.get("type"));
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, name);
        if ("same".equals(type)) {
            if (previousExecutorHolder != null) {
                this.logger.debug("updating thread_pool [{}], type [{}]", name, type);
            } else {
                this.logger.debug("creating thread_pool [{}], type [{}]", name, type);
            }
            return new ExecutorHolder(MoreExecutors.sameThreadExecutor(), new Info(name, type));
        }
        if ("cached".equals(type)) {
            TimeValue defaultKeepAlive = defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L));
            if (previousExecutorHolder != null) {
                if ("cached".equals(previousInfo.getType())) {
                    TimeValue updatedKeepAlive = settings.getAsTime("keep_alive", previousInfo.getKeepAlive());
                    if (!previousInfo.getKeepAlive().equals(updatedKeepAlive)) {
                        this.logger.debug("updating thread_pool [{}], type [{}], keep_alive [{}]", name, type, updatedKeepAlive);
                        ((EsThreadPoolExecutor)previousExecutorHolder.executor).setKeepAliveTime(updatedKeepAlive.millis(), TimeUnit.MILLISECONDS);
                        return new ExecutorHolder(previousExecutorHolder.executor, new Info(name, type, -1, -1, updatedKeepAlive, null));
                    }
                    return previousExecutorHolder;
                }
                if (previousInfo.getKeepAlive() != null) {
                    defaultKeepAlive = previousInfo.getKeepAlive();
                }
            }
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultKeepAlive);
            if (previousExecutorHolder != null) {
                this.logger.debug("updating thread_pool [{}], type [{}], keep_alive [{}]", name, type, keepAlive);
            } else {
                this.logger.debug("creating thread_pool [{}], type [{}], keep_alive [{}]", name, type, keepAlive);
            }
            EsThreadPoolExecutor executor = EsExecutors.newCached(keepAlive.millis(), TimeUnit.MILLISECONDS, threadFactory);
            return new ExecutorHolder(executor, new Info(name, type, -1, -1, keepAlive, null));
        }
        if ("fixed".equals(type)) {
            int defaultSize = defaultSettings.getAsInt("size", (Integer)EsExecutors.boundedNumberOfProcessors(settings));
            SizeValue defaultQueueSize = defaultSettings.getAsSize("queue", defaultSettings.getAsSize("queue_size", null));
            if (previousExecutorHolder != null) {
                if ("fixed".equals(previousInfo.getType())) {
                    SizeValue updatedQueueSize = settings.getAsSize("capacity", settings.getAsSize("queue", settings.getAsSize("queue_size", previousInfo.getQueueSize())));
                    if (Objects.equal(previousInfo.getQueueSize(), updatedQueueSize)) {
                        int updatedSize = settings.getAsInt("size", (Integer)previousInfo.getMax());
                        if (previousInfo.getMax() != updatedSize) {
                            this.logger.debug("updating thread_pool [{}], type [{}], size [{}], queue_size [{}]", name, type, updatedSize, updatedQueueSize);
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setCorePoolSize(updatedSize);
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setMaximumPoolSize(updatedSize);
                            return new ExecutorHolder(previousExecutorHolder.executor, new Info(name, type, updatedSize, updatedSize, null, updatedQueueSize));
                        }
                        return previousExecutorHolder;
                    }
                }
                if (previousInfo.getMax() >= 0) {
                    defaultSize = previousInfo.getMax();
                }
                defaultQueueSize = previousInfo.getQueueSize();
            }
            int size = settings.getAsInt("size", (Integer)defaultSize);
            SizeValue queueSize = settings.getAsSize("capacity", settings.getAsSize("queue", settings.getAsSize("queue_size", defaultQueueSize)));
            this.logger.debug("creating thread_pool [{}], type [{}], size [{}], queue_size [{}]", name, type, size, queueSize);
            EsThreadPoolExecutor executor = EsExecutors.newFixed(size, queueSize == null ? -1 : (int)queueSize.singles(), threadFactory);
            return new ExecutorHolder(executor, new Info(name, type, size, size, null, queueSize));
        }
        if ("scaling".equals(type)) {
            TimeValue defaultKeepAlive = defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L));
            int defaultMin = defaultSettings.getAsInt("min", (Integer)1);
            int defaultSize = defaultSettings.getAsInt("size", (Integer)EsExecutors.boundedNumberOfProcessors(settings));
            if (previousExecutorHolder != null) {
                if ("scaling".equals(previousInfo.getType())) {
                    TimeValue updatedKeepAlive = settings.getAsTime("keep_alive", previousInfo.getKeepAlive());
                    int updatedMin = settings.getAsInt("min", (Integer)previousInfo.getMin());
                    int updatedSize = settings.getAsInt("max", settings.getAsInt("size", (Integer)previousInfo.getMax()));
                    if (!previousInfo.getKeepAlive().equals(updatedKeepAlive) || previousInfo.getMin() != updatedMin || previousInfo.getMax() != updatedSize) {
                        this.logger.debug("updating thread_pool [{}], type [{}], keep_alive [{}]", name, type, updatedKeepAlive);
                        if (!previousInfo.getKeepAlive().equals(updatedKeepAlive)) {
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setKeepAliveTime(updatedKeepAlive.millis(), TimeUnit.MILLISECONDS);
                        }
                        if (previousInfo.getMin() != updatedMin) {
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setCorePoolSize(updatedMin);
                        }
                        if (previousInfo.getMax() != updatedSize) {
                            ((EsThreadPoolExecutor)previousExecutorHolder.executor).setMaximumPoolSize(updatedSize);
                        }
                        return new ExecutorHolder(previousExecutorHolder.executor, new Info(name, type, updatedMin, updatedSize, updatedKeepAlive, null));
                    }
                    return previousExecutorHolder;
                }
                if (previousInfo.getKeepAlive() != null) {
                    defaultKeepAlive = previousInfo.getKeepAlive();
                }
                if (previousInfo.getMin() >= 0) {
                    defaultMin = previousInfo.getMin();
                }
                if (previousInfo.getMax() >= 0) {
                    defaultSize = previousInfo.getMax();
                }
            }
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultKeepAlive);
            int min = settings.getAsInt("min", (Integer)defaultMin);
            int size = settings.getAsInt("max", settings.getAsInt("size", (Integer)defaultSize));
            if (previousExecutorHolder != null) {
                this.logger.debug("updating thread_pool [{}], type [{}], min [{}], size [{}], keep_alive [{}]", name, type, min, size, keepAlive);
            } else {
                this.logger.debug("creating thread_pool [{}], type [{}], min [{}], size [{}], keep_alive [{}]", name, type, min, size, keepAlive);
            }
            EsThreadPoolExecutor executor = EsExecutors.newScaling(min, size, keepAlive.millis(), TimeUnit.MILLISECONDS, threadFactory);
            return new ExecutorHolder(executor, new Info(name, type, min, size, keepAlive, null));
        }
        throw new ElasticsearchIllegalArgumentException("No type found [" + type + "], for [" + name + "]");
    }

    public void updateSettings(Settings settings) {
        Map<String, Settings> groupSettings = settings.getGroups("threadpool");
        if (groupSettings.isEmpty()) {
            return;
        }
        for (Map.Entry executor : this.defaultExecutorTypeSettings.entrySet()) {
            ExecutorHolder newExecutorHolder;
            ExecutorHolder oldExecutorHolder;
            Settings updatedSettings = groupSettings.get(executor.getKey());
            if (updatedSettings == null || (oldExecutorHolder = this.executors.get(executor.getKey())).equals(newExecutorHolder = this.rebuild((String)executor.getKey(), oldExecutorHolder, updatedSettings, (Settings)executor.getValue()))) continue;
            this.executors = MapBuilder.newMapBuilder(this.executors).put((String)executor.getKey(), newExecutorHolder).immutableMap();
            if (oldExecutorHolder.executor.equals(newExecutorHolder.executor) || !(oldExecutorHolder.executor instanceof EsThreadPoolExecutor)) continue;
            this.retiredExecutors.add(oldExecutorHolder);
            ((EsThreadPoolExecutor)oldExecutorHolder.executor).shutdown(new ExecutorShutdownListener(oldExecutorHolder));
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            ThreadPool.this.updateSettings(settings);
        }
    }

    public static class Info
    implements Streamable,
    ToXContent {
        private String name;
        private String type;
        private int min;
        private int max;
        private TimeValue keepAlive;
        private SizeValue queueSize;

        Info() {
        }

        public Info(String name, String type) {
            this(name, type, -1);
        }

        public Info(String name, String type, int size) {
            this(name, type, size, size, null, null);
        }

        public Info(String name, String type, int min, int max, @Nullable TimeValue keepAlive, @Nullable SizeValue queueSize) {
            this.name = name;
            this.type = type;
            this.min = min;
            this.max = max;
            this.keepAlive = keepAlive;
            this.queueSize = queueSize;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        @Nullable
        public TimeValue getKeepAlive() {
            return this.keepAlive;
        }

        @Nullable
        public SizeValue getQueueSize() {
            return this.queueSize;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.type = in.readString();
            this.min = in.readInt();
            this.max = in.readInt();
            if (in.readBoolean()) {
                this.keepAlive = TimeValue.readTimeValue(in);
            }
            if (in.readBoolean()) {
                this.queueSize = SizeValue.readSizeValue(in);
            }
            in.readBoolean();
            in.readBoolean();
            in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeString(this.type);
            out.writeInt(this.min);
            out.writeInt(this.max);
            if (this.keepAlive == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.keepAlive.writeTo(out);
            }
            if (this.queueSize == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.queueSize.writeTo(out);
            }
            out.writeBoolean(false);
            out.writeBoolean(false);
            out.writeBoolean(false);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name, XContentBuilder.FieldCaseConversion.NONE);
            builder.field(Fields.TYPE, this.type);
            if (this.min != -1) {
                builder.field(Fields.MIN, this.min);
            }
            if (this.max != -1) {
                builder.field(Fields.MAX, this.max);
            }
            if (this.keepAlive != null) {
                builder.field(Fields.KEEP_ALIVE, this.keepAlive.toString());
            }
            if (this.queueSize != null) {
                builder.field(Fields.QUEUE_SIZE, this.queueSize.toString());
            }
            builder.endObject();
            return builder;
        }

        static final class Fields {
            static final XContentBuilderString TYPE = new XContentBuilderString("type");
            static final XContentBuilderString MIN = new XContentBuilderString("min");
            static final XContentBuilderString MAX = new XContentBuilderString("max");
            static final XContentBuilderString KEEP_ALIVE = new XContentBuilderString("keep_alive");
            static final XContentBuilderString QUEUE_SIZE = new XContentBuilderString("queue_size");

            Fields() {
            }
        }
    }

    static class ExecutorHolder {
        public final Executor executor;
        public final Info info;

        ExecutorHolder(Executor executor, Info info) {
            this.executor = executor;
            this.info = info;
        }
    }

    static class EstimatedTimeThread
    extends Thread {
        final long interval;
        volatile boolean running = true;
        volatile long estimatedTimeInMillis;

        EstimatedTimeThread(String name, long interval) {
            super(name);
            this.interval = interval;
            this.estimatedTimeInMillis = System.currentTimeMillis();
            this.setDaemon(true);
        }

        public long estimatedTimeInMillis() {
            return this.estimatedTimeInMillis;
        }

        @Override
        public void run() {
            while (this.running) {
                this.estimatedTimeInMillis = System.currentTimeMillis();
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    this.running = false;
                    return;
                }
            }
        }
    }

    class ThreadedRunnable
    implements Runnable {
        private final Runnable runnable;
        private final Executor executor;

        ThreadedRunnable(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        @Override
        public void run() {
            this.executor.execute(this.runnable);
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }

    class LoggingRunnable
    implements Runnable {
        private final Runnable runnable;

        LoggingRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                ThreadPool.this.logger.warn("failed to run {}", e, this.runnable.toString());
            }
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }

    class ExecutorShutdownListener
    implements EsThreadPoolExecutor.ShutdownListener {
        private ExecutorHolder holder;

        public ExecutorShutdownListener(ExecutorHolder holder) {
            this.holder = holder;
        }

        @Override
        public void onTerminated() {
            ThreadPool.this.retiredExecutors.remove(this.holder);
        }
    }

    public static class Names {
        public static final String SAME = "same";
        public static final String GENERIC = "generic";
        public static final String GET = "get";
        public static final String INDEX = "index";
        public static final String BULK = "bulk";
        public static final String SEARCH = "search";
        public static final String SUGGEST = "suggest";
        public static final String PERCOLATE = "percolate";
        public static final String MANAGEMENT = "management";
        public static final String FLUSH = "flush";
        public static final String MERGE = "merge";
        public static final String REFRESH = "refresh";
        public static final String WARMER = "warmer";
        public static final String SNAPSHOT = "snapshot";
        public static final String SNAPSHOT_DATA = "snapshot_data";
        public static final String OPTIMIZE = "optimize";
        public static final String BENCH = "bench";
    }
}

