/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AnalyzeRequest
extends SingleCustomOperationRequest<AnalyzeRequest> {
    private String text;
    private String analyzer;
    private String tokenizer;
    private String[] tokenFilters = Strings.EMPTY_ARRAY;
    private String[] charFilters = Strings.EMPTY_ARRAY;
    private String field;

    AnalyzeRequest() {
    }

    public AnalyzeRequest(String text) {
        this.text = text;
    }

    public AnalyzeRequest(@Nullable String index, String text) {
        this.index(index);
        this.text = text;
    }

    public String text() {
        return this.text;
    }

    public AnalyzeRequest analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public AnalyzeRequest tokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public String tokenizer() {
        return this.tokenizer;
    }

    public AnalyzeRequest tokenFilters(String ... tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public String[] tokenFilters() {
        return this.tokenFilters;
    }

    public AnalyzeRequest charFilters(String ... charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    public String[] charFilters() {
        return this.charFilters;
    }

    public AnalyzeRequest field(String field) {
        this.field = field;
        return this;
    }

    public String field() {
        return this.field;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.text == null) {
            validationException = ValidateActions.addValidationError("text is missing", validationException);
        }
        if (this.tokenFilters == null) {
            validationException = ValidateActions.addValidationError("token filters must not be null", validationException);
        }
        if (this.charFilters == null) {
            validationException = ValidateActions.addValidationError("char filters must not be null", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.text = in.readString();
        this.analyzer = in.readOptionalString();
        this.tokenizer = in.readOptionalString();
        this.tokenFilters = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_1_1_0)) {
            this.charFilters = in.readStringArray();
        }
        this.field = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.text);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalString(this.tokenizer);
        out.writeStringArray(this.tokenFilters);
        if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
            out.writeStringArray(this.charFilters);
        }
        out.writeOptionalString(this.field);
    }
}

