/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UpgradeResponse
extends BroadcastOperationResponse {
    private Map<String, String> versions;

    UpgradeResponse() {
    }

    UpgradeResponse(Map<String, String> versions, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.versions = versions;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.versions = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            String version = in.readString();
            this.versions.put(index, version);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.versions.size());
        for (Map.Entry<String, String> entry : this.versions.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
    }

    public Map<String, String> versions() {
        return this.versions;
    }
}

