/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.NoSuchNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationRequest;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.NodeShouldNotConnectException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.TransportService;

public abstract class TransportNodesOperationAction<Request extends NodesOperationRequest, Response extends NodesOperationResponse, NodeRequest extends NodeOperationRequest, NodeResponse extends NodeOperationResponse>
extends TransportAction<Request, Response> {
    protected final ClusterName clusterName;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportNodeAction;
    final String executor;

    protected TransportNodesOperationAction(Settings settings, String actionName, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, actionName, threadPool, actionFilters);
        this.clusterName = clusterName;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportNodeAction = actionName + "[n]";
        this.executor = this.executor();
        transportService.registerHandler(actionName, new TransportHandler());
        transportService.registerHandler(this.transportNodeAction, new NodeTransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncAction(this, (NodesOperationRequest)request, listener).start();
    }

    protected boolean transportCompress() {
        return false;
    }

    protected abstract String executor();

    protected abstract Request newRequest();

    protected abstract Response newResponse(Request var1, AtomicReferenceArray var2);

    protected abstract NodeRequest newNodeRequest();

    protected abstract NodeRequest newNodeRequest(String var1, Request var2);

    protected abstract NodeResponse newNodeResponse();

    protected abstract NodeResponse nodeOperation(NodeRequest var1) throws ElasticsearchException;

    protected abstract boolean accumulateExceptions();

    protected String[] filterNodeIds(DiscoveryNodes nodes, String[] nodesIds) {
        return nodesIds;
    }

    protected String[] resolveNodes(Request request, ClusterState clusterState) {
        return clusterState.nodes().resolveNodesIds(((NodesOperationRequest)request).nodesIds());
    }

    private class NodeTransportHandler
    extends BaseTransportRequestHandler<NodeRequest> {
        private NodeTransportHandler() {
        }

        @Override
        public NodeRequest newInstance() {
            return TransportNodesOperationAction.this.newNodeRequest();
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse((TransportResponse)TransportNodesOperationAction.this.nodeOperation(request));
        }

        public String toString() {
            return TransportNodesOperationAction.this.transportNodeAction;
        }

        @Override
        public String executor() {
            return TransportNodesOperationAction.this.executor;
        }
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportNodesOperationAction.this.newRequest();
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            TransportNodesOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    TransportResponseOptions options = TransportResponseOptions.options().withCompress(TransportNodesOperationAction.this.transportCompress());
                    try {
                        channel.sendResponse((TransportResponse)response, options);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportNodesOperationAction.this.logger.warn("Failed to send response", e, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }

        public String toString() {
            return TransportNodesOperationAction.this.actionName;
        }
    }

    private static class AsyncAction {
        private final Request request;
        private final String[] nodesIds;
        private final ActionListener<Response> listener;
        private final ClusterState clusterState;
        private final AtomicReferenceArray<Object> responses;
        private final AtomicInteger counter = new AtomicInteger();
        final /* synthetic */ TransportNodesOperationAction this$0;

        private AsyncAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
            this.clusterState = var1_1.clusterService.state();
            String[] nodesIds = var1_1.resolveNodes(request, this.clusterState);
            this.nodesIds = var1_1.filterNodeIds(this.clusterState.nodes(), nodesIds);
            this.responses = new AtomicReferenceArray(this.nodesIds.length);
        }

        private void start() {
            if (this.nodesIds.length == 0) {
                this.this$0.threadPool.generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        AsyncAction.this.listener.onResponse(AsyncAction.this.this$0.newResponse(AsyncAction.this.request, AsyncAction.this.responses));
                    }
                });
                return;
            }
            TransportRequestOptions transportRequestOptions = TransportRequestOptions.options();
            if (((NodesOperationRequest)this.request).timeout() != null) {
                transportRequestOptions.withTimeout(((NodesOperationRequest)this.request).timeout());
            }
            transportRequestOptions.withCompress(this.this$0.transportCompress());
            for (int i = 0; i < this.nodesIds.length; ++i) {
                String nodeId = this.nodesIds[i];
                final int idx = i;
                final DiscoveryNode node = this.clusterState.nodes().nodes().get(nodeId);
                try {
                    if (nodeId.equals("_local") || nodeId.equals(this.clusterState.nodes().localNodeId())) {
                        this.this$0.threadPool.executor(this.this$0.executor()).execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AsyncAction.this.onOperation(idx, AsyncAction.this.this$0.nodeOperation(AsyncAction.this.this$0.newNodeRequest(AsyncAction.this.clusterState.nodes().localNodeId(), AsyncAction.this.request)));
                                }
                                catch (Throwable e) {
                                    AsyncAction.this.onFailure(idx, AsyncAction.this.clusterState.nodes().localNodeId(), e);
                                }
                            }
                        });
                        continue;
                    }
                    if (nodeId.equals("_master")) {
                        this.this$0.threadPool.executor(this.this$0.executor()).execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AsyncAction.this.onOperation(idx, AsyncAction.this.this$0.nodeOperation(AsyncAction.this.this$0.newNodeRequest(AsyncAction.this.clusterState.nodes().masterNodeId(), AsyncAction.this.request)));
                                }
                                catch (Throwable e) {
                                    AsyncAction.this.onFailure(idx, AsyncAction.this.clusterState.nodes().masterNodeId(), e);
                                }
                            }
                        });
                        continue;
                    }
                    if (node == null) {
                        this.onFailure(idx, nodeId, new NoSuchNodeException(nodeId));
                        continue;
                    }
                    if (!this.this$0.clusterService.localNode().shouldConnectTo(node)) {
                        this.onFailure(idx, nodeId, new NodeShouldNotConnectException(this.this$0.clusterService.localNode(), node));
                        continue;
                    }
                    Object nodeRequest = this.this$0.newNodeRequest(nodeId, this.request);
                    this.this$0.transportService.sendRequest(node, this.this$0.transportNodeAction, (TransportRequest)nodeRequest, transportRequestOptions, new BaseTransportResponseHandler<NodeResponse>(){

                        @Override
                        public NodeResponse newInstance() {
                            return AsyncAction.this.this$0.newNodeResponse();
                        }

                        @Override
                        public void handleResponse(NodeResponse response) {
                            AsyncAction.this.onOperation(idx, response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            AsyncAction.this.onFailure(idx, node.id(), exp);
                        }

                        @Override
                        public String executor() {
                            return "same";
                        }
                    });
                    continue;
                }
                catch (Throwable t) {
                    this.onFailure(idx, nodeId, t);
                }
            }
        }

        private void onOperation(int idx, NodeResponse nodeResponse) {
            this.responses.set(idx, nodeResponse);
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void onFailure(int idx, String nodeId, Throwable t) {
            if (this.this$0.logger.isDebugEnabled() && !(t instanceof NodeShouldNotConnectException)) {
                this.this$0.logger.debug("failed to execute on node [{}]", t, nodeId);
            }
            if (this.this$0.accumulateExceptions()) {
                this.responses.set(idx, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t));
            }
            if (this.counter.incrementAndGet() == this.responses.length()) {
                this.finishHim();
            }
        }

        private void finishHim() {
            Object finalResponse;
            try {
                finalResponse = this.this$0.newResponse(this.request, this.responses);
            }
            catch (Throwable t) {
                this.this$0.logger.debug("failed to combine responses from nodes", t, new Object[0]);
                this.listener.onFailure(t);
                return;
            }
            this.listener.onResponse(finalResponse);
        }
    }
}

