/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.Version;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.recovery.RecoverySettings;

public class NodeVersionAllocationDecider
extends AllocationDecider {
    public static final String NAME = "node_version";
    private final RecoverySettings recoverySettings;

    @Inject
    public NodeVersionAllocationDecider(Settings settings, RecoverySettings recoverySettings) {
        super(settings);
        this.recoverySettings = recoverySettings;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        String sourceNodeId = shardRouting.currentNodeId();
        if (sourceNodeId == null) {
            if (shardRouting.primary()) {
                return allocation.decision(Decision.YES, NAME, "primary shard can be allocated anywhere", new Object[0]);
            }
            MutableShardRouting primary = allocation.routingNodes().activePrimary(shardRouting);
            if (primary == null) {
                return allocation.decision(Decision.YES, NAME, "no active primary shard yet", new Object[0]);
            }
            sourceNodeId = primary.currentNodeId();
        }
        return this.isVersionCompatible(allocation.routingNodes(), sourceNodeId, node, allocation);
    }

    private Decision isVersionCompatible(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (source.node().version().before(Version.V_1_3_2) && this.recoverySettings.compress()) {
            return allocation.decision(Decision.NO, NAME, "source node version [%s] is prone to corruption bugs with %s = true see issue #7210 for details", source.node().version(), "indices.recovery.compress");
        }
        if (target.node().version().onOrAfter(source.node().version())) {
            return allocation.decision(Decision.YES, NAME, "target node version [%s] is same or newer than source node version [%s]", target.node().version(), source.node().version());
        }
        return allocation.decision(Decision.NO, NAME, "target node version [%s] is older than source node version [%s]", target.node().version(), source.node().version());
    }
}

