/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cli;

import java.util.Collection;
import org.elasticsearch.common.cli.CliTool;
import org.elasticsearch.common.cli.HelpPrinter;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.cli.commons.Option;
import org.elasticsearch.common.cli.commons.OptionGroup;
import org.elasticsearch.common.cli.commons.Options;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;

public class CliToolConfig {
    private final Class<? extends CliTool> toolType;
    private final String name;
    private final ImmutableMap<String, Cmd> cmds;
    private static final HelpPrinter helpPrinter = new HelpPrinter();

    public static Builder config(String name, Class<? extends CliTool> toolType) {
        return new Builder(name, toolType);
    }

    private CliToolConfig(String name, Class<? extends CliTool> toolType, Cmd[] cmds) {
        this.name = name;
        this.toolType = toolType;
        ImmutableMap.Builder<String, Cmd> cmdsBuilder = ImmutableMap.builder();
        for (int i = 0; i < cmds.length; ++i) {
            cmdsBuilder.put(cmds[i].name, cmds[i]);
        }
        this.cmds = cmdsBuilder.build();
    }

    public boolean isSingle() {
        return this.cmds.size() == 1;
    }

    public Cmd single() {
        assert (this.isSingle()) : "Requesting single command on a multi-command tool";
        return (Cmd)((ImmutableCollection)this.cmds.values()).iterator().next();
    }

    public Class<? extends CliTool> toolType() {
        return this.toolType;
    }

    public String name() {
        return this.name;
    }

    public Collection<Cmd> cmds() {
        return this.cmds.values();
    }

    public Cmd cmd(String name) {
        return this.cmds.get(name);
    }

    public void printUsage(Terminal terminal) {
        helpPrinter.print(this, terminal);
    }

    static abstract class OptionsSource {
        static final OptionsSource HELP = new OptionsSource(){

            @Override
            void populate(Options options) {
                options.addOption(new OptionBuilder("h", "help").required(false).build());
            }
        };
        static final OptionsSource VERBOSITY = new OptionsSource(){

            @Override
            void populate(Options options) {
                OptionGroup verbosityGroup = new OptionGroup();
                verbosityGroup.setRequired(false);
                verbosityGroup.addOption(new OptionBuilder("s", "silent").required(false).build());
                verbosityGroup.addOption(new OptionBuilder("v", "verbose").required(false).build());
                options.addOptionGroup(verbosityGroup);
            }
        };
        private Options options;

        OptionsSource() {
        }

        Options options() {
            if (this.options == null) {
                this.options = new Options();
                this.populate(this.options);
            }
            return this.options;
        }

        abstract void populate(Options var1);
    }

    public static class OptionGroupBuilder {
        private OptionGroup group = new OptionGroup();

        private OptionGroupBuilder(boolean required) {
            this.group.setRequired(required);
        }

        public OptionGroupBuilder options(OptionBuilder ... optionBuilders) {
            for (OptionBuilder builder : optionBuilders) {
                this.group.addOption(builder.build());
            }
            return this;
        }

        public OptionGroup build() {
            return this.group;
        }
    }

    public static class OptionBuilder {
        private final Option option;

        private OptionBuilder(String shortName, String longName) {
            this.option = new Option(shortName, "");
            this.option.setLongOpt(longName);
            this.option.setArgName(longName);
        }

        public OptionBuilder required(boolean required) {
            this.option.setRequired(required);
            return this;
        }

        public OptionBuilder hasArg(boolean optional) {
            this.option.setOptionalArg(optional);
            this.option.setArgs(1);
            return this;
        }

        public Option build() {
            return this.option;
        }
    }

    public static class Cmd {
        private String toolName;
        private final String name;
        private final Class<? extends CliTool.Command> cmdType;
        private final Options options;

        private Cmd(String name, Class<? extends CliTool.Command> cmdType, Options options) {
            this.name = name;
            this.cmdType = cmdType;
            this.options = options;
            OptionsSource.VERBOSITY.populate(options);
        }

        public Class<? extends CliTool.Command> cmdType() {
            return this.cmdType;
        }

        public String name() {
            return this.name;
        }

        public Options options() {
            Options copy = new Options();
            for (Object oOption : this.options.getOptions()) {
                Option option = (Option)oOption;
                copy.addOption(option);
            }
            OptionsSource.VERBOSITY.populate(copy);
            return copy;
        }

        public void printUsage(Terminal terminal) {
            helpPrinter.print(this.toolName, this, terminal);
        }

        public static class Builder {
            private final String name;
            private final Class<? extends CliTool.Command> cmdType;
            private Options options = new Options();

            private Builder(String name, Class<? extends CliTool.Command> cmdType) {
                this.name = name;
                this.cmdType = cmdType;
            }

            public Builder options(OptionBuilder ... optionBuilder) {
                for (int i = 0; i < optionBuilder.length; ++i) {
                    this.options.addOption(optionBuilder[i].build());
                }
                return this;
            }

            public Builder optionGroups(OptionGroupBuilder ... optionGroupBuilders) {
                for (OptionGroupBuilder builder : optionGroupBuilders) {
                    this.options.addOptionGroup(builder.build());
                }
                return this;
            }

            public Cmd build() {
                return new Cmd(this.name, this.cmdType, this.options);
            }
        }
    }

    public static class Builder {
        private final Class<? extends CliTool> toolType;
        private final String name;
        private Cmd[] cmds;

        public static Cmd.Builder cmd(String name, Class<? extends CliTool.Command> cmdType) {
            return new Cmd.Builder(name, cmdType);
        }

        public static OptionBuilder option(String shortName, String longName) {
            return new OptionBuilder(shortName, longName);
        }

        public static OptionGroupBuilder optionGroup(boolean required) {
            return new OptionGroupBuilder(required);
        }

        private Builder(String name, Class<? extends CliTool> toolType) {
            this.name = name;
            this.toolType = toolType;
        }

        public Builder cmds(Cmd.Builder ... cmds) {
            this.cmds = new Cmd[cmds.length];
            for (int i = 0; i < cmds.length; ++i) {
                this.cmds[i] = cmds[i].build();
                this.cmds[i].toolName = this.name;
            }
            return this;
        }

        public Builder cmds(Cmd ... cmds) {
            for (int i = 0; i < cmds.length; ++i) {
                cmds[i].toolName = this.name;
            }
            this.cmds = cmds;
            return this;
        }

        public CliToolConfig build() {
            return new CliToolConfig(this.name, this.toolType, this.cmds);
        }
    }
}

