/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway;

import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.gateway.IgnoreGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotAndRestoreService;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexShardGatewayService
extends AbstractIndexShardComponent
implements CloseableIndexComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndexShard indexShard;
    private final IndexShardGateway shardGateway;
    private final IndexShardSnapshotAndRestoreService snapshotService;

    @Inject
    public IndexShardGatewayService(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexShard indexShard, IndexShardGateway shardGateway, IndexShardSnapshotAndRestoreService snapshotService, ClusterService clusterService) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.indexShard = indexShard;
        this.shardGateway = shardGateway;
        this.snapshotService = snapshotService;
        this.clusterService = clusterService;
    }

    public void routingStateChanged() {
    }

    public void recover(final boolean indexShouldExists, final RecoveryListener listener) throws IndexShardGatewayRecoveryException, IgnoreGatewayRecoveryException {
        if (this.indexShard.state() == IndexShardState.CLOSED) {
            listener.onIgnoreRecovery("shard closed");
            return;
        }
        if (!this.indexShard.routingEntry().primary()) {
            listener.onRecoveryFailed(new IndexShardGatewayRecoveryException(this.shardId, "Trying to recover when the shard is in backup state", null));
            return;
        }
        try {
            if (this.indexShard.routingEntry().restoreSource() != null) {
                this.indexShard.recovering("from snapshot", RecoveryState.Type.SNAPSHOT, this.indexShard.routingEntry().restoreSource());
            } else {
                this.indexShard.recovering("from gateway", RecoveryState.Type.GATEWAY, this.clusterService.localNode());
            }
        }
        catch (IllegalIndexShardStateException e) {
            listener.onIgnoreRecovery("already in recovering process, " + e.getMessage());
            return;
        }
        this.threadPool.generic().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    RecoveryState recoveryState = IndexShardGatewayService.this.indexShard.recoveryState();
                    if (IndexShardGatewayService.this.indexShard.routingEntry().restoreSource() != null) {
                        IndexShardGatewayService.this.logger.debug("restoring from {} ...", IndexShardGatewayService.this.indexShard.routingEntry().restoreSource());
                        IndexShardGatewayService.this.snapshotService.restore(recoveryState);
                    } else {
                        IndexShardGatewayService.this.logger.debug("starting recovery from {} ...", IndexShardGatewayService.this.shardGateway);
                        IndexShardGatewayService.this.shardGateway.recover(indexShouldExists, recoveryState);
                    }
                    IndexShardState shardState = IndexShardGatewayService.this.indexShard.state();
                    assert (shardState != IndexShardState.CREATED && shardState != IndexShardState.RECOVERING) : "recovery process of " + IndexShardGatewayService.access$500(IndexShardGatewayService.this) + " didn't get to post_recovery. shardState [" + (Object)((Object)shardState) + "]";
                    if (IndexShardGatewayService.this.logger.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("recovery completed from ").append(IndexShardGatewayService.this.shardGateway).append(", took [").append(TimeValue.timeValueMillis(recoveryState.getTimer().time())).append("]\n");
                        RecoveryState.Index index = recoveryState.getIndex();
                        sb.append("    index    : files           [").append(index.totalFileCount()).append("] with total_size [").append(new ByteSizeValue(index.totalBytes())).append("], took[").append(TimeValue.timeValueMillis(index.time())).append("]\n");
                        sb.append("             : recovered_files [").append(index.recoveredFileCount()).append("] with total_size [").append(new ByteSizeValue(index.recoveredBytes())).append("]\n");
                        sb.append("             : reusing_files   [").append(index.reusedFileCount()).append("] with total_size [").append(new ByteSizeValue(index.reusedBytes())).append("]\n");
                        sb.append("    start    : took [").append(TimeValue.timeValueMillis(recoveryState.getStart().time())).append("], check_index [").append(TimeValue.timeValueMillis(recoveryState.getStart().checkIndexTime())).append("]\n");
                        sb.append("    translog : number_of_operations [").append(recoveryState.getTranslog().recoveredOperations()).append("], took [").append(TimeValue.timeValueMillis(recoveryState.getTranslog().time())).append("]");
                        IndexShardGatewayService.this.logger.trace(sb.toString(), new Object[0]);
                    } else if (IndexShardGatewayService.this.logger.isDebugEnabled()) {
                        IndexShardGatewayService.this.logger.debug("recovery completed from [{}], took [{}]", IndexShardGatewayService.this.shardGateway, TimeValue.timeValueMillis(recoveryState.getTimer().time()));
                    }
                    listener.onRecoveryDone();
                }
                catch (IndexShardGatewayRecoveryException e) {
                    if (IndexShardGatewayService.this.indexShard.state() == IndexShardState.CLOSED) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    if (e.getCause() instanceof IndexShardClosedException || e.getCause() instanceof IndexShardNotStartedException) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    listener.onRecoveryFailed(e);
                }
                catch (IndexShardClosedException e) {
                    listener.onIgnoreRecovery("shard closed");
                }
                catch (IndexShardNotStartedException e) {
                    listener.onIgnoreRecovery("shard closed");
                }
                catch (Exception e) {
                    if (IndexShardGatewayService.this.indexShard.state() == IndexShardState.CLOSED) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    listener.onRecoveryFailed(new IndexShardGatewayRecoveryException(IndexShardGatewayService.this.shardId, "failed recovery", (Throwable)e));
                }
            }
        });
    }

    @Override
    public synchronized void close() {
        this.shardGateway.close();
    }

    static /* synthetic */ ShardId access$500(IndexShardGatewayService x0) {
        return x0.shardId;
    }

    public static interface RecoveryListener {
        public void onRecoveryDone();

        public void onIgnoreRecovery(String var1);

        public void onRecoveryFailed(IndexShardGatewayRecoveryException var1);
    }
}

