/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.hppc.FloatArrayList;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.FilteredCollector;
import org.elasticsearch.common.lucene.search.XCollector;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.facet.nested.NestedFacetExecutor;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlightPhase;

abstract class QueryCollector
extends Collector {
    final IndexFieldData<?> idFieldData;
    final IndexSearcher searcher;
    final ConcurrentMap<BytesRef, Query> queries;
    final ESLogger logger;
    boolean isNestedDoc = false;
    final Lucene.EarlyTerminatingCollector collector = Lucene.createExistsCollector();
    BytesRef current;
    SortedBinaryDocValues values;
    final List<Collector> facetAndAggregatorCollector;

    QueryCollector(ESLogger logger, PercolateContext context, boolean isNestedDoc) {
        this.logger = logger;
        this.queries = context.percolateQueries();
        this.searcher = context.docSearcher();
        FieldMapper idMapper = context.mapperService().smartNameFieldMapper("_id");
        this.idFieldData = context.fieldData().getForField(idMapper);
        this.isNestedDoc = isNestedDoc;
        ImmutableList.Builder facetAggCollectorBuilder = ImmutableList.builder();
        if (context.facets() != null) {
            for (SearchContextFacets.Entry entry : context.facets().entries()) {
                if (entry.isGlobal()) continue;
                XCollector collector = entry.getFacetExecutor().collector();
                if (entry.getFilter() != null) {
                    collector = collector instanceof NestedFacetExecutor.Collector ? new NestedFacetExecutor.Collector((NestedFacetExecutor.Collector)collector, entry.getFilter()) : new FilteredCollector(collector, entry.getFilter());
                }
                facetAggCollectorBuilder.add((Object)collector);
            }
        }
        if (context.aggregations() != null) {
            AggregationContext aggregationContext = new AggregationContext(context);
            context.aggregations().aggregationContext(aggregationContext);
            ArrayList<Aggregator> aggregatorCollectors = new ArrayList<Aggregator>();
            Aggregator[] aggregators = context.aggregations().factories().createTopLevelAggregators(aggregationContext);
            for (int i = 0; i < aggregators.length; ++i) {
                Aggregator aggregator;
                if (aggregators[i] instanceof GlobalAggregator || !(aggregator = aggregators[i]).shouldCollect()) continue;
                aggregatorCollectors.add(aggregator);
            }
            context.aggregations().aggregators(aggregators);
            if (!aggregatorCollectors.isEmpty()) {
                facetAggCollectorBuilder.add((Object)new AggregationPhase.AggregationsCollector(aggregatorCollectors, aggregationContext));
            }
            aggregationContext.setNextReader(context.searcher().getIndexReader().getContext());
        }
        this.facetAndAggregatorCollector = facetAggCollectorBuilder.build();
    }

    public void postMatch(int doc) throws IOException {
        for (Collector collector : this.facetAndAggregatorCollector) {
            collector.collect(doc);
        }
    }

    public void setScorer(Scorer scorer) throws IOException {
        for (Collector collector : this.facetAndAggregatorCollector) {
            collector.setScorer(scorer);
        }
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.values = this.idFieldData.load(context).getBytesValues();
        for (Collector collector : this.facetAndAggregatorCollector) {
            collector.setNextReader(context);
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    static Match match(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase, boolean isNestedDoc) {
        return new Match(logger, context, highlightPhase, isNestedDoc);
    }

    static Count count(ESLogger logger, PercolateContext context, boolean isNestedDoc) {
        return new Count(logger, context, isNestedDoc);
    }

    static MatchAndScore matchAndScore(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase, boolean isNestedDoc) {
        return new MatchAndScore(logger, context, highlightPhase, isNestedDoc);
    }

    static MatchAndSort matchAndSort(ESLogger logger, PercolateContext context, boolean isNestedDoc) {
        return new MatchAndSort(logger, context, isNestedDoc);
    }

    protected final Query getQuery(int doc) {
        this.values.setDocument(doc);
        int numValues = this.values.count();
        if (numValues == 0) {
            return null;
        }
        assert (numValues == 1);
        this.current = this.values.valueAt(0);
        return (Query)this.queries.get(this.current);
    }

    static final class Count
    extends QueryCollector {
        private long counter = 0L;

        Count(ESLogger logger, PercolateContext context, boolean isNestedDoc) {
            super(logger, context, isNestedDoc);
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            try {
                if (this.isNestedDoc) {
                    Lucene.exists(this.searcher, query, NonNestedDocsFilter.INSTANCE, this.collector);
                } else {
                    Lucene.exists(this.searcher, query, this.collector);
                }
                if (this.collector.exists()) {
                    ++this.counter;
                    this.postMatch(doc);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.current.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        long counter() {
            return this.counter;
        }
    }

    static final class MatchAndScore
    extends QueryCollector {
        final PercolateContext context;
        final HighlightPhase highlightPhase;
        final List<BytesRef> matches = new ArrayList<BytesRef>();
        final List<Map<String, HighlightField>> hls = new ArrayList<Map<String, HighlightField>>();
        final FloatArrayList scores = new FloatArrayList();
        final boolean limit;
        final int size;
        long counter = 0L;
        private Scorer scorer;

        MatchAndScore(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase, boolean isNestedDoc) {
            super(logger, context, isNestedDoc);
            this.limit = context.limit;
            this.size = context.size();
            this.context = context;
            this.highlightPhase = highlightPhase;
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            try {
                if (this.context.highlight() != null) {
                    this.context.parsedQuery(new ParsedQuery(query));
                    this.context.hitContext().cache().clear();
                }
                if (this.isNestedDoc) {
                    Lucene.exists(this.searcher, query, NonNestedDocsFilter.INSTANCE, this.collector);
                } else {
                    Lucene.exists(this.searcher, query, this.collector);
                }
                if (this.collector.exists()) {
                    if (!this.limit || this.counter < (long)this.size) {
                        this.matches.add(BytesRef.deepCopyOf((BytesRef)this.current));
                        this.scores.add(this.scorer.score());
                        if (this.context.highlight() != null) {
                            this.highlightPhase.hitExecute(this.context, this.context.hitContext());
                            this.hls.add(this.context.hitContext().hit().getHighlightFields());
                        }
                    }
                    ++this.counter;
                    this.postMatch(doc);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.current.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        long counter() {
            return this.counter;
        }

        List<BytesRef> matches() {
            return this.matches;
        }

        FloatArrayList scores() {
            return this.scores;
        }

        List<Map<String, HighlightField>> hls() {
            return this.hls;
        }
    }

    static final class MatchAndSort
    extends QueryCollector {
        private final TopScoreDocCollector topDocsCollector;

        MatchAndSort(ESLogger logger, PercolateContext context, boolean isNestedDoc) {
            super(logger, context, isNestedDoc);
            this.topDocsCollector = TopScoreDocCollector.create((int)context.size(), (boolean)false);
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            try {
                if (this.isNestedDoc) {
                    Lucene.exists(this.searcher, query, NonNestedDocsFilter.INSTANCE, this.collector);
                } else {
                    Lucene.exists(this.searcher, query, this.collector);
                }
                if (this.collector.exists()) {
                    this.topDocsCollector.collect(doc);
                    this.postMatch(doc);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.current.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            super.setNextReader(context);
            this.topDocsCollector.setNextReader(context);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.topDocsCollector.setScorer(scorer);
        }

        TopDocs topDocs() {
            return this.topDocsCollector.topDocs();
        }
    }

    static final class Match
    extends QueryCollector {
        final PercolateContext context;
        final HighlightPhase highlightPhase;
        final List<BytesRef> matches = new ArrayList<BytesRef>();
        final List<Map<String, HighlightField>> hls = new ArrayList<Map<String, HighlightField>>();
        final boolean limit;
        final int size;
        long counter = 0L;

        Match(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase, boolean isNestedDoc) {
            super(logger, context, isNestedDoc);
            this.limit = context.limit;
            this.size = context.size();
            this.context = context;
            this.highlightPhase = highlightPhase;
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            try {
                if (this.context.highlight() != null) {
                    this.context.parsedQuery(new ParsedQuery(query));
                    this.context.hitContext().cache().clear();
                }
                if (this.isNestedDoc) {
                    Lucene.exists(this.searcher, query, NonNestedDocsFilter.INSTANCE, this.collector);
                } else {
                    Lucene.exists(this.searcher, query, this.collector);
                }
                if (this.collector.exists()) {
                    if (!this.limit || this.counter < (long)this.size) {
                        this.matches.add(BytesRef.deepCopyOf((BytesRef)this.current));
                        if (this.context.highlight() != null) {
                            this.highlightPhase.hitExecute(this.context, this.context.hitContext());
                            this.hls.add(this.context.hitContext().hit().getHighlightFields());
                        }
                    }
                    ++this.counter;
                    this.postMatch(doc);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.current.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        long counter() {
            return this.counter;
        }

        List<BytesRef> matches() {
            return this.matches;
        }

        List<Map<String, HighlightField>> hls() {
            return this.hls;
        }
    }
}

