/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Strings;

public interface ScriptContext {
    public String getKey();

    public static final class Plugin
    implements ScriptContext {
        private final String pluginName;
        private final String operation;
        private final String key;

        public Plugin(String pluginName, String operation) {
            if (!Strings.hasLength(pluginName)) {
                throw new ElasticsearchIllegalArgumentException("plugin name cannot be empty when registering a custom script context");
            }
            if (!Strings.hasLength(operation)) {
                throw new ElasticsearchIllegalArgumentException("operation name cannot be empty when registering a custom script context");
            }
            this.pluginName = pluginName;
            this.operation = operation;
            this.key = pluginName + "_" + operation;
        }

        public final String getPluginName() {
            return this.pluginName;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final String getKey() {
            return this.key;
        }

        public final String toString() {
            return this.getKey();
        }
    }

    public static enum Standard implements ScriptContext
    {
        AGGS("aggs"),
        MAPPING("mapping"),
        SEARCH("search"),
        UPDATE("update"),
        GENERIC_PLUGIN("plugin");

        private final String key;

        private Standard(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.getKey();
        }
    }
}

