/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.TopReaderContextAware;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;
import org.elasticsearch.index.fielddata.SortingNumericDocValues;
import org.elasticsearch.index.fielddata.SortingNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.values.ScriptBytesValues;
import org.elasticsearch.search.aggregations.support.values.ScriptDoubleValues;
import org.elasticsearch.search.aggregations.support.values.ScriptLongValues;
import org.elasticsearch.search.internal.SearchContext;

public abstract class ValuesSource {
    public abstract SortedBinaryDocValues bytesValues();

    public abstract Bits docsWithValue(int var1);

    public void setNeedsGlobalOrdinals(boolean needsGlobalOrdinals) {
    }

    public abstract MetaData metaData();

    public static class GeoPoint
    extends ValuesSource
    implements ReaderContextAware {
        protected final IndexGeoPointFieldData indexFieldData;
        private final MetaData metaData;
        protected AtomicGeoPointFieldData atomicFieldData;
        private SortedBinaryDocValues bytesValues;
        private MultiGeoPointValues geoPointValues;

        public GeoPoint(IndexGeoPointFieldData indexFieldData, MetaData metaData) {
            this.indexFieldData = indexFieldData;
            this.metaData = metaData;
        }

        @Override
        public Bits docsWithValue(int maxDoc) {
            MultiGeoPointValues geoPoints = this.geoPointValues();
            if (FieldData.unwrapSingleton(geoPoints) != null) {
                return FieldData.unwrapSingletonBits(geoPoints);
            }
            return FieldData.docsWithValue(geoPoints, maxDoc);
        }

        @Override
        public MetaData metaData() {
            return this.metaData;
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
            this.atomicFieldData = (AtomicGeoPointFieldData)this.indexFieldData.load(reader);
            if (this.bytesValues != null) {
                this.bytesValues = this.atomicFieldData.getBytesValues();
            }
            if (this.geoPointValues != null) {
                this.geoPointValues = this.atomicFieldData.getGeoPointValues();
            }
        }

        @Override
        public SortedBinaryDocValues bytesValues() {
            if (this.bytesValues == null) {
                this.bytesValues = this.atomicFieldData.getBytesValues();
            }
            return this.bytesValues;
        }

        public MultiGeoPointValues geoPointValues() {
            if (this.geoPointValues == null) {
                this.geoPointValues = this.atomicFieldData.getGeoPointValues();
            }
            return this.geoPointValues;
        }
    }

    public static class WithScript
    extends Bytes {
        private final SortedBinaryDocValues bytesValues;

        public WithScript(ValuesSource delegate, SearchScript script) {
            this.bytesValues = new BytesValues(delegate, script);
        }

        @Override
        public MetaData metaData() {
            return MetaData.UNKNOWN;
        }

        @Override
        public SortedBinaryDocValues bytesValues() {
            return this.bytesValues;
        }

        static class BytesValues
        extends SortingBinaryDocValues {
            private final ValuesSource source;
            private final SearchScript script;

            public BytesValues(ValuesSource source, SearchScript script) {
                this.source = source;
                this.script = script;
            }

            @Override
            public void setDocument(int docId) {
                this.source.bytesValues().setDocument(docId);
                this.count = this.source.bytesValues().count();
                this.grow();
                for (int i = 0; i < this.count; ++i) {
                    BytesRef value = this.source.bytesValues().valueAt(i);
                    this.script.setNextVar("_value", value.utf8ToString());
                    this.values[i].copyChars((CharSequence)this.script.run().toString());
                }
                this.sort();
            }
        }
    }

    public static abstract class Numeric
    extends ValuesSource {
        public abstract boolean isFloatingPoint();

        public abstract SortedNumericDocValues longValues();

        public abstract SortedNumericDoubleValues doubleValues();

        @Override
        public Bits docsWithValue(int maxDoc) {
            if (this.isFloatingPoint()) {
                SortedNumericDoubleValues values = this.doubleValues();
                if (org.elasticsearch.index.fielddata.FieldData.unwrapSingleton(values) != null) {
                    return org.elasticsearch.index.fielddata.FieldData.unwrapSingletonBits(values);
                }
                return org.elasticsearch.index.fielddata.FieldData.docsWithValue(values, maxDoc);
            }
            SortedNumericDocValues values = this.longValues();
            if (DocValues.unwrapSingleton((SortedNumericDocValues)values) != null) {
                return DocValues.unwrapSingletonBits((SortedNumericDocValues)values);
            }
            return DocValues.docsWithValue((SortedNumericDocValues)values, (int)maxDoc);
        }

        public static class Script
        extends Numeric {
            private final ValueType scriptValueType;
            private final ScriptDoubleValues doubleValues;
            private final ScriptLongValues longValues;
            private final ScriptBytesValues bytesValues;

            public Script(SearchScript script, ValueType scriptValueType) {
                this.scriptValueType = scriptValueType;
                this.longValues = new ScriptLongValues(script);
                this.doubleValues = new ScriptDoubleValues(script);
                this.bytesValues = new ScriptBytesValues(script);
            }

            @Override
            public MetaData metaData() {
                return MetaData.UNKNOWN;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.scriptValueType != null ? this.scriptValueType.isFloatingPoint() : true;
            }

            @Override
            public SortedNumericDocValues longValues() {
                return this.longValues;
            }

            @Override
            public SortedNumericDoubleValues doubleValues() {
                return this.doubleValues;
            }

            @Override
            public SortedBinaryDocValues bytesValues() {
                return this.bytesValues;
            }
        }

        public static class FieldData
        extends Numeric
        implements ReaderContextAware {
            protected boolean needsHashes;
            protected final IndexNumericFieldData indexFieldData;
            protected final MetaData metaData;
            protected AtomicNumericFieldData atomicFieldData;
            private SortedBinaryDocValues bytesValues;
            private SortedNumericDocValues longValues;
            private SortedNumericDoubleValues doubleValues;

            public FieldData(IndexNumericFieldData indexFieldData, MetaData metaData) {
                this.indexFieldData = indexFieldData;
                this.metaData = metaData;
                this.needsHashes = false;
            }

            @Override
            public MetaData metaData() {
                return this.metaData;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.indexFieldData.getNumericType().isFloatingPoint();
            }

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                this.atomicFieldData = (AtomicNumericFieldData)this.indexFieldData.load(reader);
                if (this.bytesValues != null) {
                    this.bytesValues = this.atomicFieldData.getBytesValues();
                }
                if (this.longValues != null) {
                    this.longValues = this.atomicFieldData.getLongValues();
                }
                if (this.doubleValues != null) {
                    this.doubleValues = this.atomicFieldData.getDoubleValues();
                }
            }

            @Override
            public SortedBinaryDocValues bytesValues() {
                if (this.bytesValues == null) {
                    this.bytesValues = this.atomicFieldData.getBytesValues();
                }
                return this.bytesValues;
            }

            @Override
            public SortedNumericDocValues longValues() {
                if (this.longValues == null) {
                    this.longValues = this.atomicFieldData.getLongValues();
                }
                return this.longValues;
            }

            @Override
            public SortedNumericDoubleValues doubleValues() {
                if (this.doubleValues == null) {
                    this.doubleValues = this.atomicFieldData.getDoubleValues();
                }
                return this.doubleValues;
            }
        }

        public static class WithScript
        extends Numeric {
            private final SortedNumericDocValues longValues;
            private final SortedNumericDoubleValues doubleValues;
            private final SortedBinaryDocValues bytesValues;

            public WithScript(Numeric delegate, SearchScript script) {
                this.longValues = new LongValues(delegate, script);
                this.doubleValues = new DoubleValues(delegate, script);
                this.bytesValues = new WithScript.BytesValues(delegate, script);
            }

            @Override
            public boolean isFloatingPoint() {
                return true;
            }

            @Override
            public SortedBinaryDocValues bytesValues() {
                return this.bytesValues;
            }

            @Override
            public SortedNumericDocValues longValues() {
                return this.longValues;
            }

            @Override
            public SortedNumericDoubleValues doubleValues() {
                return this.doubleValues;
            }

            @Override
            public MetaData metaData() {
                return MetaData.UNKNOWN;
            }

            static class DoubleValues
            extends SortingNumericDoubleValues {
                private final Numeric source;
                private final SearchScript script;

                public DoubleValues(Numeric source, SearchScript script) {
                    this.source = source;
                    this.script = script;
                }

                @Override
                public void setDocument(int docId) {
                    this.script.setNextDocId(docId);
                    this.source.doubleValues().setDocument(docId);
                    this.count = this.source.doubleValues().count();
                    this.grow();
                    for (int i = 0; i < this.count; ++i) {
                        this.script.setNextVar("_value", this.source.doubleValues().valueAt(i));
                        this.values[i] = this.script.runAsDouble();
                    }
                    this.sort();
                }
            }

            static class LongValues
            extends SortingNumericDocValues {
                private final Numeric source;
                private final SearchScript script;

                public LongValues(Numeric source, SearchScript script) {
                    this.source = source;
                    this.script = script;
                }

                public void setDocument(int docId) {
                    this.script.setNextDocId(docId);
                    this.source.longValues().setDocument(docId);
                    this.resize(this.source.longValues().count());
                    for (int i = 0; i < this.count(); ++i) {
                        this.script.setNextVar("_value", this.source.longValues().valueAt(i));
                        this.values[i] = this.script.runAsLong();
                    }
                    this.sort();
                }
            }
        }
    }

    public static abstract class Bytes
    extends ValuesSource {
        @Override
        public Bits docsWithValue(int maxDoc) {
            SortedBinaryDocValues bytes = this.bytesValues();
            if (org.elasticsearch.index.fielddata.FieldData.unwrapSingleton(bytes) != null) {
                return org.elasticsearch.index.fielddata.FieldData.unwrapSingletonBits(bytes);
            }
            return org.elasticsearch.index.fielddata.FieldData.docsWithValue(bytes, maxDoc);
        }

        public static class Script
        extends Bytes {
            private final ScriptBytesValues values;

            public Script(SearchScript script) {
                this.values = new ScriptBytesValues(script);
            }

            @Override
            public MetaData metaData() {
                return MetaData.UNKNOWN;
            }

            @Override
            public SortedBinaryDocValues bytesValues() {
                return this.values;
            }
        }

        public static class FieldData
        extends Bytes
        implements ReaderContextAware {
            protected final IndexFieldData<?> indexFieldData;
            protected final MetaData metaData;
            protected AtomicFieldData atomicFieldData;
            private SortedBinaryDocValues bytesValues;

            public FieldData(IndexFieldData<?> indexFieldData, MetaData metaData) {
                this.indexFieldData = indexFieldData;
                this.metaData = metaData;
            }

            @Override
            public MetaData metaData() {
                return this.metaData;
            }

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                this.atomicFieldData = this.indexFieldData.load(reader);
                if (this.bytesValues != null) {
                    this.bytesValues = this.atomicFieldData.getBytesValues();
                }
            }

            @Override
            public SortedBinaryDocValues bytesValues() {
                if (this.bytesValues == null) {
                    this.bytesValues = this.atomicFieldData.getBytesValues();
                }
                return this.bytesValues;
            }
        }

        public static class ParentChild
        extends Bytes
        implements ReaderContextAware,
        TopReaderContextAware {
            protected final ParentChildIndexFieldData indexFieldData;
            protected final MetaData metaData;
            protected AtomicParentChildFieldData atomicFieldData;
            protected IndexParentChildFieldData globalFieldData;
            private long maxOrd = -1L;

            public ParentChild(ParentChildIndexFieldData indexFieldData, MetaData metaData) {
                this.indexFieldData = indexFieldData;
                this.metaData = metaData;
            }

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                this.atomicFieldData = (AtomicParentChildFieldData)this.globalFieldData.load(reader);
            }

            @Override
            public void setNextReader(IndexReaderContext reader) {
                this.globalFieldData = this.indexFieldData.loadGlobal(reader.reader());
            }

            public SortedDocValues globalOrdinalsValues(String type) {
                return this.atomicFieldData.getOrdinalsValues(type);
            }

            public long globalMaxOrd(IndexSearcher indexSearcher, String type) {
                if (this.maxOrd != -1L) {
                    return this.maxOrd;
                }
                IndexReader indexReader = indexSearcher.getIndexReader();
                if (indexReader.leaves().isEmpty()) {
                    this.maxOrd = 0L;
                    return 0L;
                }
                AtomicReaderContext atomicReaderContext = (AtomicReaderContext)indexReader.leaves().get(0);
                IndexParentChildFieldData globalFieldData = this.indexFieldData.loadGlobal(indexReader);
                AtomicParentChildFieldData afd = (AtomicParentChildFieldData)globalFieldData.load(atomicReaderContext);
                SortedDocValues values = afd.getOrdinalsValues(type);
                this.maxOrd = values.getValueCount();
                return this.maxOrd;
            }

            @Override
            public SortedBinaryDocValues bytesValues() {
                return this.atomicFieldData.getBytesValues();
            }

            @Override
            public MetaData metaData() {
                return this.metaData;
            }
        }

        public static abstract class WithOrdinals
        extends Bytes
        implements TopReaderContextAware {
            @Override
            public Bits docsWithValue(int maxDoc) {
                RandomAccessOrds ordinals = this.ordinalsValues();
                if (DocValues.unwrapSingleton((SortedSetDocValues)ordinals) != null) {
                    return DocValues.docsWithValue((SortedDocValues)DocValues.unwrapSingleton((SortedSetDocValues)ordinals), (int)maxDoc);
                }
                return DocValues.docsWithValue((SortedSetDocValues)ordinals, (int)maxDoc);
            }

            public abstract RandomAccessOrds ordinalsValues();

            @Override
            public abstract void setNextReader(IndexReaderContext var1);

            public abstract RandomAccessOrds globalOrdinalsValues();

            public abstract long globalMaxOrd(IndexSearcher var1);

            public static class FieldData
            extends WithOrdinals
            implements ReaderContextAware {
                protected final IndexOrdinalsFieldData indexFieldData;
                protected final MetaData metaData;
                private boolean needsGlobalOrdinals;
                protected AtomicOrdinalsFieldData atomicFieldData;
                private SortedBinaryDocValues bytesValues;
                private RandomAccessOrds ordinalsValues;
                protected IndexOrdinalsFieldData globalFieldData;
                protected AtomicOrdinalsFieldData globalAtomicFieldData;
                private RandomAccessOrds globalBytesValues;
                private long maxOrd = -1L;

                public FieldData(IndexOrdinalsFieldData indexFieldData, MetaData metaData) {
                    this.indexFieldData = indexFieldData;
                    this.metaData = metaData;
                }

                @Override
                public MetaData metaData() {
                    return this.metaData;
                }

                @Override
                public void setNeedsGlobalOrdinals(boolean needsGlobalOrdinals) {
                    this.needsGlobalOrdinals = needsGlobalOrdinals;
                }

                @Override
                public void setNextReader(AtomicReaderContext reader) {
                    this.atomicFieldData = (AtomicOrdinalsFieldData)this.indexFieldData.load(reader);
                    if (this.bytesValues != null) {
                        this.bytesValues = this.atomicFieldData.getBytesValues();
                    }
                    if (this.ordinalsValues != null) {
                        this.ordinalsValues = this.atomicFieldData.getOrdinalsValues();
                    }
                    if (this.globalFieldData != null) {
                        this.globalAtomicFieldData = (AtomicOrdinalsFieldData)this.globalFieldData.load(reader);
                        if (this.globalBytesValues != null) {
                            this.globalBytesValues = this.globalAtomicFieldData.getOrdinalsValues();
                        }
                    }
                }

                @Override
                public SortedBinaryDocValues bytesValues() {
                    if (this.bytesValues == null) {
                        this.bytesValues = this.atomicFieldData.getBytesValues();
                    }
                    return this.bytesValues;
                }

                @Override
                public RandomAccessOrds ordinalsValues() {
                    if (this.ordinalsValues == null) {
                        this.ordinalsValues = this.atomicFieldData.getOrdinalsValues();
                    }
                    return this.ordinalsValues;
                }

                @Override
                public void setNextReader(IndexReaderContext reader) {
                    if (this.needsGlobalOrdinals) {
                        this.globalFieldData = this.indexFieldData.loadGlobal(reader.reader());
                    }
                }

                @Override
                public RandomAccessOrds globalOrdinalsValues() {
                    if (this.globalBytesValues == null) {
                        this.globalBytesValues = this.globalAtomicFieldData.getOrdinalsValues();
                    }
                    return this.globalBytesValues;
                }

                @Override
                public long globalMaxOrd(IndexSearcher indexSearcher) {
                    if (this.maxOrd != -1L) {
                        return this.maxOrd;
                    }
                    IndexReader indexReader = indexSearcher.getIndexReader();
                    if (indexReader.leaves().isEmpty()) {
                        this.maxOrd = 0L;
                        return 0L;
                    }
                    AtomicReaderContext atomicReaderContext = (AtomicReaderContext)indexReader.leaves().get(0);
                    IndexOrdinalsFieldData globalFieldData = this.indexFieldData.loadGlobal(indexReader);
                    AtomicOrdinalsFieldData afd = (AtomicOrdinalsFieldData)globalFieldData.load(atomicReaderContext);
                    RandomAccessOrds values = afd.getOrdinalsValues();
                    this.maxOrd = values.getValueCount();
                    return this.maxOrd;
                }
            }
        }
    }

    public static class MetaData {
        public static final MetaData UNKNOWN = new MetaData();
        private long maxAtomicUniqueValuesCount = -1L;
        private boolean multiValued = true;
        private Uniqueness uniqueness = Uniqueness.UNKNOWN;

        private MetaData() {
        }

        private MetaData(MetaData other) {
            this.maxAtomicUniqueValuesCount = other.maxAtomicUniqueValuesCount;
            this.multiValued = other.multiValued;
            this.uniqueness = other.uniqueness;
        }

        private MetaData(long maxAtomicUniqueValuesCount, boolean multiValued, Uniqueness uniqueness) {
            this.maxAtomicUniqueValuesCount = maxAtomicUniqueValuesCount;
            this.multiValued = multiValued;
            this.uniqueness = uniqueness;
        }

        public long maxAtomicUniqueValuesCount() {
            return this.maxAtomicUniqueValuesCount;
        }

        public boolean multiValued() {
            return this.multiValued;
        }

        public Uniqueness uniqueness() {
            return this.uniqueness;
        }

        public static MetaData load(IndexFieldData<?> indexFieldData, SearchContext context) {
            MetaData metaData = new MetaData();
            metaData.uniqueness = Uniqueness.UNIQUE;
            for (AtomicReaderContext readerContext : context.searcher().getTopReaderContext().leaves()) {
                Object values;
                AtomicFieldData fd;
                Object fieldData = indexFieldData.load(readerContext);
                if (fieldData instanceof AtomicOrdinalsFieldData) {
                    fd = (AtomicOrdinalsFieldData)fieldData;
                    values = fd.getOrdinalsValues();
                    metaData.multiValued |= FieldData.isMultiValued((SortedSetDocValues)values);
                    metaData.maxAtomicUniqueValuesCount = Math.max(metaData.maxAtomicUniqueValuesCount, values.getValueCount());
                    continue;
                }
                if (fieldData instanceof AtomicNumericFieldData) {
                    fd = (AtomicNumericFieldData)fieldData;
                    values = fd.getDoubleValues();
                    metaData.multiValued |= FieldData.isMultiValued((SortedNumericDoubleValues)values);
                    metaData.maxAtomicUniqueValuesCount = Long.MAX_VALUE;
                    continue;
                }
                if (fieldData instanceof AtomicGeoPointFieldData) {
                    fd = (AtomicGeoPointFieldData)fieldData;
                    values = fd.getGeoPointValues();
                    metaData.multiValued |= FieldData.isMultiValued((MultiGeoPointValues)values);
                    metaData.maxAtomicUniqueValuesCount = Long.MAX_VALUE;
                    continue;
                }
                metaData.multiValued = true;
                metaData.maxAtomicUniqueValuesCount = Long.MAX_VALUE;
            }
            return metaData;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(MetaData other) {
            return new Builder(other);
        }

        public static class Builder {
            private final MetaData metaData;

            private Builder() {
                this.metaData = new MetaData();
            }

            private Builder(MetaData metaData) {
                this.metaData = new MetaData(metaData);
            }

            public Builder maxAtomicUniqueValuesCount(long maxAtomicUniqueValuesCount) {
                this.metaData.maxAtomicUniqueValuesCount = maxAtomicUniqueValuesCount;
                return this;
            }

            public Builder multiValued(boolean multiValued) {
                this.metaData.multiValued = multiValued;
                return this;
            }

            public Builder uniqueness(Uniqueness uniqueness) {
                this.metaData.uniqueness = uniqueness;
                return this;
            }

            public MetaData build() {
                return this.metaData;
            }
        }

        public static enum Uniqueness {
            UNIQUE,
            NOT_UNIQUE,
            UNKNOWN;


            public boolean unique() {
                return this == UNIQUE;
            }
        }
    }
}

