/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.builder.SearchSourceBuilder;

@Deprecated
public class CountRequest
extends BroadcastRequest<CountRequest> {
    public static final float DEFAULT_MIN_SCORE = -1.0f;
    private float minScore = -1.0f;
    @Nullable
    protected String routing;
    @Nullable
    private String preference;
    private BytesReference source;
    private String[] types = Strings.EMPTY_ARRAY;
    private int terminateAfter = 0;

    public CountRequest(String ... indices) {
        super(indices);
    }

    public float minScore() {
        return this.minScore;
    }

    public CountRequest minScore(float minScore) {
        this.minScore = minScore;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public CountRequest source(QuerySourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public CountRequest source(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(querySource);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + querySource + "]", e);
        }
    }

    public CountRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        return this;
    }

    public CountRequest source(String querySource) {
        this.source = new BytesArray(querySource);
        return this;
    }

    public CountRequest source(byte[] querySource) {
        return this.source(querySource, 0, querySource.length);
    }

    public CountRequest source(byte[] querySource, int offset, int length) {
        return this.source(new BytesArray(querySource, offset, length));
    }

    public CountRequest source(BytesReference querySource) {
        this.source = querySource;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public CountRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public CountRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public CountRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public CountRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public CountRequest terminateAfter(int terminateAfterCount) {
        if (terminateAfterCount <= 0) {
            throw new IllegalArgumentException("terminateAfter must be > 0");
        }
        this.terminateAfter = terminateAfterCount;
        return this;
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("CountRequest doesn't support being sent over the wire, just a shortcut to the search api");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("CountRequest doesn't support being sent over the wire, just a shortcut to the search api");
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types) + ", source[" + sSource + "]";
    }

    public SearchRequest toSearchRequest() {
        SearchRequest searchRequest = new SearchRequest(this.indices());
        searchRequest.indicesOptions(this.indicesOptions());
        searchRequest.types(this.types());
        searchRequest.routing(this.routing());
        searchRequest.preference(this.preference());
        searchRequest.source(this.source());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(0);
        if (this.minScore() != -1.0f) {
            searchSourceBuilder.minScore(this.minScore());
        }
        if (this.terminateAfter() != 0) {
            searchSourceBuilder.terminateAfter(this.terminateAfter());
        }
        searchRequest.extraSource(searchSourceBuilder);
        return searchRequest;
    }
}

