/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.script.ScriptService;

public class IndexQueryParserService
extends AbstractIndexComponent {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(IndexQueryParserService.class));
    public static final String DEFAULT_FIELD = "index.query.default_field";
    public static final String QUERY_STRING_LENIENT = "index.query_string.lenient";
    public static final String PARSE_STRICT = "index.query.parse.strict";
    public static final String ALLOW_UNMAPPED = "index.query.parse.allow_unmapped_fields";
    private CloseableThreadLocal<QueryParseContext> cache = new CloseableThreadLocal<QueryParseContext>(){

        protected QueryParseContext initialValue() {
            return new QueryParseContext(IndexQueryParserService.this.index, IndexQueryParserService.this);
        }
    };
    private final IndexSettingsService indexSettingsService;
    final AnalysisService analysisService;
    final ScriptService scriptService;
    final MapperService mapperService;
    final SimilarityService similarityService;
    final IndexCache indexCache;
    final IndexFieldDataService fieldDataService;
    final BitsetFilterCache bitsetFilterCache;
    private final IndicesQueriesRegistry indicesQueriesRegistry;
    private String defaultField;
    private boolean queryStringLenient;
    private final ParseFieldMatcher parseFieldMatcher;
    private final boolean defaultAllowUnmappedFields;

    @Inject
    public IndexQueryParserService(Index index, IndexSettingsService indexSettingsService, IndicesQueriesRegistry indicesQueriesRegistry, ScriptService scriptService, AnalysisService analysisService, MapperService mapperService, IndexCache indexCache, IndexFieldDataService fieldDataService, BitsetFilterCache bitsetFilterCache, @Nullable SimilarityService similarityService) {
        super(index, indexSettingsService.getSettings());
        this.indexSettingsService = indexSettingsService;
        this.scriptService = scriptService;
        this.analysisService = analysisService;
        this.mapperService = mapperService;
        this.similarityService = similarityService;
        this.indexCache = indexCache;
        this.fieldDataService = fieldDataService;
        this.bitsetFilterCache = bitsetFilterCache;
        Settings indexSettings = indexSettingsService.getSettings();
        this.defaultField = indexSettings.get(DEFAULT_FIELD, "_all");
        this.queryStringLenient = indexSettings.getAsBoolean(QUERY_STRING_LENIENT, (Boolean)false);
        this.parseFieldMatcher = new ParseFieldMatcher(indexSettings);
        this.defaultAllowUnmappedFields = indexSettings.getAsBoolean(ALLOW_UNMAPPED, (Boolean)true);
        this.indicesQueriesRegistry = indicesQueriesRegistry;
    }

    public void close() {
        this.cache.close();
    }

    public String defaultField() {
        return this.defaultField;
    }

    public boolean queryStringLenient() {
        return this.queryStringLenient;
    }

    public QueryParser queryParser(String name) {
        ImmutableMap<String, QueryParser> queryParsers = this.indicesQueriesRegistry.queryParsers();
        QueryParser queryParser = (QueryParser)queryParsers.get((Object)name);
        if (queryParser != null) {
            return queryParser;
        }
        String underscoreName = Strings.toUnderscoreCase(name);
        queryParser = (QueryParser)queryParsers.get((Object)underscoreName);
        if (queryParser != null) {
            String msg = "Deprecated query parser name [" + name + "], use [" + underscoreName + "] instead";
            DEPRECATION_LOGGER.deprecated(msg, new Object[0]);
        }
        return queryParser;
    }

    public ParsedQuery parse(QueryBuilder queryBuilder) {
        try (Releasable parser = null;){
            BytesReference bytes = queryBuilder.buildAsBytes();
            parser = XContentFactory.xContent(bytes).createParser(bytes);
            ParsedQuery parsedQuery = this.parse((QueryParseContext)this.cache.get(), (XContentParser)parser);
            return parsedQuery;
        }
    }

    public ParsedQuery parse(byte[] source) {
        return this.parse(source, 0, source.length);
    }

    public ParsedQuery parse(byte[] source, int offset, int length) {
        try (Releasable parser = null;){
            parser = XContentFactory.xContent(source, offset, length).createParser(source, offset, length);
            ParsedQuery parsedQuery = this.parse((QueryParseContext)this.cache.get(), (XContentParser)parser);
            return parsedQuery;
        }
    }

    public ParsedQuery parse(BytesReference source) {
        return this.parse((QueryParseContext)this.cache.get(), source);
    }

    public ParsedQuery parse(QueryParseContext context, BytesReference source) {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent(source).createParser(source);
            ParsedQuery parsedQuery = this.innerParse(context, parser);
            return parsedQuery;
        }
    }

    public ParsedQuery parse(String source) throws QueryParsingException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent(source).createParser(source);
            ParsedQuery parsedQuery = this.innerParse((QueryParseContext)this.cache.get(), parser);
            return parsedQuery;
        }
    }

    public ParsedQuery parse(XContentParser parser) {
        return this.parse((QueryParseContext)this.cache.get(), parser);
    }

    public ParsedQuery parse(QueryParseContext context, XContentParser parser) {
        try {
            return this.innerParse(context, parser);
        }
        catch (IOException e) {
            throw new QueryParsingException(context, "Failed to parse", e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ParsedQuery parseInnerFilter(XContentParser parser) throws IOException {
        QueryParseContext context = (QueryParseContext)this.cache.get();
        context.reset(parser);
        try {
            Query filter = context.parseInnerFilter();
            if (filter == null) {
                ParsedQuery parsedQuery = null;
                return parsedQuery;
            }
            ParsedQuery parsedQuery = new ParsedQuery(filter, context.copyNamedQueries());
            return parsedQuery;
        }
        finally {
            context.reset(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Query parseInnerQuery(XContentParser parser) throws IOException {
        QueryParseContext context = (QueryParseContext)this.cache.get();
        context.reset(parser);
        try {
            Query query = context.parseInnerQuery();
            return query;
        }
        finally {
            context.reset(null);
        }
    }

    @Nullable
    public Query parseInnerQuery(QueryParseContext parseContext) throws IOException {
        parseContext.parseFieldMatcher(this.parseFieldMatcher);
        Query query = parseContext.parseInnerQuery();
        if (query == null) {
            query = Queries.newMatchNoDocsQuery();
        }
        return query;
    }

    public QueryParseContext getParseContext() {
        return (QueryParseContext)this.cache.get();
    }

    public boolean defaultAllowUnmappedFields() {
        return this.defaultAllowUnmappedFields;
    }

    public Version getIndexCreatedVersion() {
        return Version.indexCreated(this.indexSettingsService.getSettings());
    }

    public ParsedQuery parseQuery(BytesReference source) {
        try {
            ParsedQuery parsedQuery = null;
            XContentParser parser = XContentHelper.createParser(source);
            XContentParser.Token token = parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    if ("query".equals(fieldName)) {
                        parsedQuery = this.parse(parser);
                    } else if ("query_binary".equals(fieldName) || "queryBinary".equals(fieldName)) {
                        byte[] querySource = parser.binaryValue();
                        XContentParser qSourceParser = XContentFactory.xContent(querySource).createParser(querySource);
                        parsedQuery = this.parse(qSourceParser);
                    } else {
                        throw new QueryParsingException(this.getParseContext(), "request does not support [" + fieldName + "]", new Object[0]);
                    }
                }
                token = parser.nextToken();
            }
            if (parsedQuery != null) {
                return parsedQuery;
            }
        }
        catch (QueryParsingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new QueryParsingException(this.getParseContext(), "Failed to parse", e, new Object[0]);
        }
        throw new QueryParsingException(this.getParseContext(), "Required query is missing", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsedQuery innerParse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        parseContext.reset(parser);
        try {
            parseContext.parseFieldMatcher(this.parseFieldMatcher);
            Query query = parseContext.parseInnerQuery();
            if (query == null) {
                query = Queries.newMatchNoDocsQuery();
            }
            ParsedQuery parsedQuery = new ParsedQuery(query, parseContext.copyNamedQueries());
            return parsedQuery;
        }
        finally {
            parseContext.reset(null);
        }
    }

    public ParseFieldMatcher parseFieldMatcher() {
        return this.parseFieldMatcher;
    }
}

