/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamWriter;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.CharVector;
import com.google.gwt.user.server.rpc.impl.SerializabilityUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    private static final Map<Class<?>, ValueWriter> CLASS_TO_VALUE_WRITER = new IdentityHashMap();
    private static final Map<Class<?>, VectorWriter> CLASS_TO_VECTOR_WRITER = new IdentityHashMap();
    private static final int NUMBER_OF_JS_ESCAPED_CHARS = 128;
    private static final char[] JS_CHARS_ESCAPED = new char[128];
    private static final char JS_ESCAPE_CHAR = '\\';
    private static final char JS_QUOTE_CHAR = '\"';
    private static final char[] NIBBLE_TO_HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char NON_BREAKING_HYPHEN = '\u2011';
    private final SerializationPolicy serializationPolicy;
    private ArrayList<String> tokenList = new ArrayList();
    private int tokenListCharCount;

    private static String escapeString(String toEscape) {
        char[] input = toEscape.toCharArray();
        CharVector charVector = new CharVector(input.length * 2 + 2, input.length);
        charVector.add('\"');
        for (char c : input) {
            if (ServerSerializationStreamWriter.needsUnicodeEscape(c)) {
                ServerSerializationStreamWriter.unicodeEscape(c, charVector);
                continue;
            }
            charVector.add(c);
        }
        charVector.add('\"');
        return String.valueOf(charVector.asArray(), 0, charVector.getSize());
    }

    private static Class<?> getClassForSerialization(Object instance) {
        assert (instance != null);
        if (instance instanceof Enum) {
            Enum e = (Enum)instance;
            return e.getDeclaringClass();
        }
        return instance.getClass();
    }

    private static boolean needsUnicodeEscape(char ch) {
        switch (ch) {
            case ' ': {
                return false;
            }
            case '\"': 
            case '\\': {
                return true;
            }
            case '\u2011': {
                return true;
            }
        }
        switch (Character.getType(ch)) {
            case 0: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    private static void unicodeEscape(char ch, CharVector charVector) {
        charVector.add('\\');
        if (ch < '\u0080' && JS_CHARS_ESCAPED[ch] != '\u0000') {
            charVector.add(JS_CHARS_ESCAPED[ch]);
        } else if (ch < '\u0100') {
            charVector.add('x');
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 4 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch & 0xF]);
        } else {
            charVector.add('u');
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 12 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 8 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch >> 4 & 0xF]);
            charVector.add(NIBBLE_TO_HEX_CHAR[ch & 0xF]);
        }
    }

    public ServerSerializationStreamWriter(SerializationPolicy serializationPolicy) {
        this.serializationPolicy = serializationPolicy;
    }

    @Override
    public void prepareToWrite() {
        super.prepareToWrite();
        this.tokenList.clear();
        this.tokenListCharCount = 0;
    }

    public void serializeValue(Object value, Class<?> type) throws SerializationException {
        ValueWriter valueWriter = CLASS_TO_VALUE_WRITER.get(type);
        if (valueWriter != null) {
            valueWriter.write(this, value);
        } else {
            ValueWriter.OBJECT.write(this, value);
        }
    }

    @Override
    public String toString() {
        int capacityGuess = 2 * this.tokenListCharCount + 2 * this.tokenList.size();
        LengthConstrainedArray stream = new LengthConstrainedArray(capacityGuess);
        this.writePayload(stream);
        this.writeStringTable(stream);
        this.writeHeader(stream);
        return stream.toString();
    }

    @Override
    public void writeLong(long fieldValue) {
        double[] parts = ServerSerializationStreamWriter.makeLongComponents((int)(fieldValue >> 32), (int)fieldValue);
        assert (parts.length == 2);
        this.writeDouble(parts[0]);
        this.writeDouble(parts[1]);
    }

    @Override
    protected void append(String token) {
        this.tokenList.add(token);
        if (token != null) {
            this.tokenListCharCount += token.length();
        }
    }

    @Override
    protected String getObjectTypeSignature(Object instance) {
        assert (instance != null);
        Class<?> clazz = ServerSerializationStreamWriter.getClassForSerialization(instance);
        return SerializabilityUtil.encodeSerializedInstanceReference(clazz);
    }

    @Override
    protected void serialize(Object instance, String typeSignature) throws SerializationException {
        assert (instance != null);
        Class<?> clazz = ServerSerializationStreamWriter.getClassForSerialization(instance);
        this.serializationPolicy.validateSerialize(clazz);
        this.serializeImpl(instance, clazz);
    }

    private void serializeArray(Class<?> instanceClass, Object instance) throws SerializationException {
        assert (instanceClass.isArray());
        VectorWriter instanceWriter = CLASS_TO_VECTOR_WRITER.get(instanceClass);
        if (instanceWriter != null) {
            instanceWriter.write(this, instance);
        } else {
            VectorWriter.OBJECT_VECTOR.write(this, instance);
        }
    }

    private void serializeClass(Object instance, Class<?> instanceClass) throws SerializationException {
        Field[] serializableFields;
        assert (instance != null);
        for (Field declField : serializableFields = SerializabilityUtil.applyFieldSerializationPolicy(instanceClass)) {
            boolean needsAccessOverride;
            assert (declField != null);
            boolean isAccessible = declField.isAccessible();
            boolean bl = needsAccessOverride = !isAccessible && !Modifier.isPublic(declField.getModifiers());
            if (needsAccessOverride) {
                declField.setAccessible(true);
            }
            try {
                Object value = declField.get(instance);
                this.serializeValue(value, declField.getType());
            }
            catch (IllegalArgumentException e) {
                throw new SerializationException(e);
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
        }
        Class<?> superClass = instanceClass.getSuperclass();
        if (this.serializationPolicy.shouldSerializeFields(superClass)) {
            this.serializeImpl(instance, superClass);
        }
    }

    private void serializeImpl(Object instance, Class<?> instanceClass) throws SerializationException {
        assert (instance != null);
        Class<?> customSerializer = SerializabilityUtil.hasCustomFieldSerializer(instanceClass);
        if (customSerializer != null) {
            this.serializeWithCustomSerializer(customSerializer, instance, instanceClass);
        } else if (instanceClass.isArray()) {
            this.serializeArray(instanceClass, instance);
        } else if (instanceClass.isEnum()) {
            this.writeInt(((Enum)instance).ordinal());
        } else {
            this.serializeClass(instance, instanceClass);
        }
    }

    private void serializeWithCustomSerializer(Class<?> customSerializer, Object instance, Class<?> instanceClass) throws SerializationException {
        try {
            assert (!instanceClass.isArray());
            for (Method method : customSerializer.getMethods()) {
                if (!"serialize".equals(method.getName())) continue;
                method.invoke(null, this, instance);
                return;
            }
            throw new NoSuchMethodException("serialize");
        }
        catch (SecurityException e) {
            throw new SerializationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
    }

    private void writeHeader(LengthConstrainedArray stream) {
        stream.addToken(this.getFlags());
        stream.addToken(this.getVersion());
    }

    private void writePayload(LengthConstrainedArray stream) {
        ListIterator<String> tokenIterator = this.tokenList.listIterator(this.tokenList.size());
        while (tokenIterator.hasPrevious()) {
            stream.addToken(tokenIterator.previous());
        }
    }

    private void writeStringTable(LengthConstrainedArray stream) {
        LengthConstrainedArray tableStream = new LengthConstrainedArray();
        for (String s : this.getStringTable()) {
            tableStream.addToken(ServerSerializationStreamWriter.escapeString(s));
        }
        stream.addToken(tableStream.toString());
    }

    static {
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[0] = 48;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[8] = 98;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[9] = 116;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[10] = 110;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[12] = 102;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[13] = 114;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[92] = 92;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[34] = 34;
        CLASS_TO_VECTOR_WRITER.put(boolean[].class, VectorWriter.BOOLEAN_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(byte[].class, VectorWriter.BYTE_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(char[].class, VectorWriter.CHAR_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(double[].class, VectorWriter.DOUBLE_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(float[].class, VectorWriter.FLOAT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(int[].class, VectorWriter.INT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(long[].class, VectorWriter.LONG_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(Object[].class, VectorWriter.OBJECT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(short[].class, VectorWriter.SHORT_VECTOR);
        CLASS_TO_VECTOR_WRITER.put(String[].class, VectorWriter.STRING_VECTOR);
        CLASS_TO_VALUE_WRITER.put(Boolean.TYPE, ValueWriter.BOOLEAN);
        CLASS_TO_VALUE_WRITER.put(Byte.TYPE, ValueWriter.BYTE);
        CLASS_TO_VALUE_WRITER.put(Character.TYPE, ValueWriter.CHAR);
        CLASS_TO_VALUE_WRITER.put(Double.TYPE, ValueWriter.DOUBLE);
        CLASS_TO_VALUE_WRITER.put(Float.TYPE, ValueWriter.FLOAT);
        CLASS_TO_VALUE_WRITER.put(Integer.TYPE, ValueWriter.INT);
        CLASS_TO_VALUE_WRITER.put(Long.TYPE, ValueWriter.LONG);
        CLASS_TO_VALUE_WRITER.put(Object.class, ValueWriter.OBJECT);
        CLASS_TO_VALUE_WRITER.put(Short.TYPE, ValueWriter.SHORT);
        CLASS_TO_VALUE_WRITER.put(String.class, ValueWriter.STRING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VectorWriter {
        BOOLEAN_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                boolean[] vector = (boolean[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeBoolean(vector[i]);
                }
            }
        }
        ,
        BYTE_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                byte[] vector = (byte[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeByte(vector[i]);
                }
            }
        }
        ,
        CHAR_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                char[] vector = (char[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeChar(vector[i]);
                }
            }
        }
        ,
        DOUBLE_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                double[] vector = (double[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeDouble(vector[i]);
                }
            }
        }
        ,
        FLOAT_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                float[] vector = (float[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeFloat(vector[i]);
                }
            }
        }
        ,
        INT_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                int[] vector = (int[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeInt(vector[i]);
                }
            }
        }
        ,
        LONG_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                long[] vector = (long[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeLong(vector[i]);
                }
            }
        }
        ,
        OBJECT_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) throws SerializationException {
                Object[] vector = (Object[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeObject(vector[i]);
                }
            }
        }
        ,
        SHORT_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                short[] vector = (short[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeShort(vector[i]);
                }
            }
        }
        ,
        STRING_VECTOR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                String[] vector = (String[])instance;
                stream.writeInt(vector.length);
                int n = vector.length;
                for (int i = 0; i < n; ++i) {
                    stream.writeString(vector[i]);
                }
            }
        };


        abstract void write(ServerSerializationStreamWriter var1, Object var2) throws SerializationException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValueWriter {
        BOOLEAN{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeBoolean((Boolean)instance);
            }
        }
        ,
        BYTE{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeByte((Byte)instance);
            }
        }
        ,
        CHAR{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeChar(((Character)instance).charValue());
            }
        }
        ,
        DOUBLE{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeDouble((Double)instance);
            }
        }
        ,
        FLOAT{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeFloat(((Float)instance).floatValue());
            }
        }
        ,
        INT{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeInt((Integer)instance);
            }
        }
        ,
        LONG{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeLong((Long)instance);
            }
        }
        ,
        OBJECT{

            void write(ServerSerializationStreamWriter stream, Object instance) throws SerializationException {
                stream.writeObject(instance);
            }
        }
        ,
        SHORT{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeShort((Short)instance);
            }
        }
        ,
        STRING{

            void write(ServerSerializationStreamWriter stream, Object instance) {
                stream.writeString((String)instance);
            }
        };


        abstract void write(ServerSerializationStreamWriter var1, Object var2) throws SerializationException;
    }

    public static class LengthConstrainedArray {
        public static final int MAXIMUM_ARRAY_LENGTH = 32768;
        private static final String POSTLUDE = "])";
        private static final String PRELUDE = "].concat([";
        private final StringBuffer buffer;
        private int count = 0;
        private boolean needsComma = false;
        private int total = 0;

        public LengthConstrainedArray() {
            this.buffer = new StringBuffer();
        }

        public LengthConstrainedArray(int capacityGuess) {
            this.buffer = new StringBuffer(capacityGuess);
        }

        public void addToken(CharSequence token) {
            ++this.total;
            if (this.count++ == 32768) {
                if (this.total == 32769) {
                    this.buffer.append(PRELUDE);
                } else {
                    this.buffer.append("],[");
                }
                this.count = 0;
                this.needsComma = false;
            }
            if (this.needsComma) {
                this.buffer.append(",");
            } else {
                this.needsComma = true;
            }
            this.buffer.append(token);
        }

        public void addToken(int i) {
            this.addToken(String.valueOf(i));
        }

        public String toString() {
            if (this.total > 32768) {
                return "[" + this.buffer.toString() + POSTLUDE;
            }
            return "[" + this.buffer.toString() + "]";
        }
    }
}

