/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.merge.AddNewEntryMergePolicy;
import com.hazelcast.merge.HigherHitsMergePolicy;
import com.hazelcast.merge.LatestUpdateMergePolicy;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.ByteUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config
implements DataSerializable {
    public static final int DEFAULT_PORT = 5701;
    private String xmlConfig = null;
    private GroupConfig groupConfig = new GroupConfig();
    private int port = 5701;
    private boolean reuseAddress = false;
    private boolean portAutoIncrement = true;
    private ExecutorConfig executorConfig = new ExecutorConfig();
    private Map<String, ExecutorConfig> mapExecutors = new ConcurrentHashMap<String, ExecutorConfig>();
    private Map<String, TopicConfig> mapTopicConfigs = new ConcurrentHashMap<String, TopicConfig>();
    private Map<String, QueueConfig> mapQueueConfigs = new ConcurrentHashMap<String, QueueConfig>();
    private Map<String, MapConfig> mapConfigs = new ConcurrentHashMap<String, MapConfig>();
    private URL configurationUrl;
    private File configurationFile;
    private NetworkConfig networkConfig = new NetworkConfig();
    private boolean superClient = false;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Properties properties = new Properties();
    private Map<String, MergePolicyConfig> mapMergePolicyConfigs = new ConcurrentHashMap<String, MergePolicyConfig>();

    public Config() {
        String os;
        String superClientProp = System.getProperty("hazelcast.super.client");
        if ("true".equalsIgnoreCase(superClientProp)) {
            this.superClient = true;
        }
        this.reuseAddress = (os = System.getProperty("os.name").toLowerCase()).indexOf("win") == -1;
        this.addMergePolicyConfig(new MergePolicyConfig("hz.ADD_NEW_ENTRY", new AddNewEntryMergePolicy()));
        this.addMergePolicyConfig(new MergePolicyConfig("hz.HIGHER_HITS", new HigherHitsMergePolicy()));
        this.addMergePolicyConfig(new MergePolicyConfig("hz.LATEST_UPDATE", new LatestUpdateMergePolicy()));
    }

    public void addMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mapMergePolicyConfigs.put(mergePolicyConfig.getName(), mergePolicyConfig);
    }

    public MergePolicyConfig getMergePolicyConfig(String name) {
        return this.mapMergePolicyConfigs.get(name);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Config setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Config setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public QueueConfig getQueueConfig(String name) {
        QueueConfig config = Config.lookupByPattern(this.mapQueueConfigs, name);
        if (config != null) {
            return config;
        }
        config = this.mapQueueConfigs.get("default");
        if (config == null) {
            config = new QueueConfig();
            config.setName("default");
            this.mapQueueConfigs.put("default", config);
        }
        return config;
    }

    public MapConfig getMapConfig(String name) {
        MapConfig config = Config.lookupByPattern(this.mapConfigs, name);
        if (config != null) {
            return config;
        }
        config = this.mapConfigs.get("default");
        if (config == null) {
            config = new MapConfig();
            config.setName("default");
            this.mapConfigs.put("default", config);
        }
        return config;
    }

    public TopicConfig getTopicConfig(String name) {
        TopicConfig config = Config.lookupByPattern(this.mapTopicConfigs, name);
        if (config != null) {
            return config;
        }
        config = this.mapTopicConfigs.get("default");
        if (config == null) {
            config = new TopicConfig();
            config.setName("default");
            this.mapTopicConfigs.put("default", config);
        }
        return config;
    }

    private static <T> T lookupByPattern(Map<String, T> map, String name) {
        T t;
        T t2 = t = name.indexOf(42) < 0 ? (T)map.get(name) : null;
        if (t == null) {
            Set<String> tNames = map.keySet();
            for (String pattern : tNames) {
                if (!Config.nameMatches(name, pattern)) continue;
                return map.get(pattern);
            }
        }
        return t;
    }

    private static boolean nameMatches(String name, String pattern) {
        int index = pattern.indexOf(42);
        if (index == -1) {
            return name.equals(pattern);
        }
        String firstPart = pattern.substring(0, index);
        int indexFirstPart = name.indexOf(firstPart, 0);
        if (indexFirstPart == -1) {
            return false;
        }
        String secondPart = pattern.substring(index + 1);
        int indexSecondPart = name.indexOf(secondPart, index + 1);
        return indexSecondPart != -1;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public Config setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
        return this;
    }

    public String getXmlConfig() {
        return this.xmlConfig;
    }

    public Config setXmlConfig(String xmlConfig) {
        this.xmlConfig = xmlConfig;
        return this;
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public Config setGroupConfig(GroupConfig groupConfig) {
        this.groupConfig = groupConfig;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Config setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isPortAutoIncrement() {
        return this.portAutoIncrement;
    }

    public Config setPortAutoIncrement(boolean portAutoIncrement) {
        this.portAutoIncrement = portAutoIncrement;
        return this;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public Config setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        return this;
    }

    public ExecutorConfig getExecutorConfig() {
        return this.executorConfig;
    }

    public Config setExecutorConfig(ExecutorConfig executorConfig) {
        this.addExecutorConfig(executorConfig);
        return this;
    }

    public Config addExecutorConfig(ExecutorConfig executorConfig) {
        this.mapExecutors.put(executorConfig.getName(), executorConfig);
        return this;
    }

    public ExecutorConfig getExecutorConfig(String name) {
        ExecutorConfig defaultConfig;
        ExecutorConfig ec = this.mapExecutors.get(name);
        if (ec == null && (defaultConfig = this.mapExecutors.get("default")) != null) {
            ec = new ExecutorConfig(name, defaultConfig.getCorePoolSize(), defaultConfig.getMaxPoolSize(), defaultConfig.getKeepAliveSeconds());
        }
        if (ec == null) {
            ec = new ExecutorConfig(name);
            this.mapExecutors.put(name, ec);
        }
        return ec;
    }

    public Collection<ExecutorConfig> getExecutorConfigs() {
        return this.mapExecutors.values();
    }

    public Map<String, ExecutorConfig> getExecutorConfigMap() {
        return Collections.unmodifiableMap(this.mapExecutors);
    }

    public void setExecutorConfigMap(Map<String, ExecutorConfig> mapExecutors) {
        this.mapExecutors = mapExecutors;
        for (Map.Entry<String, ExecutorConfig> entry : this.mapExecutors.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
    }

    public void addTopicConfig(TopicConfig topicConfig) {
        this.mapTopicConfigs.put(topicConfig.getName(), topicConfig);
    }

    public Map<String, TopicConfig> getTopicConfigs() {
        return Collections.unmodifiableMap(this.mapTopicConfigs);
    }

    public Config setTopicConfigs(Map<String, TopicConfig> mapTopicConfigs) {
        this.mapTopicConfigs = mapTopicConfigs;
        for (Map.Entry<String, TopicConfig> entry : this.mapTopicConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, QueueConfig> getQConfigs() {
        return Collections.unmodifiableMap(this.mapQueueConfigs);
    }

    public void addQueueConfig(QueueConfig queueConfig) {
        this.mapQueueConfigs.put(queueConfig.getName(), queueConfig);
    }

    public void setQConfigs(Map<String, QueueConfig> mapQConfigs) {
        this.mapQueueConfigs = mapQConfigs;
        for (Map.Entry<String, QueueConfig> entry : this.mapQueueConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
    }

    public Config setMapQConfigs(Map<String, QueueConfig> mapQConfigs) {
        this.mapQueueConfigs = mapQConfigs;
        for (Map.Entry<String, QueueConfig> entry : this.mapQueueConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public void addMapConfig(MapConfig mapConfig) {
        this.mapConfigs.put(mapConfig.getName(), mapConfig);
    }

    public Map<String, MapConfig> getMapConfigs() {
        return Collections.unmodifiableMap(this.mapConfigs);
    }

    public Config setMapConfigs(Map<String, MapConfig> mapConfigs) {
        this.mapConfigs = mapConfigs;
        for (Map.Entry<String, MapConfig> entry : this.mapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public URL getConfigurationUrl() {
        return this.configurationUrl;
    }

    public Config setConfigurationUrl(URL configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public Config setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
        return this;
    }

    public boolean isSuperClient() {
        return this.superClient;
    }

    public Config setSuperClient(boolean superClient) {
        this.superClient = superClient;
        return this;
    }

    public void checkCompatibility(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Expected not null config");
        }
        if (!this.groupConfig.equals(config.getGroupConfig())) {
            throw new RuntimeException(MessageFormat.format("Incompatible group config this:\n{0}\nanother:\n{1}", this.groupConfig, config.getGroupConfig()));
        }
        this.checkMapConfigCompatible(config);
        this.checkQueueConfigCompatible(config);
        this.checkTopicConfigCompatible(config);
    }

    private void checkMapConfigCompatible(Config config) {
        HashSet<String> mapConfigNames = new HashSet<String>(this.mapConfigs.keySet());
        mapConfigNames.addAll(config.mapConfigs.keySet());
        for (String name : mapConfigNames) {
            MapConfig thatMapConfig;
            MapConfig thisMapConfig = this.getMapConfig(name);
            if (thisMapConfig.isCompatible(thatMapConfig = config.getMapConfig(name))) continue;
            throw new RuntimeException(MessageFormat.format("Incompatible map config this:\n{0}\nanother:\n{1}", thisMapConfig, thatMapConfig));
        }
    }

    private void checkQueueConfigCompatible(Config config) {
        HashSet<String> queueConfigNames = new HashSet<String>(this.mapQueueConfigs.keySet());
        queueConfigNames.addAll(config.mapQueueConfigs.keySet());
        for (String name : queueConfigNames) {
            QueueConfig thatQueueConfig;
            QueueConfig thisQueueConfig = this.getQueueConfig(name);
            if (thisQueueConfig.isCompatible(thatQueueConfig = config.getQueueConfig(name))) continue;
            throw new RuntimeException(MessageFormat.format("Incompatible queue config this:\n{0}\nanother:\n{1}", thisQueueConfig, thatQueueConfig));
        }
    }

    private void checkTopicConfigCompatible(Config config) {
        HashSet<String> topicConfigNames = new HashSet<String>(this.mapTopicConfigs.keySet());
        topicConfigNames.addAll(config.mapTopicConfigs.keySet());
        for (String name : topicConfigNames) {
            TopicConfig thatTopicConfig;
            TopicConfig thisTopicConfig = this.getTopicConfig(name);
            if (thisTopicConfig.equals(thatTopicConfig = config.getTopicConfig(name))) continue;
            throw new RuntimeException(MessageFormat.format("Incompatible topic config this:\n{0}\nanother:\n{1}", thisTopicConfig, thatTopicConfig));
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        int i;
        int size;
        this.groupConfig = new GroupConfig();
        this.groupConfig.readData(in);
        this.port = in.readInt();
        boolean[] b1 = ByteUtil.fromByte(in.readByte());
        this.reuseAddress = b1[0];
        this.portAutoIncrement = b1[1];
        this.superClient = b1[2];
        boolean[] b2 = ByteUtil.fromByte(in.readByte());
        boolean hasMapConfigs = b2[0];
        boolean hasMapExecutors = b2[1];
        boolean hasMapTopicConfigs = b2[2];
        boolean hasMapQueueConfigs = b2[3];
        boolean hasMapMergePolicyConfigs = b2[4];
        boolean hasProperties = b2[5];
        this.networkConfig = new NetworkConfig();
        this.networkConfig.readData(in);
        this.executorConfig = new ExecutorConfig();
        this.executorConfig.readData(in);
        if (hasMapConfigs) {
            size = in.readInt();
            this.mapConfigs = new ConcurrentHashMap<String, MapConfig>(size);
            for (i = 0; i < size; ++i) {
                MapConfig mapConfig = new MapConfig();
                mapConfig.readData(in);
                this.mapConfigs.put(mapConfig.getName(), mapConfig);
            }
        }
        if (hasMapExecutors) {
            size = in.readInt();
            this.mapExecutors = new ConcurrentHashMap<String, ExecutorConfig>(size);
            for (i = 0; i < size; ++i) {
                ExecutorConfig executorConfig = new ExecutorConfig();
                executorConfig.readData(in);
                this.mapExecutors.put(executorConfig.getName(), executorConfig);
            }
        }
        if (hasMapTopicConfigs) {
            size = in.readInt();
            this.mapTopicConfigs = new ConcurrentHashMap<String, TopicConfig>(size);
            for (i = 0; i < size; ++i) {
                TopicConfig topicConfig = new TopicConfig();
                topicConfig.readData(in);
                this.mapTopicConfigs.put(topicConfig.getName(), topicConfig);
            }
        }
        if (hasMapQueueConfigs) {
            size = in.readInt();
            this.mapQueueConfigs = new ConcurrentHashMap<String, QueueConfig>(size);
            for (i = 0; i < size; ++i) {
                QueueConfig queueConfig = new QueueConfig();
                queueConfig.readData(in);
                this.mapQueueConfigs.put(queueConfig.getName(), queueConfig);
            }
        }
        if (hasMapMergePolicyConfigs) {
            // empty if block
        }
        if (hasProperties) {
            size = in.readInt();
            this.properties = new Properties();
            for (i = 0; i < size; ++i) {
                String name = in.readUTF();
                String value = in.readUTF();
                this.properties.put(name, value);
            }
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        String name;
        this.getGroupConfig().writeData(out);
        out.writeInt(this.port);
        boolean hasMapConfigs = this.mapConfigs != null && !this.mapConfigs.isEmpty();
        boolean hasMapExecutors = this.mapExecutors != null && !this.mapExecutors.isEmpty();
        boolean hasMapTopicConfigs = this.mapTopicConfigs != null && !this.mapTopicConfigs.isEmpty();
        boolean hasMapQueueConfigs = this.mapQueueConfigs != null && !this.mapQueueConfigs.isEmpty();
        boolean hasMapMergePolicyConfigs = this.mapMergePolicyConfigs != null && !this.mapMergePolicyConfigs.isEmpty();
        boolean hasProperties = this.properties != null && !this.properties.isEmpty();
        out.writeByte(ByteUtil.toByte(this.reuseAddress, this.portAutoIncrement, this.superClient));
        out.writeByte(ByteUtil.toByte(hasMapConfigs, hasMapExecutors, hasMapTopicConfigs, hasMapQueueConfigs, hasMapMergePolicyConfigs, hasProperties));
        this.networkConfig.writeData(out);
        this.executorConfig.writeData(out);
        if (hasMapConfigs) {
            out.writeInt(this.mapConfigs.size());
            for (Map.Entry<String, DataSerializable> entry : this.mapConfigs.entrySet()) {
                name = entry.getKey();
                MapConfig mapConfig = (MapConfig)entry.getValue();
                mapConfig.setName(name);
                mapConfig.writeData(out);
            }
        }
        if (hasMapExecutors) {
            out.writeInt(this.mapExecutors.size());
            for (Map.Entry<String, DataSerializable> entry : this.mapExecutors.entrySet()) {
                name = entry.getKey();
                ExecutorConfig executorConfig = (ExecutorConfig)entry.getValue();
                executorConfig.setName(name);
                executorConfig.writeData(out);
            }
        }
        if (hasMapTopicConfigs) {
            out.writeInt(this.mapTopicConfigs.size());
            for (Map.Entry<String, DataSerializable> entry : this.mapTopicConfigs.entrySet()) {
                name = entry.getKey();
                TopicConfig topicConfig = (TopicConfig)entry.getValue();
                topicConfig.setName(name);
                topicConfig.writeData(out);
            }
        }
        if (hasMapQueueConfigs) {
            out.writeInt(this.mapQueueConfigs.size());
            for (Map.Entry<String, DataSerializable> entry : this.mapQueueConfigs.entrySet()) {
                name = entry.getKey();
                QueueConfig queueConfig = (QueueConfig)entry.getValue();
                queueConfig.setName(name);
                queueConfig.writeData(out);
            }
        }
        if (hasMapMergePolicyConfigs) {
            // empty if block
        }
        if (hasProperties) {
            out.writeInt(this.properties.size());
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                out.writeUTF(key);
                out.writeUTF(value);
            }
        }
    }

    public String toString() {
        return "Config [groupConfig=" + this.groupConfig + ", port=" + this.port + ", superClient=" + this.superClient + ", reuseAddress=" + this.reuseAddress + ", portAutoIncrement=" + this.portAutoIncrement + ", properties=" + this.properties + ", networkConfig=" + this.networkConfig + ", mapConfigs=" + this.mapConfigs + ", mapMergePolicyConfigs=" + this.mapMergePolicyConfigs + ", executorConfig=" + this.executorConfig + ", mapExecutors=" + this.mapExecutors + ", mapTopicConfigs=" + this.mapTopicConfigs + ", mapQueueConfigs=" + this.mapQueueConfigs + "]";
    }
}

