/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public String format(LogRecord record) {
        if (record.getLoggerName().equals("com.hazelcast.system")) {
            return record.getMessage() + LINE_SEPARATOR;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(new Date(record.getMillis())).append(' ').append(record.getLevel().getLocalizedName()).append(": ").append('[').append(record.getSourceClassName()).append("] ").append(record.getMessage()).append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

