/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.Block;
import com.hazelcast.impl.Blocks;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionServiceImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.concurrentmap.InitialState;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.partition.MigrationEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionManager
implements Runnable {
    final int PARTITION_COUNT;
    final long MIGRATION_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    final ILogger logger;
    final ConcurrentMapManager concurrentMapManager;
    final PartitionServiceImpl partitionServiceImpl;
    final Node node;
    final Block[] blocks;
    final Address thisAddress;
    final List<Block> lsBlocksToMigrate = new ArrayList<Block>(100);
    final ParallelExecutor parallelExecutorMigration;
    final ParallelExecutor parallelExecutorBackups;
    final long timeToInitiateMigration;
    long nextMigrationMillis = System.currentTimeMillis() + this.MIGRATION_INTERVAL_MILLIS;
    long migrationStartTime = 0L;
    int MIGRATION_COMPLETE_WAIT_SECONDS = 0;
    int blocksHash = Integer.MIN_VALUE;

    public PartitionManager(ConcurrentMapManager concurrentMapManager) {
        this.logger = concurrentMapManager.getNode().getLogger(PartitionManager.class.getName());
        this.concurrentMapManager = concurrentMapManager;
        this.node = concurrentMapManager.getNode();
        this.PARTITION_COUNT = concurrentMapManager.getPartitionCount();
        this.blocks = concurrentMapManager.getBlocks();
        this.thisAddress = concurrentMapManager.getThisAddress();
        this.partitionServiceImpl = new PartitionServiceImpl(concurrentMapManager);
        this.timeToInitiateMigration = System.currentTimeMillis() + (long)(this.node.getGroupProperties().INITIAL_WAIT_SECONDS.getInteger() * 1000) + this.MIGRATION_INTERVAL_MILLIS;
        this.parallelExecutorMigration = this.node.getExecutorManager().newParallelExecutor(20);
        this.parallelExecutorBackups = this.node.getExecutorManager().newParallelExecutor(12);
    }

    public void reset() {
        this.lsBlocksToMigrate.clear();
        for (int i = 0; i < this.PARTITION_COUNT; ++i) {
            this.blocks[i] = null;
        }
        this.partitionServiceImpl.reset();
        this.parallelExecutorBackups.shutdown();
        this.parallelExecutorMigration.shutdown();
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        if (now > this.nextMigrationMillis) {
            if (this.migrationStartTime != 0L) {
                this.logger.log(Level.WARNING, "Migration is not completed for " + (now - this.migrationStartTime) / 1000L + " seconds.");
                for (Block block : this.blocks) {
                    this.logger.log(Level.WARNING, block == null ? "null" : block.toString());
                }
            }
            this.nextMigrationMillis = now + this.MIGRATION_INTERVAL_MILLIS;
            if (!this.concurrentMapManager.isMaster()) {
                return;
            }
            if (this.concurrentMapManager.getMembers().size() < 2) {
                return;
            }
            if (now > this.timeToInitiateMigration) {
                this.initiateMigration();
            }
        }
    }

    void reArrangeBlocks() {
        if (this.concurrentMapManager.isMaster()) {
            List<Block> blocks;
            Map<Address, List<Block>> addressBlocks = this.getCurrentMemberBlocks();
            if (addressBlocks.size() == 0) {
                return;
            }
            ArrayList<Block> lsBlocksToRedistribute = new ArrayList<Block>();
            int aveBlockOwnCount = this.PARTITION_COUNT / addressBlocks.size();
            int membersWithMorePartitionsThanAverage = this.PARTITION_COUNT - addressBlocks.keySet().size() * aveBlockOwnCount;
            for (Address address : addressBlocks.keySet()) {
                blocks = addressBlocks.get(address);
                if (membersWithMorePartitionsThanAverage != 0 && blocks.size() == aveBlockOwnCount + 1) {
                    --membersWithMorePartitionsThanAverage;
                    continue;
                }
                int diff = blocks.size() - aveBlockOwnCount;
                for (int i = 0; i < diff; ++i) {
                    Block block = blocks.remove(0);
                    lsBlocksToRedistribute.add(block);
                }
            }
            this.lsBlocksToMigrate.clear();
            for (Address address : addressBlocks.keySet()) {
                blocks = addressBlocks.get(address);
                for (int count = blocks.size(); count < aveBlockOwnCount && lsBlocksToRedistribute.size() > 0; ++count) {
                    Block blockToMigrate = (Block)lsBlocksToRedistribute.remove(0);
                    this.addBlockToMigrate(blockToMigrate, address);
                }
            }
            lsBlocksToRedistribute.removeAll(this.lsBlocksToMigrate);
            for (Address address : addressBlocks.keySet()) {
                if (lsBlocksToRedistribute.size() == 0) break;
                if (addressBlocks.get(address).size() == aveBlockOwnCount + 1) continue;
                Block blockToMigrate = (Block)lsBlocksToRedistribute.remove(0);
                this.addBlockToMigrate(blockToMigrate, address);
            }
            Collections.shuffle(this.lsBlocksToMigrate);
        }
    }

    void quickBlockRearrangement() {
        if (!this.concurrentMapManager.isMaster()) {
            return;
        }
        this.createAllBlocks();
        Map<Address, List<Block>> addressBlocks = this.getCurrentMemberBlocks();
        if (addressBlocks.size() == 0) {
            return;
        }
        ArrayList<Block> lsEmptyBlocks = new ArrayList<Block>();
        for (Block blockReal : this.blocks) {
            if (blockReal.isMigrating() || !this.thisAddress.equals(blockReal.getOwner()) || !this.isBlockEmpty(blockReal.getBlockId())) continue;
            lsEmptyBlocks.add(blockReal);
        }
        int aveBlockOwnCount = this.PARTITION_COUNT / addressBlocks.size();
        for (Map.Entry<Address, List<Block>> entry : addressBlocks.entrySet()) {
            Address address = entry.getKey();
            List<Block> blocks = entry.getValue();
            int diff = aveBlockOwnCount - blocks.size();
            for (int i = 0; i < diff && lsEmptyBlocks.size() > 0; ++i) {
                Block block = (Block)lsEmptyBlocks.remove(0);
                block.setOwner(address);
            }
        }
        if (lsEmptyBlocks.size() > 0) {
            for (Address address : addressBlocks.keySet()) {
                if (lsEmptyBlocks.size() == 0) break;
                Block ownableBlock = (Block)lsEmptyBlocks.remove(0);
                ownableBlock.setOwner(address);
            }
        }
        this.sendBlocks(null);
        this.partitionServiceImpl.reset();
    }

    private void createAllBlocks() {
        for (int i = 0; i < this.PARTITION_COUNT; ++i) {
            Block block = this.blocks[i];
            if (block == null) {
                block = this.getOrCreateBlock(i);
            }
            if (block.getOwner() != null || this.concurrentMapManager.isSuperClient()) continue;
            block.setOwner(this.thisAddress);
        }
    }

    private void addBlockToMigrate(Block blockToMigrate, Address address) {
        if (!blockToMigrate.getOwner().equals(address)) {
            blockToMigrate.setMigrationAddress(address);
            this.lsBlocksToMigrate.add(blockToMigrate);
        }
    }

    boolean isBlockEmpty(int blockId) {
        Collection cmaps = this.concurrentMapManager.maps.values();
        for (CMap cmap : cmaps) {
            if (!cmap.hasOwned(blockId)) continue;
            return false;
        }
        return true;
    }

    public boolean containsMigratingBlock() {
        for (Block block : this.blocks) {
            if (block == null || !block.isMigrating()) continue;
            return true;
        }
        return false;
    }

    public boolean isMigrating(Request req) {
        if (req.key == null && req.blockId != -1 && this.hashBlocks() != req.blockId) {
            this.logger.log(Level.FINEST, this.thisAddress + " blockHashes aren't the same:" + this.hashBlocks() + ", request.blockId:" + req.blockId + " caller: " + req.caller);
            this.invalidateBlocksHash();
            return true;
        }
        if (req.key != null) {
            Block block = this.concurrentMapManager.getOrCreateBlock(req);
            return block.isMigrating();
        }
        return this.containsMigratingBlock();
    }

    void initiateMigration() {
        boolean hasMigrating = false;
        for (int i = 0; i < this.PARTITION_COUNT; ++i) {
            Block block = this.blocks[i];
            if (block == null) {
                block = this.getOrCreateBlock(i);
            }
            if (!block.isMigrating()) continue;
            hasMigrating = true;
        }
        if (!hasMigrating && this.lsBlocksToMigrate.size() == 0) {
            this.reArrangeBlocks();
        }
        if (!hasMigrating && this.lsBlocksToMigrate.size() > 0) {
            Block block = this.lsBlocksToMigrate.remove(0);
            this.sendBlocks(block);
        } else {
            this.sendBlocks(null);
        }
    }

    public void syncForAdd() {
        this.invalidateBlocksHash();
        if (this.concurrentMapManager.isMaster()) {
            if (this.concurrentMapManager.isSuperClient()) {
                MemberImpl nonSuperMember = null;
                for (MemberImpl member : this.concurrentMapManager.getMembers()) {
                    if (member.isSuperClient()) continue;
                    nonSuperMember = member;
                }
                if (nonSuperMember != null) {
                    for (int i = 0; i < this.PARTITION_COUNT; ++i) {
                        Block block = this.blocks[i];
                        if (block == null) {
                            block = this.getOrCreateBlock(i);
                        }
                        if (block.getOwner() != null) continue;
                        block.setOwner(nonSuperMember.getAddress());
                    }
                }
            }
            for (int i = 0; i < this.PARTITION_COUNT; ++i) {
                Block block = this.blocks[i];
                if (block != null) continue;
                block = this.getOrCreateBlock(i);
            }
            if (this.node.groupProperties.INITIAL_WAIT_SECONDS.getInteger() == 0) {
                this.quickBlockRearrangement();
            } else {
                this.createAllBlocks();
                this.sendBlocks(null);
            }
        }
        InitialState initialState = new InitialState();
        Collection cmaps = this.concurrentMapManager.maps.values();
        for (CMap cmap : cmaps) {
            initialState.createAndAddMapState(cmap);
        }
        this.concurrentMapManager.sendProcessableToAll(initialState, false);
        this.onMembershipChange(true);
    }

    Map<Address, List<Block>> getCurrentMemberBlocks() {
        HashMap<Address, List<Block>> addressBlocks = new HashMap<Address, List<Block>>();
        LinkedList<MemberImpl> lsMembers = this.concurrentMapManager.getMembers();
        for (MemberImpl member : lsMembers) {
            if (member.isSuperClient()) continue;
            addressBlocks.put(member.getAddress(), new ArrayList());
        }
        if (addressBlocks.size() > 0) {
            for (Block blockReal : this.blocks) {
                List ownedBlocks;
                if (blockReal == null || blockReal.isMigrating() || (ownedBlocks = (List)addressBlocks.get(blockReal.getOwner())) == null) continue;
                ownedBlocks.add(new Block(blockReal));
            }
        }
        return addressBlocks;
    }

    void sendBlocks(Block blockInfo) {
        if (blockInfo != null && blockInfo.isMigrating() && blockInfo.getMigrationAddress().equals(blockInfo.getOwner())) {
            blockInfo.setMigrationAddress(null);
        }
        for (int i = 0; i < this.PARTITION_COUNT; ++i) {
            Block block = this.blocks[i];
            if (block == null) {
                block = this.getOrCreateBlock(i);
            }
            if (block.getOwner() == null && !this.concurrentMapManager.isSuperClient()) {
                block.setOwner(this.thisAddress);
                continue;
            }
            if (block.getOwner() == null || !block.getOwner().equals(block.getMigrationAddress())) continue;
            block.setMigrationAddress(null);
        }
        Blocks allBlockOwners = new Blocks();
        for (Block block : this.blocks) {
            if (blockInfo != null && block.getBlockId() == blockInfo.getBlockId()) {
                allBlockOwners.addBlock(blockInfo);
                continue;
            }
            allBlockOwners.addBlock(block);
        }
        allBlockOwners.setNode(this.node);
        Data dataAllBlocks = ThreadContext.get().toData(allBlockOwners);
        for (MemberImpl member : this.concurrentMapManager.getMembers()) {
            if (!member.localMember()) {
                this.concurrentMapManager.send("blocks", ClusterOperation.CONCURRENT_MAP_BLOCKS, dataAllBlocks, member.getAddress());
                continue;
            }
            allBlockOwners.process();
        }
    }

    public void onMembershipChange(boolean add) {
        this.lsBlocksToMigrate.clear();
        this.backupIfNextOrPreviousChanged(add);
        if (this.concurrentMapManager.isMaster()) {
            this.sendBlocks(null);
        }
        this.nextMigrationMillis = System.currentTimeMillis() + this.MIGRATION_INTERVAL_MILLIS;
    }

    public void syncForDead(MemberImpl deadMember) {
        this.invalidateBlocksHash();
        this.partitionServiceImpl.reset();
        Address deadAddress = deadMember.getAddress();
        if (deadAddress == null || deadAddress.equals(this.thisAddress)) {
            return;
        }
        HashSet<Integer> blocksOwnedAfterDead = new HashSet<Integer>();
        for (Block block : this.blocks) {
            if (block == null) continue;
            this.syncForDead(deadMember, block);
            if (!this.thisAddress.equals(block.getOwner())) continue;
            blocksOwnedAfterDead.add(block.getBlockId());
        }
        Collection cmaps = this.concurrentMapManager.maps.values();
        for (CMap cmap : cmaps) {
            Object[] records;
            for (Object recordObject : records = cmap.mapRecords.values().toArray()) {
                if (recordObject == null) continue;
                Record record = (Record)recordObject;
                cmap.onDisconnect(record, deadAddress);
                if (!record.isActive() || !blocksOwnedAfterDead.contains(record.getBlockId())) continue;
                cmap.markAsDirty(record);
                cmap.updateIndexes(record);
            }
        }
        this.onMembershipChange(false);
    }

    void syncForDead(MemberImpl deadMember, Block block) {
        MemberImpl member;
        Address deadAddress = deadMember.getAddress();
        if (deadAddress.equals(block.getOwner())) {
            member = this.concurrentMapManager.getNextMemberBeforeSync(deadAddress, true, 1);
            if (member == null) {
                if (!this.concurrentMapManager.isSuperClient()) {
                    block.setOwner(this.thisAddress);
                } else {
                    block.setOwner(null);
                }
            } else if (!deadAddress.equals(member.getAddress()) && !this.concurrentMapManager.isSuperClient()) {
                block.setOwner(member.getAddress());
            } else {
                block.setOwner(null);
            }
            if (!block.isMigrating()) {
                MemberImpl currentOwner;
                MemberImpl memberImpl = currentOwner = block.getOwner() == null ? null : this.concurrentMapManager.getMember(block.getOwner());
                if (currentOwner != null) {
                    MigrationEvent migrationEvent = new MigrationEvent(this.concurrentMapManager.node, block.getBlockId(), deadMember, currentOwner);
                    this.partitionServiceImpl.doFireMigrationEvent(true, migrationEvent);
                    this.partitionServiceImpl.doFireMigrationEvent(false, migrationEvent);
                }
            }
        }
        if (block.isMigrating() && deadAddress.equals(block.getMigrationAddress())) {
            member = this.concurrentMapManager.getNextMemberBeforeSync(deadAddress, true, 1);
            if (member == null) {
                if (!this.concurrentMapManager.isSuperClient()) {
                    block.setMigrationAddress(this.thisAddress);
                } else {
                    block.setMigrationAddress(null);
                }
            } else if (!deadAddress.equals(member.getAddress())) {
                block.setMigrationAddress(member.getAddress());
            } else {
                block.setMigrationAddress(null);
            }
        }
        if (block.isMigrating() && block.getMigrationAddress().equals(block.getOwner())) {
            block.setMigrationAddress(null);
            MemberImpl currentOwner = block.getOwner() == null ? null : this.concurrentMapManager.getMember(block.getOwner());
            MigrationEvent migrationEvent = new MigrationEvent(this.concurrentMapManager.node, block.getBlockId(), deadMember, currentOwner);
            this.partitionServiceImpl.doFireMigrationEvent(true, migrationEvent);
            this.partitionServiceImpl.doFireMigrationEvent(false, migrationEvent);
        }
        this.partitionServiceImpl.reset();
    }

    void backupIfNextOrPreviousChanged(boolean add) {
        ArrayList<Record> lsOwnedRecords = new ArrayList<Record>(1000);
        Collection cmaps = this.concurrentMapManager.maps.values();
        for (CMap cmap : cmaps) {
            boolean shouldBackup = false;
            if (cmap.backupCount > 0) {
                if (add) {
                    shouldBackup = this.node.clusterManager.isNextChanged(cmap.backupCount);
                } else {
                    boolean bl = shouldBackup = this.node.clusterManager.isNextChanged(cmap.backupCount) || this.node.clusterManager.isPreviousChanged(cmap.backupCount);
                }
            }
            if (!shouldBackup) continue;
            for (Record rec : cmap.mapRecords.values()) {
                if (!rec.isActive()) continue;
                if (rec.getKeyData() == null || rec.getKeyData().size() == 0) {
                    throw new RuntimeException("Record.key is null or empty " + rec.getKeyData());
                }
                lsOwnedRecords.add(rec);
            }
        }
        if (!add) {
            this.logger.log(Level.FINEST, this.thisAddress + " will backup " + lsOwnedRecords.size());
        }
        for (final Record rec : lsOwnedRecords) {
            this.parallelExecutorBackups.execute(new FallThroughRunnable(){

                public void doRun() {
                    PartitionManager.this.concurrentMapManager.backupRecord(rec);
                }
            });
        }
    }

    void migrateBlock(final Block blockInfo) {
        Block blockReal = this.blocks[blockInfo.getBlockId()];
        if (!this.thisAddress.equals(blockInfo.getOwner())) {
            throw new RuntimeException(this.thisAddress + ". migrateBlock should be called from owner: " + blockInfo);
        }
        if (!blockInfo.isMigrating()) {
            throw new RuntimeException(this.thisAddress + ". migrateBlock cannot have non-migrating block: " + blockInfo);
        }
        if (blockInfo.getOwner().equals(blockInfo.getMigrationAddress())) {
            throw new RuntimeException(this.thisAddress + ". migrateBlock cannot have same owner and migrationAddress:" + blockInfo);
        }
        if (!this.node.isActive() || this.node.factory.restarted) {
            return;
        }
        if (this.concurrentMapManager.isSuperClient()) {
            return;
        }
        if (blockReal.isMigrationStarted()) {
            return;
        }
        blockReal.setMigrationStarted(true);
        blockReal.setOwner(blockInfo.getOwner());
        blockReal.setMigrationAddress(blockInfo.getMigrationAddress());
        this.logger.log(Level.FINEST, "migrate blockInfo " + blockInfo);
        ArrayList<Record> lsRecordsToMigrate = new ArrayList<Record>(1000);
        Collection cmaps = this.concurrentMapManager.maps.values();
        for (CMap cmap : cmaps) {
            for (Record rec : cmap.mapRecords.values()) {
                if (!rec.isActive() || !this.concurrentMapManager.isOwned(rec)) continue;
                if (rec.getKeyData() == null || rec.getKeyData().size() == 0) {
                    throw new RuntimeException("Record.key is null or empty " + rec.getKeyData());
                }
                if (rec.getBlockId() != blockInfo.getBlockId()) continue;
                cmap.onMigrate(rec);
                Record recordCopy = rec.copy();
                lsRecordsToMigrate.add(recordCopy);
                cmap.markAsEvicted(rec);
            }
        }
        this.logger.log(Level.FINEST, "Migrating [" + lsRecordsToMigrate.size() + "] " + blockInfo);
        final CountDownLatch latch = new CountDownLatch(lsRecordsToMigrate.size());
        for (final Record rec : lsRecordsToMigrate) {
            final CMap cmap = this.concurrentMapManager.getMap(rec.getName());
            this.parallelExecutorMigration.execute(new FallThroughRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void doRun() {
                    try {
                        PartitionManager.this.concurrentMapManager.migrateRecord(cmap, rec);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        this.parallelExecutorMigration.execute(new FallThroughRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void doRun() {
                block4: {
                    try {
                        PartitionManager.this.logger.log(Level.FINEST, "migrate blockInfo " + blockInfo + " await ");
                        latch.await(10L, TimeUnit.SECONDS);
                        if (PartitionManager.this.MIGRATION_COMPLETE_WAIT_SECONDS <= 0) break block4;
                        Thread.sleep(PartitionManager.this.MIGRATION_COMPLETE_WAIT_SECONDS * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        PartitionManager.this.concurrentMapManager.enqueueAndReturn(new Processable(){

                            public void process() {
                                blockInfo.setOwner(blockInfo.getMigrationAddress());
                                blockInfo.setMigrationAddress(null);
                                PartitionManager.this.completeMigration(blockInfo.getBlockId());
                                PartitionManager.this.sendCompletionInfo(blockInfo);
                            }
                        });
                        catch (Throwable throwable) {
                            PartitionManager.this.concurrentMapManager.enqueueAndReturn(new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                    }
                }
                PartitionManager.this.concurrentMapManager.enqueueAndReturn(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    void sendCompletionInfo(Block blockInfo) {
        for (MemberImpl member : this.concurrentMapManager.lsMembers) {
            if (member.localMember()) continue;
            this.concurrentMapManager.sendBlockInfo(new Block(blockInfo), member.getAddress());
        }
    }

    void completeMigration(int blockId) {
        this.invalidateBlocksHash();
        Block blockReal = this.blocks[blockId];
        if (blockReal != null && blockReal.isMigrating()) {
            this.fireMigrationEvent(false, new Block(blockReal));
            blockReal.setOwner(blockReal.getMigrationAddress());
            blockReal.setMigrationAddress(null);
            this.logger.log(Level.FINEST, "Migration complete info : " + blockReal);
            this.nextMigrationMillis = System.currentTimeMillis() + this.MIGRATION_INTERVAL_MILLIS;
        }
    }

    void handleBlocks(Blocks blockOwners) {
        for (Block block : blockOwners.lsBlocks) {
            Block blockReal = this.getOrCreateBlock(block.getBlockId());
            boolean same = this.sameBlocks(block, blockReal);
            blockReal.setOwner(block.getOwner());
            blockReal.setMigrationAddress(block.getMigrationAddress());
            if (this.thisAddress.equals(blockReal.getOwner()) && blockReal.isMigrating()) {
                this.startMigration(new Block(block));
            } else if (!same && block.getOwner() != null) {
                boolean started = blockReal.isMigrating();
                if (started) {
                    this.fireMigrationEvent(started, new Block(block));
                } else {
                    this.fireMigrationEvent(started, new Block(block.getBlockId(), null, block.getOwner()));
                }
            }
            if (same) continue;
            this.invalidateBlocksHash();
        }
    }

    Block getOrCreateBlock(int blockId) {
        this.concurrentMapManager.checkServiceThread();
        Block block = this.blocks[blockId];
        if (block == null) {
            this.blocks[blockId] = block = new Block(blockId, null);
            this.invalidateBlocksHash();
            if (this.concurrentMapManager.isMaster() && !this.concurrentMapManager.isSuperClient()) {
                block.setOwner(this.thisAddress);
            }
        }
        return block;
    }

    final void invalidateBlocksHash() {
        this.blocksHash = Integer.MIN_VALUE;
        this.partitionServiceImpl.reset();
    }

    final int hashBlocks() {
        if (this.blocksHash == Integer.MIN_VALUE) {
            int hash = 1;
            for (int i = 0; i < this.PARTITION_COUNT; ++i) {
                Block block = this.blocks[i];
                hash = hash * 31 + (block == null ? 0 : block.customHash());
            }
            this.blocksHash = hash;
        }
        return this.blocksHash;
    }

    void startMigration(Block block) {
        this.logger.log(Level.FINEST, "Migration Started " + block);
        this.fireMigrationEvent(true, new Block(block));
        this.migrateBlock(block);
    }

    boolean sameBlocks(Block b1, Block b2) {
        if (b1.getBlockId() != b2.getBlockId()) {
            throw new IllegalArgumentException("Not the same blocks!");
        }
        if (b1.getOwner() == null) {
            return b2.getOwner() == null;
        }
        if (!b1.getOwner().equals(b2.getOwner())) {
            return false;
        }
        if (b1.getMigrationAddress() == null) {
            return b2.getMigrationAddress() == null;
        }
        return b1.getMigrationAddress().equals(b2.getMigrationAddress());
    }

    void fireMigrationEvent(boolean started, Block block) {
        if (this.node.isMaster()) {
            this.migrationStartTime = started ? System.currentTimeMillis() : 0L;
        }
        MemberImpl memberOwner = this.concurrentMapManager.getMember(block.getOwner());
        MemberImpl memberMigration = this.concurrentMapManager.getMember(block.getMigrationAddress());
        MigrationEvent migrationEvent = new MigrationEvent(this.concurrentMapManager.node, block.getBlockId(), memberOwner, memberMigration);
        this.partitionServiceImpl.doFireMigrationEvent(started, migrationEvent);
    }
}

