/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatApplication {
    private String username;
    private final IMap<String, ChatMessage> map = Hazelcast.getMap("chat-application");

    public static void main(String[] args) {
        ChatApplication application = new ChatApplication();
        System.out.println("enter username:");
        StringBuilder u = new StringBuilder();
        try {
            int input;
            while ((input = System.in.read()) != 10) {
                u.append((char)input);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("hello " + u.toString());
        application.setUsername(u.toString());
        application.run();
    }

    public void setUsername(String name) {
        this.username = name;
        new ChatMessage(this.username, "has joined").send(this.map);
    }

    public void run() {
        boolean chatting = true;
        this.showConnected(this.map);
        this.map.addEntryListener(new ChatCallback(), true);
        while (chatting) {
            StringBuilder message = new StringBuilder();
            try {
                int input;
                while ((input = System.in.read()) != 10) {
                    message.append((char)input);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ChatMessage chat = new ChatMessage(this.username, message.toString());
            chat.send(this.map);
        }
    }

    private void showConnected(IMap<String, ChatMessage> map) {
        for (String user : map.keySet()) {
            System.out.println(user + " is online");
        }
    }

    private class ChatCallback
    implements EntryListener {
        public void entryAdded(EntryEvent event) {
            if (!ChatApplication.this.username.equals(event.getKey())) {
                System.out.println(event.getValue());
            }
        }

        public void entryRemoved(EntryEvent event) {
            if (!ChatApplication.this.username.equals(event.getKey())) {
                System.out.println(event.getKey() + " left");
            }
        }

        public void entryUpdated(EntryEvent event) {
            if (!ChatApplication.this.username.equals(event.getKey())) {
                System.out.println(event.getValue().toString());
            }
        }

        public void entryEvicted(EntryEvent event) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChatMessage
    implements Serializable {
        private String username;
        private String message;

        public ChatMessage(String username, String message) {
            this.username = username;
            this.message = message;
        }

        public String toString() {
            return this.username + ": " + this.message;
        }

        public void send(IMap<String, ChatMessage> map) {
            map.put(this.username, this);
        }
    }
}

