/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.nio.Address;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CallHistory {
    Map<Address, CallerCallHistory> mapCallerHistory = new HashMap<Address, CallerCallHistory>(100);

    CallerCallHistory getOrCreateCallerCallHistory(Address address) {
        CallerCallHistory ch = this.mapCallerHistory.get(address);
        if (ch == null) {
            ch = new CallerCallHistory(address);
            this.mapCallerHistory.put(address, ch);
        }
        return ch;
    }

    CallerCallHistory getCallerCallHistory(Address address) {
        return this.mapCallerHistory.get(address);
    }

    public CallerThreadState getOrCreateCallerThreadState(Address caller, int threadId) {
        CallerCallHistory ch = this.getOrCreateCallerCallHistory(caller);
        return ch.getOrCreateCallerThreadState(threadId);
    }

    public static class CallerThreadState
    implements Serializable {
        final Address caller;
        final int threadId;
        ClusterOperation operation;
        long callId;
        CallState callState = CallState.RECEIVED;
        Object response;
        String name;

        CallerThreadState(Address caller, int threadId) {
            this.caller = caller;
            this.threadId = threadId;
        }

        void set(String name, long callId, ClusterOperation operation) {
            this.name = name;
            this.callId = callId;
            this.operation = operation;
        }

        public CallState getCallState() {
            return this.callState;
        }

        public void setCallState(CallState callState) {
            this.callState = callState;
        }

        public void setScheduled() {
            this.callState = CallState.SCHEDULED;
        }

        public void setReplied() {
            this.callState = CallState.REPLIED;
        }

        public long getCallId() {
            return this.callId;
        }

        public ClusterOperation getOperation() {
            return this.operation;
        }

        public int getThreadId() {
            return this.threadId;
        }

        public Address getCaller() {
            return this.caller;
        }

        public Object getResponse() {
            return this.response;
        }

        public void setResponse(Object response) {
            this.response = response;
        }

        public String toString() {
            return "CallerThreadState{name=" + this.name + ", caller=" + this.caller + ", threadId=" + this.threadId + ", callId=" + this.callId + ", operation=" + (Object)((Object)this.operation) + ", callState=" + (Object)((Object)this.callState) + ", response=" + this.response + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CallState {
        RECEIVED,
        SCHEDULED,
        REPLIED,
        UNKNOWN;

    }

    public class CallerCallHistory {
        final Address caller;
        final Map<Integer, CallerThreadState> mapThreadIdCallStatus = new HashMap<Integer, CallerThreadState>(100);

        CallerCallHistory(Address caller) {
            this.caller = caller;
        }

        public CallerThreadState getOrCreateCallerThreadState(int threadId) {
            CallerThreadState cts = this.mapThreadIdCallStatus.get(threadId);
            if (cts == null) {
                cts = new CallerThreadState(this.caller, threadId);
                this.mapThreadIdCallStatus.put(threadId, cts);
            }
            return cts;
        }

        public CallerThreadState getCallerThreadState(int threadId) {
            return this.mapThreadIdCallStatus.get(threadId);
        }
    }
}

