/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.LocalQueueOperationStatsImpl;
import com.hazelcast.monitor.LocalQueueOperationStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalQueueStatsImpl
implements LocalQueueStats,
DataSerializable {
    private int ownedItemCount;
    private int backupItemCount;
    private long minAge;
    private long maxAge;
    private long aveAge;
    private LocalQueueOperationStats queueOperationStats;

    public LocalQueueStatsImpl() {
    }

    public LocalQueueStatsImpl(int ownedItemCount, int backupItemCount, long minAge, long maxAge, long aveAge) {
        this.ownedItemCount = ownedItemCount;
        this.backupItemCount = backupItemCount;
        this.minAge = minAge;
        this.maxAge = maxAge;
        this.aveAge = aveAge;
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.ownedItemCount);
        out.writeInt(this.backupItemCount);
        out.writeLong(this.minAge);
        out.writeLong(this.maxAge);
        out.writeLong(this.aveAge);
        this.queueOperationStats.writeData(out);
    }

    public void readData(DataInput in) throws IOException {
        this.ownedItemCount = in.readInt();
        this.backupItemCount = in.readInt();
        this.minAge = in.readLong();
        this.maxAge = in.readLong();
        this.aveAge = in.readLong();
        this.queueOperationStats = new LocalQueueOperationStatsImpl();
        this.queueOperationStats.readData(in);
    }

    public int getOwnedItemCount() {
        return this.ownedItemCount;
    }

    public int getBackupItemCount() {
        return this.backupItemCount;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public long getMinAge() {
        return this.minAge;
    }

    public long getAveAge() {
        return this.aveAge;
    }

    public LocalQueueOperationStats getOperationStats() {
        return this.queueOperationStats;
    }

    public void setOperationStats(LocalQueueOperationStats operationStats) {
        this.queueOperationStats = operationStats;
    }

    public String toString() {
        return "LocalQueueStatsImpl{aveAge=" + this.aveAge + ", ownedItemCount=" + this.ownedItemCount + ", backupItemCount=" + this.backupItemCount + ", minAge=" + this.minAge + ", maxAge=" + this.maxAge + ", queueOperationStats=" + this.queueOperationStats + '}';
    }
}

