/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Transaction;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.Serializer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadContext {
    private static final ThreadLocal<ThreadContext> threadLocal = new ThreadLocal();
    private static final AtomicInteger newThreadId = new AtomicInteger();
    private static final List<ThreadContext> threadContexts = new CopyOnWriteArrayList<ThreadContext>();
    private final Thread thread;
    private final Serializer serializer = new Serializer();
    private final ConcurrentMap<FactoryImpl, CallCache> mapCallCacheForFactories = new ConcurrentHashMap<FactoryImpl, CallCache>();
    private volatile CallContext callContext = null;
    private volatile FactoryImpl currentFactory = null;

    private ThreadContext(Thread thread) {
        this.thread = thread;
        this.setCallContext(new CallContext(this.createNewThreadId(), false));
    }

    public static ThreadContext get() {
        ThreadContext threadContext = threadLocal.get();
        if (threadContext == null) {
            threadContext = new ThreadContext(Thread.currentThread());
            threadLocal.set(threadContext);
            threadContexts.add(threadContext);
            for (ThreadContext context : threadContexts) {
                if (context.thread.isAlive()) continue;
                context.cleanup();
                threadContexts.remove(context);
            }
        }
        return threadContext;
    }

    public static void shutdownAll() {
        ThreadContext.get().cleanup();
        for (ThreadContext threadContext : threadContexts) {
            threadContext.cleanup();
        }
        threadContexts.clear();
    }

    public void cleanup() {
        this.mapCallCacheForFactories.clear();
        CallContext currentCallContext = this.callContext;
        if (currentCallContext != null) {
            currentCallContext.reset();
        }
    }

    public void finalizeTxn() {
        this.getCallContext().finalizeTransaction();
    }

    public Transaction getTransaction() {
        return this.getCallContext().getTransaction();
    }

    public long getTxnId() {
        return this.getCallContext().getTxnId();
    }

    public FactoryImpl getCurrentFactory() {
        return this.currentFactory;
    }

    public void setCurrentFactory(FactoryImpl currentFactory) {
        this.currentFactory = currentFactory;
    }

    public void reset() {
        this.finalizeTxn();
    }

    public byte[] toByteArray(Object obj) {
        return this.serializer.toByteArray(obj);
    }

    public Data toData(Object obj) {
        return this.serializer.writeObject(obj);
    }

    public Object toObject(Data data) {
        return this.serializer.readObject(data);
    }

    public CallCache getCallCache(FactoryImpl factory) {
        CallCache callCache = (CallCache)this.mapCallCacheForFactories.get(factory);
        if (callCache == null) {
            callCache = new CallCache(factory);
            this.mapCallCacheForFactories.put(factory, callCache);
        }
        return callCache;
    }

    public boolean isClient() {
        return this.getCallContext().isClient();
    }

    public int createNewThreadId() {
        return newThreadId.incrementAndGet();
    }

    public CallContext getCallContext() {
        return this.callContext;
    }

    public int getThreadId() {
        return this.getCallContext().getThreadId();
    }

    public void setCallContext(CallContext callContext) {
        this.callContext = callContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadContext that = (ThreadContext)o;
        return !(this.thread != null ? !this.thread.equals(that.thread) : that.thread != null);
    }

    public int hashCode() {
        return this.thread != null ? this.thread.hashCode() : 0;
    }

    class CallCache {
        final FactoryImpl factory;
        final ConcurrentMapManager.MPut mput;
        final ConcurrentMapManager.MGet mget;
        final ConcurrentMapManager.MRemove mremove;
        final ConcurrentMapManager.MEvict mevict;

        CallCache(FactoryImpl factory) {
            this.factory = factory;
            this.mput = factory.node.concurrentMapManager.new ConcurrentMapManager.MPut();
            this.mget = factory.node.concurrentMapManager.new ConcurrentMapManager.MGet();
            this.mremove = factory.node.concurrentMapManager.new ConcurrentMapManager.MRemove();
            this.mevict = factory.node.concurrentMapManager.new ConcurrentMapManager.MEvict();
        }

        public ConcurrentMapManager.MPut getMPut() {
            this.mput.reset();
            return this.mput;
        }

        public ConcurrentMapManager.MGet getMGet() {
            this.mget.reset();
            return this.mget;
        }

        public ConcurrentMapManager.MRemove getMRemove() {
            this.mremove.reset();
            return this.mremove;
        }

        public ConcurrentMapManager.MEvict getMEvict() {
            this.mevict.reset();
            return this.mevict;
        }
    }
}

