/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.rest;

import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.impl.ascii.rest.HttpCommand;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public class HttpGetCommand
extends HttpCommand {
    boolean nextLine = false;

    public HttpGetCommand(String uri) {
        super(TextCommandConstants.TextCommandType.HTTP_GET, uri);
    }

    public boolean doRead(ByteBuffer cb) {
        while (cb.hasRemaining()) {
            char c = (char)cb.get();
            if (c == '\n') {
                if (this.nextLine) {
                    return true;
                }
                this.nextLine = true;
                continue;
            }
            if (c == '\r') continue;
            this.nextLine = false;
        }
        return false;
    }

    public void setResponse(byte[] contentType, byte[] value) {
        int valueSize = value == null ? 0 : value.length;
        byte[] len = String.valueOf(valueSize).getBytes();
        int size = RES_200.length;
        if (contentType != null) {
            size += CONTENT_TYPE.length;
            size += contentType.length;
            size += RETURN.length;
        }
        size += CONTENT_LENGTH.length;
        size += len.length;
        size += RETURN.length;
        size += RETURN.length;
        size += valueSize;
        this.response = ByteBuffer.allocate(size += RETURN.length);
        this.response.put(RES_200);
        if (contentType != null) {
            this.response.put(CONTENT_TYPE);
            this.response.put(contentType);
            this.response.put(RETURN);
        }
        this.response.put(CONTENT_LENGTH);
        this.response.put(len);
        this.response.put(RETURN);
        this.response.put(RETURN);
        if (value != null) {
            this.response.put(value);
        }
        this.response.put(RETURN);
        this.response.flip();
    }

    public boolean writeTo(ByteBuffer bb) {
        IOUtil.copyToHeapBuffer(this.response, bb);
        return !this.response.hasRemaining();
    }

    public void sendClusterInfo() {
    }
}

